/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.trainer;

import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerClientMyState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import java.util.List;

public class DevolutionSpray
extends BaseTrainerEffect {
    public DevolutionSpray() {
        super("devolution_spray");
    }

    @Override
    public boolean canPlay(GameClientState client) {
        return !this.getCardSelectorStateForEvolutionCard(client).getCardList().isEmpty();
    }

    @Override
    public CardSelectorState getSelectorState(TrainerCardState trainer, GameServerState server) {
        if (trainer.getParameters().isEmpty()) {
            return this.getCardSelectorStateForEvolutionCard(new GameClientState(server));
        }
        PokemonCardState pokemon = (PokemonCardState)trainer.getParameters().get(0);
        CardSelectorState selectorState = new CardSelectorState(1, 1, CardSelectorDisplay.Discard, false, "card.BS72.effect.selector.chooseevolution");
        selectorState.getCardList().add(new CardWithLocation(pokemon, true, BoardLocation.Attachment, 0));
        pokemon.getAttachments().stream().filter(card -> card.getData().isEvolution() && this.hasLowerEvolution(card.getData().getPreviousEvolutionDexID(), pokemon.getAttachments())).forEach(card -> selectorState.getCardList().add(new CardWithLocation((CommonCardState)card, true, BoardLocation.Attachment, 0)));
        return selectorState;
    }

    @Override
    public boolean canApply(TrainerCardState trainer, GameServerState server) {
        return trainer.getParameters().size() == 2;
    }

    @Override
    public void apply(TrainerCardState trainer, GameServerState server) {
        PlayerServerState player = server.getPlayer(server.getCurrentTurn());
        PokemonCardState pokemon = (PokemonCardState)trainer.getParameters().get(0);
        CommonCardState card = trainer.getParameters().get(1);
        PokemonCardState retain = this.getLowerEvolution(card.getData().getPreviousEvolutionDexID(), pokemon.getAttachments());
        pokemon.getAttachments().remove(retain);
        if (card != pokemon) {
            PokemonCardState next = this.getLowerEvolution(pokemon.getData().getPreviousEvolutionDexID(), pokemon.getAttachments());
            while (next != card && next != null) {
                pokemon.getAttachments().remove(next);
                player.getDiscardPile().add(next.getData());
                next = this.getLowerEvolution(next.getData().getPreviousEvolutionDexID(), pokemon.getAttachments());
            }
            pokemon.getAttachments().remove(card);
            player.getDiscardPile().add(card.getData());
        }
        player.getDiscardPile().add(pokemon.getData());
        PokemonCardState newPokemon = new PokemonCardState(retain.getData(), server.getCurrentTurn());
        newPokemon.getStatus().setDamage(pokemon.getStatus().getDamage());
        newPokemon.getAttachments().addAll(pokemon.getAttachments());
        if (pokemon == player.getActiveCard()) {
            player.setActiveCard(newPokemon);
        } else {
            for (int i = 0; i < player.getBenchCards().length; ++i) {
                if (player.getBenchCards()[i] != pokemon) continue;
                player.getBenchCards()[i] = newPokemon;
            }
        }
    }

    private CardSelectorState getCardSelectorStateForEvolutionCard(GameClientState client) {
        CardSelectorState selectorState = new CardSelectorState(1, 1, CardSelectorDisplay.Select, false, "card.BS72.effect.selector.choosepokemon");
        PlayerClientMyState player = client.getMe();
        if (player.getActiveCard().getData().isEvolution() && this.hasLowerEvolution(player.getActiveCard().getData().getPreviousEvolutionDexID(), player.getActiveCard().getAttachments())) {
            selectorState.getCardList().add(new CardWithLocation(player.getActiveCard(), true, BoardLocation.Active, 0));
        }
        for (int i = 0; i < player.getBenchCards().length; ++i) {
            if (player.getBenchCards()[i] == null || !player.getBenchCards()[i].getData().isEvolution() || !this.hasLowerEvolution(player.getBenchCards()[i].getData().getPreviousEvolutionDexID(), player.getBenchCards()[i].getAttachments())) continue;
            selectorState.getCardList().add(new CardWithLocation(player.getBenchCards()[i], true, BoardLocation.Bench, 0));
        }
        return selectorState;
    }

    private boolean hasLowerEvolution(int pokemonId, List<CommonCardState> attachments) {
        return this.getLowerEvolution(pokemonId, attachments) != null;
    }

    private PokemonCardState getLowerEvolution(int pokemonId, List<CommonCardState> attachments) {
        while (pokemonId != 0) {
            for (CommonCardState attachment : attachments) {
                if (!(attachment instanceof PokemonCardState) || attachment.isEnergyEquivalence() || attachment.getData().getPokemonID() != pokemonId) continue;
                return (PokemonCardState)attachment;
            }
            ImmutableCard card = Cards.fromPokemonID(pokemonId);
            if (card == null) {
                return null;
            }
            pokemonId = card.getPreviousEvolutionDexID();
        }
        return null;
    }

    @Override
    public boolean canSkipSelector() {
        return false;
    }

    @Override
    public void applySkipSelector(TrainerCardState trainer, PokemonCardState pokemon, GameServerState server, BoardLocation b, int p) {
    }
}

