/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.trainer;

import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;

public class Defender
extends BaseTrainerEffect {
    public Defender() {
        super("defender");
    }

    @Override
    public boolean canPlay(GameClientState client) {
        return true;
    }

    @Override
    public boolean canApply(TrainerCardState trainer, GameServerState server) {
        return true;
    }

    @Override
    public void apply(TrainerCardState trainer, GameServerState server) {
        server.getPlayer(server.getCurrentTurn()).getActiveCard().getAttachments().add(trainer);
    }

    @Override
    public int modifyDamage(int damage, TrainerCardState trainer, GameServerState server) {
        if (server.getPlayer(server.getNextTurn()).getActiveCard().getAttachments().contains(trainer)) {
            return Math.max(0, damage - 20);
        }
        return damage;
    }

    @Override
    public boolean preventDiscard() {
        return true;
    }

    @Override
    public void handleEndTurn(TrainerCardState trainer, PokemonCardState card, PlayerServerState player, GameServerState server) {
        if (server.getPlayer(server.getNextTurn()) == player) {
            card.getAttachments().remove(trainer);
            player.getDiscardPile().add(trainer.getData());
        }
    }

    @Override
    public boolean canPlaceOn(CardWithLocation card) {
        return card != null && card.getCard() != null && card.isMine() && card.getLocation() == BoardLocation.Active;
    }

    @Override
    public boolean canSkipSelector() {
        return true;
    }

    @Override
    public void applySkipSelector(TrainerCardState trainer, PokemonCardState pokemon, GameServerState server, BoardLocation b, int p) {
        server.getPlayer(server.getCurrentTurn()).getActiveCard().getAttachments().add(trainer);
    }
}

