/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.state;

import com.pixelmonmod.tcg.api.card.CardCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PokemonCardStatus {
    private static final int NULL_VALUE = -100;
    private int damage = 0;
    private List<Pair<CardCondition, Integer>> conditions = new ArrayList<Pair<CardCondition, Integer>>();
    private List<Pair<CardCondition, Integer>> clonedConditions = new ArrayList<Pair<CardCondition, Integer>>();
    private boolean damageImmune;
    private boolean conditionImmune;
    private boolean startTurnParalyzed = false;

    public PokemonCardStatus() {
    }

    public PokemonCardStatus(FriendlyByteBuf buf) {
        this.damage = buf.readInt();
        int effectSize = buf.readInt();
        for (int i = 0; i < effectSize; ++i) {
            int statusOrdinal = buf.readInt();
            Integer modifier = buf.readInt();
            this.conditions.add((Pair<CardCondition, Integer>)new MutablePair((Object)CardCondition.values()[statusOrdinal], (Object)(modifier == -100 ? null : modifier)));
        }
        this.damageImmune = buf.readBoolean();
        this.conditionImmune = buf.readBoolean();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.damage);
        buf.writeInt(this.conditions.size());
        for (Pair<CardCondition, Integer> effect : this.conditions) {
            buf.writeInt(((CardCondition)((Object)effect.getLeft())).ordinal());
            buf.writeInt(effect.getRight() == null ? -100 : (Integer)effect.getRight());
        }
        buf.writeBoolean(this.damageImmune);
        buf.writeBoolean(this.conditionImmune);
    }

    public List<Pair<CardCondition, Integer>> getConditions() {
        return this.conditions;
    }

    public void cloneConditions() {
        this.clonedConditions = new ArrayList<Pair<CardCondition, Integer>>();
        if (this.conditions != null) {
            this.clonedConditions.addAll(this.conditions.stream().map(pair -> new ImmutablePair((Object)((CardCondition)((Object)((Object)pair.getLeft()))), (Object)((Integer)pair.getRight()))).collect(Collectors.toList()));
        }
    }

    public List<Pair<CardCondition, Integer>> getClonedConditions() {
        return this.clonedConditions;
    }

    public int getDamage() {
        return this.damage;
    }

    public void healDamage(int d) {
        this.setDamage(this.damage - d);
    }

    public void setDamage(int d) {
        this.damage = d < 0 ? 0 : d;
    }

    public boolean hasCondition(CardCondition cardCondition) {
        return this.conditions.stream().anyMatch(c -> c.getLeft() == cardCondition);
    }

    public void addCondition(CardCondition cardCondition, Integer modifier) {
        Optional<Pair> currentCondition;
        if (this.isConditionImmune()) {
            return;
        }
        if (cardCondition == CardCondition.ASLEEP || cardCondition == CardCondition.CONFUSED || cardCondition == CardCondition.PARALYZED) {
            List overlaps = this.conditions.stream().filter(c -> c.getLeft() == CardCondition.ASLEEP || c.getLeft() == CardCondition.CONFUSED || c.getLeft() == CardCondition.PARALYZED).collect(Collectors.toList());
            for (Pair overlap : overlaps) {
                this.conditions.remove(overlap);
            }
        }
        if (cardCondition == CardCondition.PARALYZED) {
            this.startTurnParalyzed = false;
        }
        if ((currentCondition = this.conditions.stream().filter(c -> c.getLeft() == cardCondition).findFirst()).isPresent() && modifier != null) {
            currentCondition.get().setValue((Object)modifier);
        } else {
            this.conditions.add((Pair<CardCondition, Integer>)new MutablePair((Object)cardCondition, (Object)modifier));
        }
    }

    public void removeCondition(CardCondition cardCondition) {
        Optional<Pair> currentStatus = this.conditions.stream().filter(s -> s.getLeft() == cardCondition).findFirst();
        if (currentStatus.isPresent()) {
            this.conditions.remove(currentStatus.get());
        }
    }

    public void removeAllConditions() {
        this.conditions = new ArrayList<Pair<CardCondition, Integer>>();
    }

    public boolean isStartTurnParalyzed() {
        return this.startTurnParalyzed;
    }

    public void setStartTurnParalyzed(boolean startTurnParalyzed) {
        this.startTurnParalyzed = startTurnParalyzed;
    }

    public boolean isDamageImmune() {
        return this.damageImmune;
    }

    public void setDamageImmune(boolean damageImmune) {
        this.damageImmune = damageImmune;
    }

    public boolean isConditionImmune() {
        return this.conditionImmune;
    }

    public void setConditionImmune(boolean conditionImmune) {
        this.conditionImmune = conditionImmune;
    }
}

