/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.state;

import com.pixelmonmod.tcg.api.accessors.CardAttacks;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.StringUtils;

public class PokemonAttackStatus {
    public static final int INFINITE_TURN_COUNT = 1000000;
    private CardAttack cardAttack;
    private boolean isDisabled;
    private int disabledTurnCountLeft;
    private int damageBonus;
    private int damageBonusCountLeft;
    private BaseAttackEffect temporaryEffect;
    private String temporaryEffectText;
    private int damage;
    private boolean isMissed;

    public PokemonAttackStatus(CardAttack cardAttack) {
        this.cardAttack = cardAttack;
        this.resetDamage();
    }

    public PokemonAttackStatus(FriendlyByteBuf buf) {
        this.cardAttack = CardAttacks.get(buf.m_130277_());
        this.isDisabled = buf.readBoolean();
        this.disabledTurnCountLeft = buf.readInt();
        this.damageBonus = buf.readInt();
        this.damageBonusCountLeft = buf.readInt();
        if (buf.readBoolean()) {
            this.temporaryEffectText = buf.m_130277_();
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.cardAttack.getID());
        buf.writeBoolean(this.isDisabled);
        buf.writeInt(this.disabledTurnCountLeft);
        buf.writeInt(this.damageBonus);
        buf.writeInt(this.damageBonusCountLeft);
        buf.writeBoolean(this.temporaryEffectText != null);
        if (this.temporaryEffectText != null) {
            buf.m_130070_(this.temporaryEffectText);
        }
    }

    public CardAttack getData() {
        return this.cardAttack;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void disable(int turnCount) {
        if (this.isDisabled) {
            if (this.disabledTurnCountLeft != 1000000 && this.disabledTurnCountLeft < turnCount) {
                this.disabledTurnCountLeft = turnCount;
            }
        } else {
            this.isDisabled = true;
            this.disabledTurnCountLeft = turnCount;
        }
    }

    public void enable() {
        this.isDisabled = false;
        this.disabledTurnCountLeft = 0;
    }

    public int getDisabledTurnCountLeft() {
        return this.disabledTurnCountLeft;
    }

    public void reduceTurnCount() {
        if (this.disabledTurnCountLeft > 0) {
            --this.disabledTurnCountLeft;
        }
        if (this.disabledTurnCountLeft == 0 && this.isDisabled) {
            this.isDisabled = false;
        }
        if (this.damageBonusCountLeft > 0) {
            --this.damageBonusCountLeft;
        }
        if (this.damageBonusCountLeft == 0) {
            this.damageBonus = 0;
        }
        this.isMissed = false;
    }

    public int getDamage() {
        return this.damage + this.damageBonus;
    }

    public void setDamage(int damage) {
        this.damage = Math.max(0, damage);
    }

    public void resetDamage() {
        this.damage = this.cardAttack.getDamage();
    }

    public int getDamageBonus() {
        return this.damageBonus;
    }

    public int getDamageBonusCountLeft() {
        return this.damageBonusCountLeft;
    }

    public void setDamageBonus(int damageBonus, int damageBonusCountLeft) {
        this.damageBonus = damageBonus;
        this.damageBonusCountLeft = damageBonusCountLeft;
    }

    public BaseAttackEffect getTemporaryEffect() {
        return this.temporaryEffect;
    }

    public String getTemporaryEffectText() {
        return this.temporaryEffectText;
    }

    public void setTemporaryEffect(BaseAttackEffect temporaryEffect, String effectText) {
        this.temporaryEffect = temporaryEffect;
        this.temporaryEffectText = effectText;
    }

    public boolean isMissed() {
        return this.isMissed;
    }

    public void setMissed(boolean missed) {
        this.isMissed = missed;
    }

    public boolean hasDescription() {
        return StringUtils.isNotBlank((CharSequence)this.cardAttack.getText()) || StringUtils.isNotBlank((CharSequence)this.temporaryEffectText);
    }

    public Component getLocalizedDescription() {
        MutableComponent text = Component.m_237113_((String)"");
        if (StringUtils.isNotBlank((CharSequence)this.cardAttack.getText())) {
            text.m_7220_((Component)Component.m_237115_((String)this.cardAttack.getText().toLowerCase()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.temporaryEffectText)) {
            text.m_7220_((Component)Component.m_237115_((String)this.temporaryEffectText.toLowerCase())).m_130946_(" " + text);
        }
        return text;
    }
}

