/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.state;

import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.tcg.api.card.CardRarity;
import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.ability.CardPower;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.PokemonCardStatus;
import com.pixelmonmod.tcg.network.ByteBufTCG;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;

public class CommonCardState {
    public List<CommonCardState> parameters = new ArrayList<CommonCardState>();
    protected ImmutableCard data;
    private int setId;
    private CardType cardType;
    private String code;
    private String name;
    private String description;
    private Energy energy1;
    private Energy energy2;
    private CardRarity cardRarity;
    private int pokemonId;
    private int hp;
    private ImmutableCard transformation;
    private Vector3f overrideModelColor;
    protected Energy overwriteEnergy = null;

    public CommonCardState(ImmutableCard data) {
        this.data = data;
        this.transform(data, null);
    }

    public void transform(ImmutableCard data, PokemonCardStatus status) {
        this.setId = data.getSetID();
        this.cardType = data.getCardType();
        this.pokemonId = data.getPokemonID();
        this.hp = data.getHP();
        this.name = data.getName();
        this.code = data.getCode();
        this.description = data.getDescription();
        this.energy1 = data.getMainEnergy();
        this.energy2 = data.getSecondaryEnergy();
        this.cardRarity = data.getRarity();
        this.transformation = data;
    }

    public CommonCardState(FriendlyByteBuf buf) {
        this.data = ByteBufTCG.readCard(buf);
        if (!this.data.isFaceDown()) {
            int energy2Index;
            int energy1Index;
            this.setId = buf.readInt();
            this.cardType = CardType.values()[buf.readInt()];
            this.pokemonId = buf.readInt();
            this.hp = buf.readInt();
            this.code = buf.m_130277_();
            this.name = buf.m_130277_();
            if (buf.readBoolean()) {
                this.description = buf.m_130277_();
            }
            if ((energy1Index = buf.readInt()) > -1) {
                this.energy1 = Energy.values()[energy1Index];
            }
            if ((energy2Index = buf.readInt()) > -1) {
                this.energy2 = Energy.values()[energy2Index];
            }
            this.cardRarity = CardRarity.values()[buf.readInt()];
            if (buf.readBoolean()) {
                this.overrideModelColor = new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat());
            }
            if (buf.readBoolean()) {
                this.transformation = ByteBufTCG.readCard(buf);
            }
        }
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            this.parameters.add(new CommonCardState(buf));
        }
        int overwriteIndex = buf.readInt();
        if (overwriteIndex >= 0) {
            this.overwriteEnergy = Energy.values()[overwriteIndex];
        }
    }

    public void write(FriendlyByteBuf buf, boolean faceUp) {
        this.write(buf, faceUp, true);
    }

    protected void write(FriendlyByteBuf buf, boolean faceUp, boolean writeParams) {
        if (faceUp) {
            ByteBufTCG.writeCard(buf, this.data);
            buf.writeInt(this.setId);
            buf.writeInt(this.cardType.ordinal());
            buf.writeInt(this.pokemonId);
            buf.writeInt(this.hp);
            buf.m_130070_(this.code);
            buf.m_130070_(this.name);
            buf.writeBoolean(this.description != null);
            if (this.description != null) {
                buf.m_130070_(this.description);
            }
            buf.writeInt(this.energy1 == null ? -1 : this.energy1.ordinal());
            buf.writeInt(this.energy2 == null ? -1 : this.energy2.ordinal());
            buf.writeInt(this.cardRarity.ordinal());
            buf.writeBoolean(this.overrideModelColor != null);
            if (this.overrideModelColor != null) {
                buf.writeFloat(this.overrideModelColor.x()).writeFloat(this.overrideModelColor.y()).writeFloat(this.overrideModelColor.z());
            }
            buf.writeBoolean(this.transformation != null);
            if (this.transformation != null) {
                ByteBufTCG.writeCard(buf, this.transformation);
            }
        } else {
            ByteBufTCG.writeFaceDownCard(buf);
        }
        if (writeParams) {
            buf.writeInt(this.parameters.size());
            for (CommonCardState card : this.parameters) {
                if (card instanceof PokemonCardState) {
                    ((PokemonCardState)card).writeAsCommonCardState(buf, faceUp, false);
                    continue;
                }
                card.write(buf, faceUp, false);
            }
        } else {
            buf.writeInt(0);
        }
        if (this.overwriteEnergy == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.overwriteEnergy.ordinal());
        }
    }

    public ImmutableCard getData() {
        return this.data;
    }

    public void setData(ImmutableCard data) {
        this.data = data;
    }

    public List<CommonCardState> getParameters() {
        return this.parameters;
    }

    public boolean isEnergyEquivalence() {
        return this.cardType == CardType.ENERGY || this.getAbility() != null && this.getAbility().getEffect() != null && !CommonCardState.isNullOrEmpty(this.getAbility().getEffect().getEnergyEquivalence(this));
    }

    protected static boolean isNullOrEmpty(List list) {
        return list == null || list.isEmpty();
    }

    public int getSetID() {
        return this.setId;
    }

    public void setSetID(int setId) {
        this.setId = setId;
    }

    public CardType getCardType() {
        return this.cardType;
    }

    public void setCardType(CardType cardType) {
        this.cardType = cardType;
    }

    public int getPokemonID() {
        return this.pokemonId;
    }

    public void setPokemonID(int pokemonId) {
        this.pokemonId = pokemonId;
    }

    public int getHP() {
        return this.hp;
    }

    public void setHP(int hp) {
        this.hp = hp;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CardPower getAbility() {
        return this.data.getAbility();
    }

    public Energy getMainEnergy() {
        if (this.overwriteEnergy != null) {
            return this.overwriteEnergy;
        }
        return this.energy1;
    }

    public Energy getSecondaryEnergy() {
        if (this.data.getSecondaryEnergy() != null && this.overwriteEnergy != null) {
            return this.overwriteEnergy;
        }
        return this.energy2;
    }

    public boolean hasTransformation() {
        return this.data != this.transformation;
    }

    public ImmutableCard getTransformation() {
        return this.transformation;
    }

    public void setOverwriteEnergy(Energy overwriteEnergy) {
        this.overwriteEnergy = overwriteEnergy;
    }

    public CardRarity getRarity() {
        return this.cardRarity;
    }

    public void setRarity(CardRarity cardRarity) {
        this.cardRarity = cardRarity;
    }

    public Vector3f getOverrideModelColor() {
        return this.overrideModelColor;
    }

    public void setOverrideModelColor(Vector3f overrideModelColor) {
        this.overrideModelColor = overrideModelColor;
    }

    public void handleEndTurn(PokemonCardState attachTo, PlayerServerState player, GameServerState server) {
        this.overwriteEnergy = null;
        if (this.getAbility() == null || this.getAbility().getEffect() == null || !this.getAbility().getEffect().holdParameters()) {
            this.parameters.clear();
        }
    }

    public ResourceLocation getPokemonSprite() {
        Optional<Species> species;
        if (this.getTransformation().getHasCustomTex()) {
            return this.getTransformation().getCustomTexture();
        }
        if (this.pokemonId > 0 && (species = PixelmonSpecies.fromDex(this.pokemonId)).isPresent()) {
            return species.get().getDefaultForm().getDefaultGenderProperties().getDefaultPalette().getSprite();
        }
        return null;
    }
}

