/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.state;

import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;

public class CardSelectorState {
    private int id;
    private List<CardWithLocation> cardList;
    private int minimumCount;
    private int maximumCount;
    private boolean countEnergy;
    private CardSelectorDisplay displayType;
    private boolean cancellable;
    private String customText;

    public CardSelectorState(int minimumCount, int maximumCount, CardSelectorDisplay displayType, boolean cancellable) {
        this(RandomHelper.getRandom().nextInt(10000), minimumCount, maximumCount, false, displayType, cancellable, null, new ArrayList<CardWithLocation>());
    }

    public CardSelectorState(int minimumCount, int maximumCount, CardSelectorDisplay displayType, boolean cancellable, String customText) {
        this(RandomHelper.getRandom().nextInt(10000), minimumCount, maximumCount, false, displayType, cancellable, customText, new ArrayList<CardWithLocation>());
    }

    public CardSelectorState(int minimumCount, int maximumCount, boolean countEnergy, CardSelectorDisplay displayType, boolean cancellable) {
        this(RandomHelper.getRandom().nextInt(10000), minimumCount, maximumCount, countEnergy, displayType, cancellable, null, new ArrayList<CardWithLocation>());
    }

    public CardSelectorState(int id, int minimumCount, int maximumCount, boolean countEnergy, CardSelectorDisplay displayType, boolean cancellable, String customText, List<CardWithLocation> cardList) {
        this.id = id;
        this.minimumCount = minimumCount;
        this.maximumCount = maximumCount;
        this.countEnergy = countEnergy;
        this.displayType = displayType;
        this.cancellable = cancellable;
        this.customText = customText;
        this.cardList = cardList == null ? new ArrayList() : cardList;
    }

    public CardSelectorState(FriendlyByteBuf buf) {
        this.id = buf.readInt();
        int count = buf.readInt();
        this.cardList = new ArrayList<CardWithLocation>();
        for (int i = 0; i < count; ++i) {
            if (!buf.readBoolean()) {
                this.cardList.add(new CardWithLocation(buf));
                continue;
            }
            this.cardList.add(null);
        }
        this.minimumCount = buf.readInt();
        this.maximumCount = buf.readInt();
        this.displayType = CardSelectorDisplay.values()[buf.readInt()];
        this.cancellable = buf.readBoolean();
        if (buf.readBoolean()) {
            this.customText = buf.m_130277_();
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.cardList.size());
        for (CardWithLocation aCardList : this.cardList) {
            if (aCardList == null) {
                buf.writeBoolean(true);
                continue;
            }
            buf.writeBoolean(false);
            aCardList.write(buf);
        }
        buf.writeInt(this.minimumCount);
        buf.writeInt(this.maximumCount);
        buf.writeInt(this.displayType.ordinal());
        buf.writeBoolean(this.cancellable);
        buf.writeBoolean(this.customText != null);
        if (this.customText != null) {
            buf.m_130070_(this.customText);
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public List<CardWithLocation> getCardList() {
        return this.cardList;
    }

    public void setCardList(List<CardWithLocation> cardList) {
        this.cardList = cardList;
    }

    public void addCard(CardWithLocation card) {
        this.cardList.add(card);
    }

    public int getMinimumCount() {
        return this.minimumCount;
    }

    public int getMaximumCount() {
        return this.maximumCount;
    }

    public boolean isCountEnergy() {
        return this.countEnergy;
    }

    public CardSelectorDisplay getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(CardSelectorDisplay displayType) {
        this.displayType = displayType;
    }

    public boolean isCancellable() {
        return this.cancellable;
    }

    public void setCancellable(boolean cancellable) {
        this.cancellable = cancellable;
    }

    public String getCustomText() {
        return this.customText;
    }

    public void setCustomText(String customText) {
        this.customText = customText;
    }
}

