/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.power;

import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.util.helper.LogicHelper;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.power.BasePowerEffect;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;

public class EvolutionaryLight
extends BasePowerEffect {
    public EvolutionaryLight() {
        super("EvolutionaryLight");
    }

    @Override
    public boolean canActivate(PokemonCardState pokemon, GameServerState client) {
        return this.findEvolutionCard(client) != null && pokemon.getParameters().size() == 1;
    }

    @Override
    public CardSelectorState getSelectorState(PokemonCardState pokemon, GameServerState server) {
        CardSelectorState selector = new CardSelectorState(1, 1, CardSelectorDisplay.Select, true);
        PlayerServerState currentPlayer = server.getCurrentPlayer();
        for (int i = 0; i < currentPlayer.getDeck().size(); ++i) {
            ImmutableCard immutableCard = currentPlayer.getDeck().get(i);
            if (!immutableCard.isEvolution()) continue;
            selector.addCard(new CardWithLocation(new CommonCardState(immutableCard), true, BoardLocation.Deck, i));
        }
        return selector;
    }

    @Override
    public void activate(PokemonCardState pokemon, GameServerState server, PlayerServerState player) {
        if (pokemon.getParameters().size() != 1) {
            return;
        }
        CommonCardState card = pokemon.getParameters().get(0);
        PlayerServerState currentPlayer = server.getPlayer(server.getCurrentTurn());
        currentPlayer.getDeck().remove(card.getData());
        currentPlayer.getHand().add(card.getData());
        LogicHelper.shuffleCardList(server.getCurrentPlayer().getDeck());
        CardSelectorState selector = new CardSelectorState(0, 0, CardSelectorDisplay.Reveal, false, "trainer.evolutionarylight.selector.reveal");
        selector.getCardList().add(new CardWithLocation(card, true, BoardLocation.Deck, 0));
        server.getPlayer(server.getNextTurn()).setCardSelectorState(selector);
    }

    private ImmutableCard findEvolutionCard(GameServerState client) {
        for (ImmutableCard immutableCard : client.getCurrentPlayer().getDeck()) {
            if (!immutableCard.isEvolution()) continue;
            return immutableCard;
        }
        return null;
    }
}

