/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.attack.effects;

import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.attack.enums.CoinSide;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.List;

public abstract class BaseAttackEffectWithOptionalFlip
extends BaseAttackEffect {
    protected CoinSide needCoinSide;

    public BaseAttackEffectWithOptionalFlip(String ... name) {
        super(name);
    }

    @Override
    public List<CoinSide> flipCoin(List<CoinSide> currentResult, PokemonCardState pokemon, GameServerState server) {
        if (this.needCoinSide == null || currentResult.size() >= 1) {
            return currentResult;
        }
        currentResult.add(CoinSide.getRandom());
        return currentResult;
    }

    @Override
    public final void applyBeforeDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server) {
        if (this.isCorrectCoinSide(server)) {
            this.applyOnCorrectCoinSideBeforeDamage(parameters, attack, card, server);
        }
    }

    @Override
    public void applyAfterDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server, int finalDamage) {
        if (this.isCorrectCoinSide(server)) {
            this.applyOnCorrectCoinSideAfterDamage(parameters, attack, card, server);
        }
    }

    public void applyOnCorrectCoinSideBeforeDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server) {
    }

    public void applyOnCorrectCoinSideAfterDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server) {
    }

    protected boolean isCorrectCoinSide(GameServerState server) {
        return this.needCoinSide == null || server.getCoinFlip() != null && this.needCoinSide == server.getCoinFlip().getResults().get(0);
    }

    @Override
    public BaseAttackEffect setRequiredCoinSide(CoinSide coinSide) {
        this.needCoinSide = coinSide;
        return super.setRequiredCoinSide(coinSide);
    }
}

