/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.attack.effects;

import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffectWithOptionalFlip;
import com.pixelmonmod.tcg.duel.attack.enums.CoinSide;
import com.pixelmonmod.tcg.duel.state.DelayEffect;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.List;

public class AcidEffect
extends BaseAttackEffectWithOptionalFlip {
    private static final String CODE = "ACID";

    public AcidEffect() {
        super(CODE);
    }

    @Override
    public void applyOnCorrectCoinSideBeforeDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server) {
        server.addDelayEffect(new DelayEffect(this, attack, card, server.getTurnCount() + 1));
    }

    @Override
    public void modifyTurn(PokemonCardState pokemon, GameServerState server) {
        PlayerServerState player = server.getPlayer(server.getCurrentTurn());
        player.getAvailableActions().setCanRetreatActive(false);
    }

    @Override
    public BaseAttackEffect parse(String ... args) {
        this.setRequiredCoinSide(CoinSide.Head);
        return super.parse(args);
    }
}

