/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelData;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.PixelmonRenderer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.tcg.api.card.CardCondition;
import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.client.gui.duel.TCGScreen;
import com.pixelmonmod.tcg.duel.RenderCard;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GamePhase;
import com.pixelmonmod.tcg.duel.state.PlayerClientOpponentState;
import com.pixelmonmod.tcg.duel.state.PlayerCommonState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.RenderState;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;

public class RenderDuel {
    private static final int DEFAULT_LINE_WIDTH = 2;
    private static final PixelmonEntity[] activePokemons = new PixelmonEntity[2];
    private static float prevPartialTicks = 1.0f;
    private static float partialTicksCompare = 1.0f;
    private static boolean newTick = false;

    @OnlyIn(value=Dist.CLIENT)
    public static void drawStraightLine(GuiGraphics graphics, Direction direction, float fromX, float fromY, float fromZ, float toX, float toY, float toZ, int r, int g, int b, float w) {
        PoseStack matrix = graphics.m_280168_();
        MultiBufferSource.BufferSource buffer = graphics.m_280091_();
        graphics.m_280168_().m_85836_();
        Matrix4f mat = matrix.m_85850_().m_252922_();
        VertexConsumer buffer1 = buffer.m_6299_(RenderType.m_110504_());
        buffer1.m_252986_(mat, fromX, fromY, fromZ).m_6122_(r, g, b, 255).m_5601_((float)direction.m_122429_(), (float)direction.m_122430_(), (float)direction.m_122431_()).m_5752_();
        buffer1.m_252986_(mat, toX, toY, toZ).m_6122_(r, g, b, 255).m_5601_((float)direction.m_122429_(), (float)direction.m_122430_(), (float)direction.m_122431_()).m_5752_();
        matrix.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void draw2DLine(GuiGraphics matrix, double fromX, double fromY, double toX, double toY, float r, float g, float b, float w) {
        RenderDuel.draw2DLine(matrix, fromX, fromY, toX, toY, r, g, b, 1.0f, w);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void draw2DLine(GuiGraphics graphics, double fromX, double fromY, double toX, double toY, float r, float g, float b, float a, float w) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        matrix.m_85837_(-view.f_82479_, -view.f_82480_, -view.f_82481_);
        Matrix4f mat = matrix.m_85850_().m_252922_();
        VertexConsumer builder = graphics.m_280091_().m_6299_(RenderType.m_110504_());
        builder.m_252986_(mat, (float)fromX, (float)fromY, 0.0f).m_85950_(r, g, b, a).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(mat, (float)toX, (float)toY, 0.0f).m_85950_(r, g, b, a).m_85969_(0xF000F0).m_5752_();
        graphics.m_280091_().m_109911_();
        GL11.glDisable((int)2848);
        RenderSystem.lineWidth((float)2.0f);
        matrix.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void draw2DRectangle(GuiGraphics matrix, double x1, double x2, double y1, double y2, float r, float g, float b, float a) {
        matrix.m_280168_().m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.depthMask((boolean)false);
        Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        matrix.m_280168_().m_85837_(-view.f_82479_, -view.f_82480_, -view.f_82481_);
        Matrix4f mat = matrix.m_280168_().m_85850_().m_252922_();
        VertexConsumer builder = matrix.m_280091_().m_6299_(RenderType.m_110504_());
        builder.m_252986_(mat, (float)x1, (float)y1, 0.0f).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(mat, (float)x1, (float)y2, 0.0f).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(mat, (float)x2, (float)y2, 0.0f).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(mat, (float)x2, (float)y1, 0.0f).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        matrix.m_280091_().m_109911_();
        GL11.glDisable((int)2848);
        RenderSystem.lineWidth((float)2.0f);
        matrix.m_280168_().m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawCardOutline(GuiGraphics graphics, Direction direction, float x, float y, float z, boolean isHorizontal, int r, int g, int b) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        y += 0.01f;
        if (isHorizontal) {
            RenderDuel.drawStraightLine(graphics, direction, x, y, z, x, y, z - 2.0f, r, g, b, 2.0f);
            RenderDuel.drawStraightLine(graphics, direction, x, y, z, x + 1.5f, y, z, r, g, b, 2.0f);
            RenderDuel.drawStraightLine(graphics, direction, x + 1.5f, y, z, x + 1.5f, y, z - 2.0f, r, g, b, 2.0f);
            RenderDuel.drawStraightLine(graphics, direction, x, y, z - 2.0f, x + 1.5f, y, z - 2.0f, r, g, b, 2.0f);
        } else {
            RenderDuel.drawStraightLine(graphics, direction, x, y, z, x, y, z - 1.5f, r, g, b, 2.0f);
            RenderDuel.drawStraightLine(graphics, direction, x, y, z, x + 2.0f, y, z, r, g, b, 2.0f);
            RenderDuel.drawStraightLine(graphics, direction, x + 2.0f, y, z, x + 2.0f, y, z - 1.5f, r, g, b, 2.0f);
            RenderDuel.drawStraightLine(graphics, direction, x, y, z - 1.5f, x + 2.0f, y, z - 1.5f, r, g, b, 2.0f);
        }
        matrix.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawPrizeOutline(GuiGraphics graphics, Direction direction, float x, float y, float z, int r, int g, int b) {
        RenderDuel.drawStraightLine(graphics, direction, x, y += 0.01f, z, x, y, z - 1.5f, r, g, b, 2.0f);
        RenderDuel.drawStraightLine(graphics, direction, x, y, z, x + 1.125f, y, z, r, g, b, 2.0f);
        RenderDuel.drawStraightLine(graphics, direction, x + 1.125f, y, z, x + 1.125f, y, z - 1.5f, r, g, b, 2.0f);
        RenderDuel.drawStraightLine(graphics, direction, x, y, z - 1.5f, x + 1.125f, y, z - 1.5f, r, g, b, 2.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawBoardOutline(GuiGraphics graphics, BattleOwnedTileEntityController controller, float x, float y, float z, float partialTicks) {
        int i;
        if (controller.getRender() == null) {
            return;
        }
        Direction direction = controller.getDirection();
        PoseStack matrix = graphics.m_280168_();
        if (partialTicks < prevPartialTicks) {
            partialTicksCompare = partialTicks;
            newTick = true;
        }
        if (partialTicksCompare != partialTicks) {
            newTick = false;
        }
        prevPartialTicks = partialTicks;
        Font f = Minecraft.m_91087_().f_91062_;
        matrix.m_85836_();
        RenderState render = controller.getRender();
        y += 0.01f;
        int r = 255;
        int g = 255;
        int b = 255;
        if (controller.isShadowGame()) {
            r = 103;
            g = 0;
            b = 168;
        }
        RenderDuel.drawStraightLine(graphics, direction, -7.0f, 0.0f, 0.0f, 8.0f, 0.0f, 0.0f, r, g, b, 2.0f);
        RenderDuel.drawStraightLine(graphics, direction, -7.0f, 0.0f, 0.0f, -7.0f, 0.0f, -10.5f, r, g, b, 2.0f);
        RenderDuel.drawStraightLine(graphics, direction, -7.0f, 0.0f, -10.5f, 8.0f, 0.0f, -10.5f, r, g, b, 2.0f);
        RenderDuel.drawStraightLine(graphics, direction, 8.0f, 0.0f, -10.5f, 8.0f, 0.0f, 0.0f, r, g, b, 2.0f);
        RenderDuel.drawStraightLine(graphics, direction, 0.5f, 0.0f, -10.5f, 0.5f, 0.0f, -9.5f, r, g, b, 2.0f);
        RenderDuel.drawStraightLine(graphics, direction, 0.5f, 0.0f, 0.0f, 0.5f, 0.0f, -7.5f, r, g, b, 2.0f);
        y -= 0.01f;
        for (i = 0; i < 5; ++i) {
            RenderDuel.drawCardOutline(graphics, direction, -6.5f, 0.0f, -0.5f - (float)(i * 2), false, r, g, b);
            RenderDuel.drawCardOutline(graphics, direction, 5.5f, 0.0f, -0.5f - (float)(i * 2), false, r, g, b);
        }
        RenderDuel.drawCardOutline(graphics, direction, -2.5f, 0.0f, -4.5f, false, r, g, b);
        RenderDuel.drawCardOutline(graphics, direction, -6.5f, 0.0f, 2.5f, true, r, g, b);
        RenderDuel.drawCardOutline(graphics, direction, 1.5f, 0.0f, -4.5f, false, r, g, b);
        RenderDuel.drawCardOutline(graphics, direction, 4.0f, 0.0f, 2.5f, true, r, g, b);
        if (render.getPlayers() != null) {
            GameClientState client = controller.getClient();
            for (int playerIndex = 0; playerIndex < 2; ++playerIndex) {
                int i2;
                float xOffset;
                PlayerClientOpponentState player = render.getPlayers()[playerIndex];
                PlayerClientOpponentState opp = render.getPlayers()[(playerIndex + 1) % 2];
                if (player == null) continue;
                int rotation = playerIndex * 180;
                float f2 = xOffset = playerIndex == 0 ? 1.5f : -2.5f;
                if (player.getPlayerName() != null) {
                    float x0 = xOffset;
                    float y0 = -1.65f;
                    float z0 = 6.0f;
                    matrix.m_85836_();
                    RenderCard.handleRotation(graphics, x0, y0, z0, rotation, 1.0f);
                    boolean force = Minecraft.m_91087_().m_91390_();
                    Minecraft.m_91087_().m_91336_(false);
                    RenderCard.drawUnlocalizedString(graphics, (double)(x0 - 5.0f), (double)y0, (double)z0 - 5.5, player.getPlayerName(), render.getGamePhase().after(GamePhase.PreMatch) && render.getCurrentTurn() == playerIndex ? 56797 : 0xFFFFFF, false, 90, 4.0f, "");
                    Minecraft.m_91087_().m_91336_(force);
                    matrix.m_85849_();
                }
                matrix.m_85836_();
                float x1 = playerIndex == 0 ? 2.825f : -3.825f;
                float z1 = playerIndex == 0 ? 2.375f : 0.875f;
                matrix.m_85837_(0.0, 0.0, rotation > 0 ? -0.75 : 0.0);
                RenderCard.handleRotation(graphics, x1, 0.0f, z1, rotation, 1.0f);
                VertexConsumer buffer = graphics.m_280091_().m_6299_(PixelmonRendering.outline(player.getCoin().getHeads()));
                Matrix4f pose = matrix.m_85850_().m_252922_();
                buffer.m_252986_(pose, x1, 0.05f, z1).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_5752_();
                buffer.m_252986_(pose, x1 + 0.75f, 0.05f, z1).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_5752_();
                buffer.m_252986_(pose, x1 + 0.75f, 0.05f, z1 - 0.75f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
                buffer.m_252986_(pose, x1, 0.05f, z1 - 0.75f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_5752_();
                matrix.m_85849_();
                PokemonCardState activeCard = player.getActiveCard();
                if (activeCard != null) {
                    float x0 = xOffset;
                    float y0 = 0.1f;
                    float z0 = 6.0f;
                    matrix.m_85836_();
                    if (activeCard.getStatus().getConditions().stream().anyMatch(c -> c.getLeft() == CardCondition.ASLEEP)) {
                        matrix.m_85837_((double)x0 + 12.25, (double)y0, (double)z0 - 10.25);
                        matrix.m_252781_(QuaternionHelper.fromEuler(90.0f, 0.0f, 1.0f, 0.0f));
                        matrix.m_252880_(-x0, -y0, -z0);
                    } else if (activeCard.getStatus().getConditions().stream().anyMatch(c -> c.getLeft() == CardCondition.PARALYZED)) {
                        matrix.m_85837_((double)x0 - 10.25, (double)y0, (double)z0 - 12.25);
                        matrix.m_252781_(QuaternionHelper.fromEuler(-90.0f, 0.0f, 1.0f, 0.0f));
                        matrix.m_252880_(-x0, -y0, -z0);
                    } else if (activeCard.getStatus().getConditions().stream().anyMatch(c -> c.getLeft() == CardCondition.CONFUSED)) {
                        matrix.m_85837_((double)(x0 + 2.0f), (double)y0, (double)z0 - 22.5);
                        matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 1.0f, 0.0f));
                        matrix.m_252880_(-x0, -y0, -z0);
                    }
                    Minecraft mc = Minecraft.m_91087_();
                    if (client != null && client.getMe() != null && client.getMe().getPlayerName().equals(player.getPlayerName()) && client.getMe().getAvailableActions().isCanAttack() && client.isMyTurn()) {
                        RenderDuel.drawCardOutline(graphics, direction, x0, y0 - 0.3f, z0 - 10.5f, false, 0, 255, 0);
                    }
                    RenderCard.drawCardOrBase(graphics, x0, y0, z0, activeCard, rotation, f, partialTicks, player, opp);
                    RenderDuel.drawDamageCounter(graphics, activeCard.getStatus().getDamage(), x0, y0, z0, rotation, f);
                    RenderDuel.drawAttachments(graphics, playerIndex, activeCard, x0, y0, z0, rotation, partialTicks, f, player, opp);
                    if (!activeCard.getData().isFaceDown() && !(mc.f_91080_ instanceof TCGScreen)) {
                        matrix.m_85836_();
                        RenderDuel.drawPokemonModelOnBoard(graphics, x0, y0, z0, mc, partialTicks, activeCard, BoardLocation.Active, 0, playerIndex, controller.getScale());
                        matrix.m_85849_();
                    }
                    if (activeCard.getStatus().getConditions().stream().anyMatch(c -> c.getLeft() == CardCondition.BURNT)) {
                        RenderDuel.drawStatusCounter(graphics, CardCondition.BURNT, x0, y0, z0, rotation);
                    }
                    if (activeCard.getStatus().getConditions().stream().anyMatch(c -> c.getLeft() == CardCondition.POISONED)) {
                        RenderDuel.drawStatusCounter(graphics, CardCondition.POISONED, x0, y0, z0, rotation);
                    }
                    if (activeCard.getStatus().getConditions().stream().anyMatch(c -> c.getLeft() == CardCondition.ASLEEP)) {
                        matrix.m_252781_(QuaternionHelper.fromEuler(90.0f, 0.0f, 0.0f, 1.0f));
                    } else if (activeCard.getStatus().getConditions().stream().anyMatch(c -> c.getLeft() == CardCondition.PARALYZED)) {
                        matrix.m_252781_(QuaternionHelper.fromEuler(-90.0f, 0.0f, 0.0f, 1.0f));
                    } else if (activeCard.getStatus().getConditions().stream().anyMatch(c -> c.getLeft() == CardCondition.CONFUSED)) {
                        matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
                    }
                    matrix.m_85849_();
                }
                for (i2 = 0; i2 < 5; ++i2) {
                    int benchIndex = playerIndex == 1 ? 4 - i2 : i2;
                    PokemonCardState benchCard = player.getBenchCards()[benchIndex];
                    if (benchCard == null) continue;
                    float x0 = playerIndex == 0 ? 5.5f : -6.5f;
                    float y0 = 0.1f;
                    float z0 = 10.0f - (float)i2 * 2.0f;
                    RenderCard.drawCardOrBase(graphics, x0, y0, z0, benchCard, rotation, f, partialTicks, player, opp);
                    RenderDuel.drawDamageCounter(graphics, benchCard.getStatus().getDamage(), x0, y0, z0, rotation, f);
                    RenderDuel.drawAttachments(graphics, playerIndex, benchCard, x0, y0, z0, rotation, partialTicks, f, player, opp);
                }
                if (player.getTrainerCard() != null) {
                    RenderCard.drawCard(graphics, xOffset, 0.1f, 3.0f, player.getTrainerCard(), rotation, f, partialTicks, player, opp);
                }
                matrix.m_85836_();
                if (player.getPrizeCards() != null) {
                    for (i2 = 0; i2 < player.getPrizeCards().length; ++i2) {
                        float xPrizeOffset = (playerIndex == 0 ? 6.5f : 0.75f) + 0.45f - (float)(i2 % 3 + 3) * 1.125f;
                        float zPrizeOffset = 8.5f + (float)(i2 / 3) * 1.5f;
                        if (player.getPrizeCards()[i2] == null) continue;
                        matrix.m_85836_();
                        RenderCard.handleRotation(graphics, xPrizeOffset, 0.1f, zPrizeOffset, 90, 0.75f);
                        RenderCard.drawCardBase(graphics, xPrizeOffset, 0.1f, zPrizeOffset, null, false, (PlayerCommonState)player, (PlayerCommonState)opp);
                        matrix.m_85849_();
                    }
                }
                matrix.m_85849_();
                matrix.m_85836_();
                double x0 = 0.0;
                double y0 = 0.1;
                double z0 = -0.5;
                for (int i3 = 0; i3 < player.getDeckSize(); ++i3) {
                    x0 = playerIndex == 0 ? 4.0 : -4.5;
                    y0 = 0.02 * (double)i3 + 0.1;
                    RenderCard.drawCardBase(graphics, x0, y0, z0, null, true, (PlayerCommonState)player, (PlayerCommonState)opp);
                }
                RenderCard.handleRotation(graphics, (float)x0, (float)y0, (float)z0, 270, 2.7f);
                String s = Integer.toString(player.getDeckSize());
                RenderCard.drawUnlocalizedString(graphics, x0 - 0.253, y0 - 1.65, z0 + 0.075, s, 0, false, 90, 3.0f, "");
                RenderCard.drawUnlocalizedString(graphics, x0 - 0.243, y0 - 1.64, z0 + 0.065, s, 0xEEEEEE, false, 90, 3.0f, "");
                RenderCard.drawUnlocalizedString(graphics, x0 - 0.785, (double)-1.65f, z0 + 0.13, "Deck", 0xFFFFFF, false, 90, 1.0f, "");
                matrix.m_85849_();
                matrix.m_85836_();
                x0 = 0.0;
                y0 = 0.1;
                z0 = -0.5;
                for (int i4 = 0; i4 < player.getDiscardPile().size(); ++i4) {
                    x0 = playerIndex == 0 ? 6.0 : -6.5;
                    y0 = 0.02 * (double)i4 + 0.1;
                    RenderCard.drawCardBase(graphics, x0, y0, z0, null, true, (PlayerCommonState)player, (PlayerCommonState)opp);
                }
                if (player.getDiscardPile().size() == 0) {
                    x0 = playerIndex == 0 ? 6.0 : -6.5;
                    y0 = 0.1;
                }
                RenderCard.handleRotation(graphics, x0, y0, z0, 270, 2.7f);
                s = Integer.toString(player.getDiscardPile().size());
                RenderCard.drawUnlocalizedString(graphics, x0 - 0.253, y0 - 1.65, z0 + 0.075, s, 0, false, 90, 3.0f, "");
                RenderCard.drawUnlocalizedString(graphics, x0 - 0.243, y0 - 1.64, z0 + 0.065, s, 0xEEEEEE, false, 90, 3.0f, "");
                RenderCard.drawUnlocalizedString(graphics, x0 - 0.785, (double)-1.65f, z0, "Discards", 0xFFFFFF, false, 90, 1.0f, "");
                matrix.m_85849_();
            }
        }
        RenderDuel.drawCardOutline(graphics, direction, -2.5f, 0.0f, -1.5f, false, r, g, b);
        RenderDuel.drawCardOutline(graphics, direction, -4.5f, 0.0f, 2.5f, true, r, g, b);
        RenderDuel.drawCardOutline(graphics, direction, 1.5f, 0.0f, -1.5f, false, r, g, b);
        RenderDuel.drawCardOutline(graphics, direction, 6.0f, 0.0f, 2.5f, true, r, g, b);
        matrix.m_85836_();
        for (i = 0; i < 6; ++i) {
            float zOffset = 7.0f + (float)(i / 3) * 1.5f;
            float xOffset = 1.6875f - (float)(i % 3 + 3) * 1.125f;
            RenderDuel.drawPrizeOutline(graphics, direction, -xOffset, 0.0f, -zOffset, r, g, b);
            xOffset = 7.4375f - (float)(i % 3 + 3) * 1.125f;
            RenderDuel.drawPrizeOutline(graphics, direction, -xOffset, 0.0f, -zOffset, r, g, b);
        }
        matrix.m_85849_();
        RenderDuel.drawCardOutline(graphics, direction, -0.25f, 0.0f, -7.5f, true, r, g, b);
        matrix.m_85849_();
    }

    private static void drawDamageCounter(GuiGraphics graphics, int damage, double x0, double y0, double z0, int rotation, Font f) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        if (damage > 0) {
            String str = Integer.toString(damage);
            RenderCard.handleRotation(graphics, x0, y0, z0, rotation, 1.0f);
            RenderCard.drawSprite(graphics, (float)(x0 + (double)0.55f), (float)(y0 + (double)0.01f), (float)(z0 + 1.0), 3.0, 0, new ResourceLocation("tcg:gui/cards/damage.png"));
            RenderCard.drawUnlocalizedString(graphics, x0 + 2.2, y0 - (double)1.68f, z0 + 0.17 - 0.125 * (double)str.toCharArray().length, str, 0xFFFFFF, false, 90, 3.5f, "");
        }
        matrix.m_85849_();
    }

    private static void drawStatusCounter(GuiGraphics graphics, CardCondition cardCondition, float x0, float y0, float z0, int rotation) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        double offset = 0.0;
        if (cardCondition == CardCondition.BURNT) {
            offset = 0.8;
        }
        RenderCard.handleRotation(graphics, x0, y0, z0, rotation, 1.0f);
        RenderCard.drawSprite(graphics, (double)x0 - offset, (double)y0 + 0.005, (double)(z0 + 1.0f), 3.0, 0, new ResourceLocation("tcg:gui/cards/" + cardCondition.getName().toLowerCase() + ".png"));
        matrix.m_85849_();
    }

    private static void drawAttachments(GuiGraphics graphics, int playerIndex, PokemonCardState activeCard, float x0, float y0, float z0, int rotation, float t, Font f, PlayerClientOpponentState player, PlayerClientOpponentState opp) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        float attachmentOffsetX = 0.03f;
        float attachmentOffsetY = 0.026f;
        float attachmentOffsetZ = 0.03f;
        int sign = playerIndex == 0 ? 1 : -1;
        int energyCount = 0;
        for (int attachmentIndex = 0; attachmentIndex < activeCard.getAttachments().size(); ++attachmentIndex) {
            List<CommonCardState> energies;
            CommonCardState attachment = activeCard.getAttachments().get(attachmentIndex);
            RenderCard.drawCardOrBase(graphics, x0 + (float)sign * attachmentOffsetX * (float)(attachmentIndex + 1), y0 - attachmentOffsetY * (float)(attachmentIndex + 1), z0 - (float)sign * attachmentOffsetZ * (float)(attachmentIndex + 1), attachment, 180, f, t, player, opp);
            if (attachment.getCardType() == CardType.ENERGY) {
                RenderDuel.drawEnergySprite(graphics, playerIndex, x0, y0, z0, rotation, energyCount++, attachment.getMainEnergy());
                if (attachment.getSecondaryEnergy() == null) continue;
                RenderDuel.drawEnergySprite(graphics, playerIndex, x0, y0, z0, rotation, energyCount++, attachment.getSecondaryEnergy());
                continue;
            }
            if (attachment.getAbility() == null || attachment.getAbility().getEffect() == null || (energies = attachment.getAbility().getEffect().getEnergyEquivalence(attachment)) == null) continue;
            for (CommonCardState energy : energies) {
                RenderDuel.drawEnergySprite(graphics, playerIndex, x0, y0, z0, rotation, energyCount++, energy.getMainEnergy());
            }
        }
        matrix.m_85849_();
    }

    private static void drawEnergySprite(GuiGraphics graphics, int playerIndex, double x0, double y0, double z0, int rotation, int energyCount, Energy energy) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        int sign = playerIndex == 0 ? 1 : -1;
        double energySize = 0.25;
        double xEnergyOffset = -1.3;
        double zEnergyOffset = -0.7 + (double)energyCount * (energySize + 0.02);
        RenderCard.handleRotation(graphics, x0, y0, z0, rotation, 1.0f);
        RenderCard.drawEnergySprite(graphics, x0 + xEnergyOffset, y0 + 0.01, z0 + zEnergyOffset, rotation, energy);
        matrix.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawPokemonModelOnBoard(GuiGraphics graphics, double x, double y, double z, Minecraft mc, float partialTicks, CommonCardState c, BoardLocation location, int sublocation, int playerIndex, float scale) {
        PoseStack matrix = graphics.m_280168_();
        PixelmonEntity pixelmon = activePokemons[playerIndex];
        int rotation = playerIndex == 0 ? 270 : 90;
        matrix.m_85837_(-x, -y, -z);
        matrix.m_252781_(QuaternionHelper.fromOld(0.0f, rotation, 180.0f, true));
        matrix.m_85837_(x += playerIndex == 0 ? -2.25 : 3.25, y, z -= 9.5);
        if (pixelmon == null || pixelmon.getSpecies().getDex() != c.getPokemonID()) {
            pixelmon = PokemonFactory.create(PixelmonSpecies.fromDex(c.getPokemonID()).get()).getOrCreatePixelmon((Level)mc.f_91073_, x, y, z);
            pixelmon.getLvl().setLevel(1);
            pixelmon.getPokemon().setGrowth(EnumGrowth.Ginormous);
            pixelmon.canMove = true;
            pixelmon.m_6593_((Component)Component.m_237119_());
            RenderDuel.activePokemons[playerIndex] = pixelmon;
            pixelmon.setAnimation(AnimationType.IDLE);
        }
        if (pixelmon.isSpriteModel() || PixelmonConfigProxy.getGraphics().isGlobalSpriteToggle()) {
            return;
        }
        pixelmon.m_20260_(true);
        pixelmon.setPixelmonScale((float)((double)scale * (pixelmon.getForm().getDimensions().getHeight() / 3.0 / pixelmon.getForm().getDimensions().getHeight())));
        if (newTick) {
            for (ModelData modelData : pixelmon.getModel()) {
                pixelmon.getAnimationVariables(modelData).tick();
            }
        }
        matrix.m_85836_();
        Vector3f color = c.getOverrideModelColor() != null ? c.getOverrideModelColor() : new Vector3f(1.0f, 1.0f, 1.0f);
        try {
            EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
            pixelmon.setRenderColor(color.x(), color.y(), color.z(), 1.0f);
            EntityRenderer entityClassRenderObject = renderManager.m_114382_((Entity)pixelmon);
            PixelmonRenderer rp = (PixelmonRenderer)entityClassRenderObject;
            rp.render(pixelmon, 0.0f, partialTicks, matrix, (MultiBufferSource)graphics.m_280091_(), 0xF000F0);
            graphics.m_280091_().m_109911_();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        matrix.m_85849_();
    }
}

