/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.tcg.api.accessors.CardBacks;
import com.pixelmonmod.tcg.api.card.CardRarity;
import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.api.card.ability.CardPower;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.api.card.personalization.CardBack;
import com.pixelmonmod.tcg.api.util.helper.LogicHelper;
import com.pixelmonmod.tcg.client.gui.TCGResources;
import com.pixelmonmod.tcg.client.helper.CardRenderingHelper;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.PlayerClientOpponentState;
import com.pixelmonmod.tcg.duel.state.PlayerCommonState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix4f;

public class RenderCard {
    public static Minecraft mc = Minecraft.m_91087_();

    @OnlyIn(value=Dist.CLIENT)
    public static void drawCardBase(GuiGraphics matrix, double x, double y, double z, CommonCardState c, boolean isRotated, PlayerCommonState me, PlayerCommonState opp) {
        RenderCard.drawCardBase(matrix, (float)x, (float)y, (float)z, c, isRotated, me, opp);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawCardBase(GuiGraphics graphics, float x, float y, float z, CommonCardState c, boolean isRotated, PlayerCommonState me, PlayerCommonState opp) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        ResourceLocation texture = CardBacks.STANDARD.getValueUnsafe().getFile();
        if (c != null) {
            texture = c.getCardType().isCosmetic() ? CardRenderingHelper.getCosmeticBackgroundTexture(c) : (c.hasTransformation() ? CardRenderingHelper.getBackgroundTexture(c.getTransformation().getCardType(), c.getTransformation().getMainEnergy(), c.getTransformation().isSpecial()) : CardRenderingHelper.getBackgroundTexture(c.getData().getCardType(), c.getMainEnergy(), c.getData().isSpecial()));
        } else if (me != null) {
            CardBack cardBack = CardBacks.get(me.getCardBackID());
            if (cardBack == null) {
                cardBack = CardBacks.STANDARD.getValueUnsafe();
            }
            texture = cardBack.getFile();
        }
        if (isRotated) {
            RenderCard.handleRotation(graphics, x, y, z, 90, 1.0f);
        }
        VertexConsumer buffer = graphics.m_280091_().m_6299_(PixelmonRendering.outline(texture));
        Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
        buffer.m_252986_(pose, x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(pose, x + 2.0f, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_252986_(pose, x + 2.0f, y, z - 1.5f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_252986_(pose, x, y, z - 1.5f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_5752_();
        matrix.m_85849_();
    }

    public static void handleRotation(GuiGraphics matrix, double x, double y, double z, int rotation, float scale) {
        RenderCard.handleRotation(matrix, (float)x, (float)y, (float)z, rotation, scale);
    }

    public static void handleRotation(GuiGraphics graphics, float x, float y, float z, int rotation, float scale) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 1.0f, 0.0f, 0.0f));
        if (rotation == 90) {
            matrix.m_85837_((double)x + 1.5, (double)y, (double)z);
            matrix.m_252781_(QuaternionHelper.fromEuler(90.0f, 0.0f, 1.0f, 0.0f));
            matrix.m_85841_(scale, 1.0f, scale);
            matrix.m_252880_(-x, -y, -z);
        } else if (rotation == 270) {
            matrix.m_85837_((double)x + 1.5, (double)y, (double)z);
            matrix.m_252781_(QuaternionHelper.fromEuler(270.0f, 0.0f, 1.0f, 0.0f));
            matrix.m_85841_(scale, 1.0f, scale);
            matrix.m_252880_(-x, -y, -z);
        } else if (rotation != 180) {
            matrix.m_85837_((double)(x + 1.0f), (double)y, (double)z - 0.75);
            matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 1.0f, 0.0f));
            matrix.m_85837_((double)(-x - 1.0f), (double)(-y), (double)(-z) + 0.75);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawCard(GuiGraphics graphics, float x, float y, float z, CommonCardState card, int rotation, Font f, float t, PlayerCommonState me, PlayerCommonState opp) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        if (card != null) {
            RenderCard.handleRotation(graphics, x, y, z, rotation, 1.0f);
            RenderCard.drawCardBase(graphics, x, y, z, card, false, me, opp);
            RenderCard.drawName(graphics, x, y, z, card);
            RenderCard.drawStage(graphics, x, y, z, card);
            RenderCard.drawType(graphics, x, y, z, card);
            if (card instanceof PokemonCardState) {
                RenderCard.drawEffects(graphics, x, y, z, (PokemonCardState)card);
            } else if (StringUtils.isNotBlank((CharSequence)card.getDescription())) {
                String cardText = card.getDescription();
                double dx = 1.02;
                double dz = -1.39;
                RenderCard.drawUnlocalizedString(graphics, (double)x + dx, (double)(y - 2.0f) + 1.0E-4, (double)z + dz, cardText, 0x202020, true, 90, 1.0f, true, 0, "");
            }
            RenderCard.drawHP(graphics, x, y, z, card);
            RenderCard.drawSprite(graphics, x, y, z, card);
            if (card instanceof PokemonCardState) {
                PokemonCardState pokemon = (PokemonCardState)card;
                RenderCard.drawWeakness(graphics, x, y, z, pokemon, f);
                RenderCard.drawResistance(graphics, x, y, z, pokemon, f);
            }
            RenderCard.drawSet(graphics, x, y, z, 0.5f, card);
            RenderCard.drawRarity(graphics, x, y, z, card);
            if (card instanceof PokemonCardState) {
                RenderCard.drawPrevEvolution(graphics, x, y, z, (PokemonCardState)card, f);
                RenderCard.drawRetreat(graphics, x, y, z, (PokemonCardState)card, me, opp);
            }
        }
        matrix.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawSet(GuiGraphics matrix, float x, float y, float z, float alpha, CommonCardState card) {
        float ya = y + 0.001f;
        if (card.getCardType() != CardType.ENERGY) {
            ResourceLocation texture = new ResourceLocation("tcg:gui/cards/icons/sets/" + card.getTransformation().getSetID() + ".png");
            if (card.hasTransformation()) {
                if (card.getTransformation().getSetID() == 1) {
                    return;
                }
                texture = new ResourceLocation("tcg:gui/cards/icons/sets/" + card.getTransformation().getSetID() + ".png");
            } else {
                if (card.getSetID() == 1) {
                    return;
                }
                texture = new ResourceLocation("tcg:gui/cards/icons/sets/" + card.getSetID() + ".png");
            }
            float size = 0.25f;
            float xa = x + 1.055f;
            float za = z - 1.125f;
            VertexConsumer buffer = matrix.m_280091_().m_6299_(PixelmonRendering.outline(texture));
            Matrix4f pose = matrix.m_280168_().m_85850_().m_252922_();
            buffer.m_252986_(pose, xa, ya, za).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_252986_(pose, xa + size, ya, za).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, xa + size, ya, za - size).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, xa, ya, za - size).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 1.0f).m_5752_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawCardOrBase(GuiGraphics graphics, float x, float y, float z, CommonCardState card, int rotation, Font f, float t, PlayerClientOpponentState me, PlayerClientOpponentState opp) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        if (!card.getData().isFaceDown()) {
            RenderCard.drawCard(graphics, x, y, z, card, rotation, f, t, me, opp);
        } else {
            RenderCard.drawCardBase(graphics, x, y, z, null, false, (PlayerCommonState)me, (PlayerCommonState)opp);
        }
        matrix.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawSprite(GuiGraphics matrix, float x, float y, float z, CommonCardState card) {
        float ya = y + 0.001f;
        if (card.getCardType() != CardType.ENERGY || card.getPokemonSprite() == null) {
            if (card.hasTransformation()) {
                if (card.getTransformation().getHasCustomTex()) {
                    x -= 0.055f;
                }
            } else if (card.getData().getHasCustomTex()) {
                x -= 0.055f;
            }
            float size = 0.6f;
            float xa = x + 1.11f;
            float za = z - 0.45f;
            VertexConsumer buffer = matrix.m_280091_().m_6299_(PixelmonRendering.outline(card.getPokemonSprite()));
            Matrix4f pose = matrix.m_280168_().m_85850_().m_252922_();
            buffer.m_252986_(pose, xa, ya, za).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_252986_(pose, xa + size, ya, za).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, xa + size, ya, za - size).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, xa, ya, za - size).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_5752_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static void drawEnergySprite(GuiGraphics matrix, double x, double y, double z, int rotation, Energy energy) {
        RenderCard.drawEnergySprite(matrix, (float)x, (float)y, (float)z, rotation, energy);
    }

    @OnlyIn(value=Dist.CLIENT)
    static void drawEnergySprite(GuiGraphics matrix, float x, float y, float z, int rotation, Energy energy) {
        RenderCard.drawSprite(matrix, x, y, z, 1.0, rotation, energy.getHighResTexture());
    }

    @OnlyIn(value=Dist.CLIENT)
    static void drawSprite(GuiGraphics matrix, double x, double y, double z, double scale, int rotation, ResourceLocation resource) {
        RenderCard.drawSprite(matrix, (float)x, (float)y, (float)z, scale, rotation, resource);
    }

    @OnlyIn(value=Dist.CLIENT)
    static void drawSprite(GuiGraphics graphics, float x, float y, float z, double scale, int rotation, ResourceLocation resource) {
        float size = (float)(0.25 * scale);
        float xa = x + 1.11f;
        float ya = y + 0.001f;
        float za = z - 0.45f;
        VertexConsumer buffer = graphics.m_280091_().m_6299_(PixelmonRendering.outline(resource));
        Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
        buffer.m_252986_(pose, xa, ya, za).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(pose, xa + size, ya, za).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_252986_(pose, xa + size, ya, za - size).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_252986_(pose, xa, ya, za - size).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawPrevEvolution(GuiGraphics graphics, float x, float y, float z, PokemonCardState card, Font f) {
        if (card.getPreviousPokemonID() > 0) {
            ResourceLocation texture = card.bindPreviousPokemonSprite();
            if (card.getPreviousPokemonID() == 10000) {
                texture = TCGResources.FOSSIL;
            }
            float size = 0.25f;
            float xa = x + 1.59f;
            float ya = y + 0.001f;
            float za = z - 0.065f;
            VertexConsumer buffer = graphics.m_280091_().m_6299_(PixelmonRendering.outline(texture));
            Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
            buffer.m_252986_(pose, xa, ya, za).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_252986_(pose, xa + size, ya, za).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, xa + size, ya, za - size).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, xa, ya, za - size).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_5752_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawHP(GuiGraphics graphics, float x, float y, float z, CommonCardState card) {
        CardType ct = card.getCardType();
        if (ct.isPokemon()) {
            int cardHealth = card.getHP();
            double dy = -1.695f;
            double dx = 1.92;
            double dz = -1.42;
            RenderCard.drawUnlocalizedString(graphics, (double)x + dx, (double)y + dy, (double)z + dz, Component.m_237113_((String)(cardHealth + "HP")), 0x202020, false, 90, 1.0f, "");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawName(GuiGraphics graphics, float x, float y, float z, CommonCardState card) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        float dx = 1.7835f;
        float dy = -1.695f;
        float dz = -0.995f;
        float nameSize = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)Component.m_237115_((String)card.getName().toLowerCase()));
        float widthConstant = 98.0f;
        if (card.getCardType() == CardType.STAGE1 || card.getCardType() == CardType.STAGE2 || card.getCardType() == CardType.EX || card.getCardType() == CardType.LVLX || card.getCardType() == CardType.GX) {
            widthConstant -= 25.5f;
        }
        if (nameSize > widthConstant) {
            float scaleFactor = 1.0f - (nameSize - widthConstant) / widthConstant;
            matrix.m_252880_(0.0f, 0.0f, z + dz);
            matrix.m_85841_(1.0f, 1.0f, scaleFactor);
            matrix.m_252880_(0.0f, 0.0f, -(z + dz));
        }
        RenderCard.drawUnlocalizedString(graphics, (double)(x + dx), (double)(y + dy), (double)(z + dz), card.getName(), 0x202020, true, 90, 1.0f, "");
        matrix.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawEffects(GuiGraphics graphics, float x, float y, float z, PokemonCardState card) {
        float ya = y + 0.001f;
        float offset = 0.11f;
        if (card.getCardType() == CardType.STADIUM || card.getCardType() == CardType.TRAINER || card.getDescription() != null && !card.getDescription().isEmpty()) {
            String cardText = card.getDescription();
            double dx = 1.12;
            double dz = -1.39;
            if (card.getCardType() == CardType.ENERGY) {
                RenderCard.drawUnlocalizedString(graphics, (double)x + dx - (double)(1.0f * offset), (double)(y - 2.0f), (double)z + dz, cardText, 0xDDDDDD, true, 90, 1.0f, true, 3, "");
            } else {
                RenderCard.drawUnlocalizedString(graphics, (double)x + dx - (double)(1.0f * offset), (double)(y - 2.0f), (double)z + dz, cardText, 0x202020, true, 90, 1.0f, true, 8, "");
            }
        } else {
            ResourceLocation texture;
            int line = 0;
            float dx = 1.02f;
            float dz = -1.39f;
            float size = 0.08f;
            CardPower cardAbility = card.getAbility();
            if (cardAbility != null && (texture = CardRenderingHelper.getAbilityTexture(cardAbility)) != null) {
                float o = -0.1f;
                VertexConsumer buffer = graphics.m_280091_().m_6299_(PixelmonRendering.outline(texture));
                Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
                buffer.m_252986_(pose, x + dx + o, ya, z + dz + size).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_5752_();
                buffer.m_252986_(pose, x + dx + size + o, ya, z + dz + size).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_5752_();
                buffer.m_252986_(pose, x + dx + size + o, ya, z + dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
                buffer.m_252986_(pose, x + dx + o, ya, z + dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_5752_();
                graphics.m_280168_().m_85836_();
                MutableComponent name = Component.m_237115_((String)cardAbility.getName().toLowerCase()).m_130940_(ChatFormatting.BOLD);
                float nameSize = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)name);
                float widthConstant = 120.0f;
                if (nameSize > widthConstant) {
                    float scaleFactor = 1.0f - (nameSize - widthConstant) / widthConstant;
                    graphics.m_280168_().m_85837_(0.0, 0.0, (double)(z + dz) + ((double)size + 0.01) + 0.01);
                    graphics.m_280168_().m_85841_(1.0f, 1.0f, scaleFactor);
                    graphics.m_280168_().m_85837_(0.0, 0.0, -((double)(z + dz) + ((double)size + 0.01) + 0.01));
                }
                RenderCard.drawUnlocalizedString(graphics, (double)(x + dx - (float)line * offset), (double)(y - 2.0f), (double)(z + dz) + ((double)size + 0.01) + 0.01, cardAbility.getName(), 0x202020, true, 90, 1.0f, "\u00a7l");
                ++line;
                graphics.m_280168_().m_85849_();
                if (cardAbility.getDescription() != null) {
                    int linesForAbility;
                    int n = linesForAbility = card.getAttacksStatus() != null && card.getAttacksStatus().length > 0 ? 2 : 5;
                    if (card.getAttacksStatus().length == 1 && !card.getAttacksStatus()[0].hasDescription()) {
                        linesForAbility = 4;
                    }
                    RenderCard.drawUnlocalizedString(graphics, (double)(x + dx - (float)line * offset), (double)(y - 2.0f), (double)(z + dz), cardAbility.getDescription(), 0x444444, true, 90, 1.0f, true, linesForAbility, "\u00a7o");
                    line += linesForAbility;
                }
            }
            int[] descriptionLines = CardRenderingHelper.calculateAttackDescriptionLines(card.getAttacksStatus(), cardAbility != null, 94);
            for (int attackIndex = 0; attackIndex < card.getAttacksStatus().length; ++attackIndex) {
                PokemonAttackStatus attack = card.getAttacksStatus()[attackIndex];
                CardAttack cardAttackData = attack.getData();
                if (cardAttackData != null) {
                    for (int i = 0; i < cardAttackData.getCosts().size(); ++i) {
                        double moveDist = ((double)size + 0.01) * (double)i;
                        double o = -0.1;
                        int finalLine = line;
                        VertexConsumer buffer = graphics.m_280091_().m_6299_(PixelmonRendering.outline(cardAttackData.getCosts().get(i).getTexture()));
                        Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
                        float x1 = (float)((double)(x + dx - (float)finalLine * offset) + o);
                        float x2 = (float)((double)(x + dx + size - (float)finalLine * offset) + o);
                        buffer.m_252986_(pose, x1, y + 0.001f, (float)((double)(z + dz) + moveDist + (double)size)).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_5752_();
                        buffer.m_252986_(pose, x2, y + 0.001f, (float)((double)(z + dz) + moveDist + (double)size)).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_5752_();
                        buffer.m_252986_(pose, x2, y + 0.001f, (float)((double)(z + dz) + moveDist)).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
                        buffer.m_252986_(pose, x1, y + 0.001f, (float)((double)(z + dz) + moveDist)).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_5752_();
                    }
                    String modifier = cardAttackData.getModifier() == null ? "" : cardAttackData.getModifier().toString();
                    int damage = cardAttackData.getDamage();
                    double rightZ = -0.25;
                    if (damage != 0) {
                        String damageString = damage + modifier;
                        if (attack.getDamageBonus() != 0) {
                            damageString = damageString + " +" + attack.getDamageBonus();
                        }
                        RenderCard.drawUnlocalizedString(graphics, (double)(x + dx - (float)line * offset), (double)(y - 2.0f), (double)z + rightZ, damageString, 0x202020, true, 90, 1.0f, "");
                    }
                    double offsetE = Math.max(((double)size + 0.01) * 3.0, ((double)size + 0.01) * (double)cardAttackData.getCosts().size());
                    graphics.m_280168_().m_85836_();
                    String name = Component.m_237115_((String)cardAttackData.getName().toLowerCase()).getString();
                    float nameSize = RenderCard.mc.f_91062_.m_92895_(name);
                    float widthConstant = 68.0f;
                    float offsetT = Math.max(3, cardAttackData.getCosts().size()) * 6 + 1;
                    nameSize -= offsetT;
                    if (nameSize > widthConstant) {
                        float scaleFactor = 1.0f - (nameSize - widthConstant) / widthConstant;
                        graphics.m_280168_().m_85837_(0.0, 0.0, (double)(z + dz) + 0.01 + offsetE);
                        graphics.m_280168_().m_85841_(1.0f, 1.0f, scaleFactor);
                        graphics.m_280168_().m_85837_(0.0, 0.0, -((double)(z + dz) + 0.01 + offsetE));
                    }
                    RenderCard.drawUnlocalizedString(graphics, (double)(x + dx - (float)line * offset), (double)y - 1.69, (double)(z + dz) + 0.01 + offsetE, cardAttackData.getName(), 0x202020, true, 90, 1.0f, "");
                    graphics.m_280168_().m_85849_();
                    if (cardAttackData.getText() != null) {
                        RenderCard.drawUnlocalizedString(graphics, (double)(x + dx - (float)(line + 1) * offset), (double)y - 1.69, (double)(z + dz), cardAttackData.getText(), 0x444444, true, 90, 1.0f, true, descriptionLines[attackIndex], "\u00a7o");
                    }
                }
                line += descriptionLines[attackIndex] + 1;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawRarity(GuiGraphics graphics, float x, float y, float z, CommonCardState card) {
        CardRarity cardRarity;
        float ya = y + 0.001f;
        if (card.getCardType() != CardType.ENERGY && (cardRarity = card.getRarity()) != null) {
            ResourceLocation texture = new ResourceLocation("tcg:gui/cards/icons/" + cardRarity.getUnlocalizedName() + ".png");
            float hx = 0.1f;
            float wx = 0.1f;
            float xa = x + 1.02f;
            float za = z - 0.05f;
            VertexConsumer buffer = graphics.m_280091_().m_6299_(PixelmonRendering.outline(texture));
            Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
            buffer.m_252986_(pose, xa, ya, za).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_252986_(pose, xa + hx, ya, za).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, xa + hx, ya, za - wx).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, xa, ya, za - wx).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_5752_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawRetreat(GuiGraphics graphics, float x, float y, float z, PokemonCardState card, PlayerCommonState me, PlayerCommonState opp) {
        float ya = y + 0.001f;
        if (card.getCardType().isPokemon() && card.getRetreatCost() > 0) {
            int costModifier = LogicHelper.getCostModifier(me, opp);
            costModifier = Math.max(costModifier, -card.getRetreatCost());
            int renderCost = card.getRetreatCost() + costModifier;
            ResourceLocation texture = TCGResources.ENERGY_COLORLESS;
            float size = 0.08f;
            float dx = 0.11f;
            float dz = -0.24f;
            float modo = size / 2.0f * (float)renderCost;
            for (int i = 0; i < renderCost; ++i) {
                float moveDist = size * (float)i - modo;
                VertexConsumer buffer = graphics.m_280091_().m_6299_(PixelmonRendering.outline(texture));
                Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
                buffer.m_252986_(pose, x + dx, ya, z + dz + moveDist).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_5752_();
                buffer.m_252986_(pose, x + dx + size, ya, z + dz + moveDist).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_5752_();
                buffer.m_252986_(pose, x + dx + size, ya, z + dz + moveDist - size).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
                buffer.m_252986_(pose, x + dx, ya, z + dz + moveDist - size).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_5752_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawWeakness(GuiGraphics graphics, float x, float y, float z, PokemonCardState card, Font f) {
        float ya = y + 0.001f;
        Energy energy = card.getWeakness();
        if (energy != null) {
            float size = 0.08f;
            float dx = 0.11f;
            float dz = -1.24f;
            String modifierString = card.getWeaknessModifier().toString() + card.getWeaknessValue();
            VertexConsumer buffer = graphics.m_280091_().m_6299_(PixelmonRendering.outline(energy.getTexture()));
            Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
            buffer.m_252986_(pose, x + dx, ya, z + dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_252986_(pose, x + dx + size, ya, z + dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, x + dx + size, ya, z + dz - size).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, x + dx, ya, z + dz - size).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_5752_();
            RenderCard.drawUnlocalizedString(graphics, (double)(x + dx) + 0.1, (double)-1.599f, (double)(z + dz) + 0.01, modifierString, 0xDDDDDD, true, 90, 1.0f, "");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawResistance(GuiGraphics graphics, float x, float y, float z, PokemonCardState card, Font f) {
        float ya = y + 0.001f;
        Energy energy = card.getResistance();
        if (energy != null) {
            float size = 0.08f;
            float dx = 0.11f;
            float dz = -0.83f;
            String modifierString = card.getResistanceModifier().toString() + card.getResistanceValue();
            VertexConsumer buffer = graphics.m_280091_().m_6299_(PixelmonRendering.outline(energy.getTexture()));
            Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
            buffer.m_252986_(pose, x + dx, ya, z + dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_252986_(pose, x + dx + size, ya, z + dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, x + dx + size, ya, z + dz - size).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, x + dx, ya, z + dz - size).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_5752_();
            RenderCard.drawUnlocalizedString(graphics, (double)(x + dx) + 0.1, (double)-1.599f, (double)(z + dz) + 0.01, modifierString, 0xDDDDDD, true, 90, 1.0f, "");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawStage(GuiGraphics graphics, float x, float y, float z, CommonCardState card) {
        CardType ct = card.getCardType();
        y += 0.001f;
        if (ct != CardType.ENERGY) {
            float hd = 0.14f;
            float wd = 0.38f;
            float xa = x + 1.66f;
            float za = z - 1.04f;
            float ya = y + 0.001f;
            VertexConsumer buffer = graphics.m_280091_().m_6299_(PixelmonRendering.outline(ct.getIcon()));
            Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
            buffer.m_252986_(pose, xa, ya, za).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_252986_(pose, xa + hd, ya, za).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, xa + hd, ya, za - wd).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, xa, ya, za - wd).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_5752_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawType(GuiGraphics graphics, float x, float y, float z, CommonCardState c) {
        CardType ct = c.getCardType();
        float ya = y + 0.001f;
        if (ct == CardType.ENERGY || ct.isPokemon() && c.getMainEnergy() != null) {
            float size = 0.12f;
            float xa = x + 1.82f;
            float za = z - 0.7f;
            if (c.getSecondaryEnergy() != null) {
                VertexConsumer buffer = graphics.m_280091_().m_6299_(PixelmonRendering.outline(c.getMainEnergy().getTexture()));
                Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
                buffer.m_252986_(pose, xa, ya, za).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_5752_();
                buffer.m_252986_(pose, xa + 0.2f, ya, za).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
                buffer.m_252986_(pose, xa + 0.2f, ya, za - 0.2f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_5752_();
                buffer.m_252986_(pose, xa, ya, za - 0.2f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_5752_();
                buffer = graphics.m_280091_().m_6299_(PixelmonRendering.outline(c.getSecondaryEnergy().getTexture()));
                buffer.m_252986_(pose, xa, ya, za).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_5752_();
                buffer.m_252986_(pose, xa + 0.2f, ya, za).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
                buffer.m_252986_(pose, xa + 0.2f, ya, za - 0.2f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_5752_();
                buffer.m_252986_(pose, xa, ya, za - 0.2f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_5752_();
            } else {
                VertexConsumer buffer = graphics.m_280091_().m_6299_(PixelmonRendering.outline(c.getMainEnergy().getTexture()));
                Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
                buffer.m_252986_(pose, xa, ya, za).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_5752_();
                buffer.m_252986_(pose, xa + size, ya, za).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_5752_();
                buffer.m_252986_(pose, xa + size, ya, za - size).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
                buffer.m_252986_(pose, xa, ya, za - size).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_5752_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static void drawUnlocalizedString(GuiGraphics graphics, double x, double y, double z, String unlocalizedString, int color, boolean isUnicode, int rotation, float scale, String formatting) {
        RenderCard.drawUnlocalizedString(graphics, x, y, z, Component.m_237115_((String)unlocalizedString), color, isUnicode, rotation, scale, false, 0, formatting);
    }

    @OnlyIn(value=Dist.CLIENT)
    static void drawUnlocalizedString(GuiGraphics graphics, double x, double y, double z, MutableComponent unlocalizedString, int color, boolean isUnicode, int rotation, float scale, String formatting) {
        RenderCard.drawUnlocalizedString(graphics, x, y, z, unlocalizedString, color, isUnicode, rotation, scale, false, 0, formatting);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawUnlocalizedString(GuiGraphics graphics, double x, double y, double z, String unlocalizedString, int color, boolean isUnicode, int rotation, float scale, boolean isExtended, int maxLines, String formatting) {
        RenderCard.drawUnlocalizedString(graphics, x, y, z, Component.m_237115_((String)unlocalizedString), color, isUnicode, rotation, scale, isExtended, maxLines, formatting);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawUnlocalizedString(GuiGraphics graphics, double x, double y, double z, MutableComponent unlocalizedString, int color, boolean isUnicode, int rotation, float scale, boolean isExtended, int maxLines, String formatting) {
        PoseStack matrix = graphics.m_280168_();
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        String string = unlocalizedString.getString();
        float var13 = 0.775f;
        float baseScale = 0.016666668f * var13 * scale;
        matrix.m_85836_();
        matrix.m_252880_((float)x + 0.0f, (float)y + 0.7f + 1.0f, (float)z);
        if (rotation == 180) {
            matrix.m_252781_(QuaternionHelper.fromEuler(90.0f, 1.0f, 0.0f, 0.0f));
            matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
            matrix.m_252781_(QuaternionHelper.fromEuler(-90.0f, 0.0f, 0.0f, 1.0f));
        }
        if (rotation == 90) {
            matrix.m_252781_(QuaternionHelper.fromEuler(rotation, 1.0f, 0.0f, 0.0f));
            matrix.m_252781_(QuaternionHelper.fromEuler(-rotation, 0.0f, 0.0f, 1.0f));
        }
        matrix.m_85841_(-baseScale, -baseScale, baseScale);
        boolean force = Minecraft.m_91087_().m_91390_();
        if (isUnicode) {
            Minecraft.m_91087_().m_91336_(true);
        }
        if (isExtended) {
            if (maxLines == 0) {
                fontRenderer.m_271703_(formatting + string, 0.0f, 0.0f, color, false, matrix.m_85850_().m_252922_(), (MultiBufferSource)graphics.m_280091_(), Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
            } else {
                List<String> lines = ScreenHelper.splitString(string, 94);
                int count = Math.min(lines.size(), maxLines);
                for (int i = 0; i < count; ++i) {
                    if (i == maxLines - 1) {
                        String lastLine = lines.get(i);
                        if (fontRenderer.m_92895_(lastLine + "...") > 94 || lines.size() > maxLines) {
                            while (fontRenderer.m_92895_(lastLine + "...") > 94) {
                                lastLine = lastLine.substring(0, lastLine.length() - 1);
                            }
                            if (lastLine.endsWith(",") || lastLine.endsWith(".") || lastLine.endsWith(":")) {
                                lastLine = lastLine.substring(0, lastLine.length() - 1);
                            }
                            lines.set(i, lastLine);
                        }
                    } else {
                        lines.set(i, lines.get(i));
                    }
                    lines.set(i, lines.get(i));
                    fontRenderer.m_271703_(formatting + lines.get(i), 0.0f, (float)(i * 8), color, false, matrix.m_85850_().m_252922_(), (MultiBufferSource)graphics.m_280091_(), Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                }
            }
        } else {
            fontRenderer.m_271703_(formatting + string, 0.0f, 0.0f, color, false, matrix.m_85850_().m_252922_(), (MultiBufferSource)graphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        if (isUnicode) {
            Minecraft.m_91087_().m_91336_(force);
        }
        matrix.m_85849_();
    }
}

