/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.commands;

import com.pixelmonmod.api.helpers.ColorHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NumberHelper;
import com.pixelmonmod.tcg.api.accessors.CardBacks;
import com.pixelmonmod.tcg.api.accessors.CardSets;
import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.accessors.Coins;
import com.pixelmonmod.tcg.api.accessors.ThemeDecks;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.ThemeDeck;
import com.pixelmonmod.tcg.api.card.personalization.CardBack;
import com.pixelmonmod.tcg.api.card.personalization.Coin;
import com.pixelmonmod.tcg.api.card.set.CardSet;
import com.pixelmonmod.tcg.block.EssenceJarBlock;
import com.pixelmonmod.tcg.commands.SubcommandBase;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class TCGGiveCommand
extends SubcommandBase {
    public static final HashSet<String> GIVE_COMMANDS = new HashSet<String>(Arrays.asList("card", "deck", "pack", "essence", "cardback", "coin", "jar"));

    @Override
    String getHelp(CommandSourceStack sender) {
        return "/tcg give card <player> <card_id>: give a card to a player\n/tcg give deck <player> <deck_id>: give a deck to a player\n/tcg give pack <player> <set_id>: give a booster pack to a player\n/tcg give cardback <player> <cardback_id>: gives a card back to a player\n/tcg give coin <player> <coin_id>: gives a coin to a player\n/tcg give jar <player> [percent_full] [color] [color_name]";
    }

    @Override
    String getPermissionNode() {
        return "tcg.give";
    }

    @Override
    int getPermissionLevel() {
        return 4;
    }

    @Override
    protected boolean execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException {
        if (args.length > 1) {
            ServerPlayer receiver = null;
            if (GIVE_COMMANDS.contains(args[1])) {
                if (args.length > 2) {
                    receiver = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(args[2]);
                } else {
                    return false;
                }
            }
            if (receiver == null) {
                SubcommandBase.sendMessage(sender, ChatFormatting.RED, "Cannot find player " + args[2]);
                return true;
            }
            if (args[1].equalsIgnoreCase("jar")) {
                Color color = new Color(DyeColor.BLACK.m_41071_());
                String colorName = DyeColor.BLACK.m_41065_();
                double jarPercentFull = 0.0;
                if (args.length > 3) {
                    jarPercentFull = NumberHelper.parseDouble(args[3]).orElse(0.0);
                    jarPercentFull /= 100.0;
                }
                if (args.length > 4) {
                    color = ColorHelper.getParsedColor(args[4]).orElse(null);
                    if (color == null) {
                        receiver.m_213846_((Component)Component.m_237115_((String)"tcg.essence.color.invalid"));
                        return true;
                    }
                    colorName = ColorHelper.getParsedColorName(args[4]).orElse(Component.m_237115_((String)"tcg.essence.color.unknown").getString());
                }
                if (args.length > 5) {
                    colorName = args[5];
                }
                receiver.m_213846_((Component)Component.m_237110_((String)"tcg.essence.given", (Object[])new Object[]{colorName}));
                receiver.m_36356_(EssenceJarBlock.createJarItem(jarPercentFull, color, colorName));
                return true;
            }
            if (args[1].equalsIgnoreCase("card")) {
                if (args.length > 3) {
                    ImmutableCard card;
                    boolean isHolo = false;
                    if (args.length > 4) {
                        isHolo = args[4].equalsIgnoreCase("H");
                    }
                    if ((card = Cards.fromCode(args[3])) == null) {
                        SubcommandBase.sendMessage(sender, ChatFormatting.RED, "Cannot find card with ID " + args[3]);
                        return true;
                    }
                    if (!receiver.m_36356_(card.getItemStack(1))) {
                        receiver.m_36176_(card.getItemStack(1), true);
                    }
                    receiver.m_213846_((Component)Component.m_237115_((String)card.getName().toLowerCase()).m_130946_(" card is added to your inventory!"));
                    return true;
                }
                return false;
            }
            if (args[1].equalsIgnoreCase("pack")) {
                if (args.length > 3) {
                    CardSet set = CardSets.get(args[3]);
                    if (set == null) {
                        SubcommandBase.sendMessage(sender, ChatFormatting.RED, "Cannot find set with ID " + args[3]);
                        return true;
                    }
                    if (!receiver.m_36356_(set.getItemStack(1))) {
                        receiver.m_36176_(set.getItemStack(1), true);
                    }
                    SubcommandBase.sendMessage(receiver, ChatFormatting.GREEN, "Pack of " + Component.m_237115_((String)set.getUnlocalizedName().toLowerCase()) + " is added to your inventory!");
                    return true;
                }
                return false;
            }
            if (args[1].equalsIgnoreCase("deck")) {
                if (args.length > 3) {
                    ThemeDeck deck = ThemeDecks.get(args[3]);
                    if (deck == null) {
                        SubcommandBase.sendMessage(sender, ChatFormatting.RED, "Cannot find deck with ID " + args[3]);
                        return true;
                    }
                    if (!receiver.m_36356_(deck.getItemStack())) {
                        receiver.m_36176_(deck.getItemStack(), true);
                    }
                    receiver.m_213846_((Component)deck.getLocalizedName().m_6881_().m_130940_(ChatFormatting.BOLD).m_7220_((Component)Component.m_237113_((String)" deck is added to your inventory!").m_130940_(ChatFormatting.RESET)));
                    return true;
                }
                return false;
            }
            if (args[1].equalsIgnoreCase("cardback")) {
                if (args.length > 3) {
                    CardBack cb = CardBacks.get(args[3]);
                    if (cb == null) {
                        SubcommandBase.sendMessage(sender, ChatFormatting.RED, "Cannot find cardback with ID " + args[3]);
                        return true;
                    }
                    if (!receiver.m_36356_(cb.getItemStack())) {
                        receiver.m_36176_(cb.getItemStack(), true);
                    }
                    receiver.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.BOLD + cb.getName() + ChatFormatting.RESET + " cardback is added to your inventory!")));
                    return true;
                }
                return false;
            }
            if (args[1].equalsIgnoreCase("coin")) {
                if (args.length > 3) {
                    Coin coin = Coins.get(args[3]);
                    if (coin == null) {
                        SubcommandBase.sendMessage(sender, ChatFormatting.RED, "Cannot find coin with ID " + args[3]);
                        return true;
                    }
                    if (!receiver.m_36356_(coin.getItemStack())) {
                        receiver.m_36176_(coin.getItemStack(), true);
                    }
                    receiver.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.BOLD + coin.getName() + ChatFormatting.RESET + " coin is added to your inventory!")));
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }
}

