/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.client.helper;

import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.tcg.api.accessors.CardBacks;
import com.pixelmonmod.tcg.api.card.CardCondition;
import com.pixelmonmod.tcg.api.card.CardRarity;
import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.ability.CardPower;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.api.card.personalization.CardBack;
import com.pixelmonmod.tcg.api.util.helper.LogicHelper;
import com.pixelmonmod.tcg.client.gui.TCGResources;
import com.pixelmonmod.tcg.duel.RenderDuel;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.PlayerClientMyState;
import com.pixelmonmod.tcg.duel.state.PlayerClientOpponentState;
import com.pixelmonmod.tcg.duel.state.PlayerCommonState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class CardRenderingHelper {
    public static final int TEXTURE_WIDTH = 216;
    public static final int TEXTURE_HEIGHT = 335;
    public static final int MAX_TEXT_WIDTH = 94;

    private static void drawStrikethrough(GuiGraphics matrix, CommonCardState card, int cardX, int cardY, float alpha) {
        if (card instanceof PokemonCardState) {
            PokemonCardState pokemon = (PokemonCardState)card;
            int[] descriptionLines = CardRenderingHelper.calculateAttackDescriptionLines(pokemon.getAttacksStatus(), pokemon.getAbility() != null, 94);
            int line = pokemon.getAbility() != null ? 2 : 0;
            for (int i = 0; i < pokemon.getAttacksStatus().length; ++i) {
                PokemonAttackStatus attackStatus = pokemon.getAttacksStatus()[i];
                if (attackStatus.isDisabled()) {
                    int y = cardY / 2 + line * 9 + 5;
                    RenderDuel.draw2DLine(matrix, (float)cardX / 2.0f - 48.0f + (float)(Math.max(3, attackStatus.getData().getCosts().size()) * 6) + 1.0f, y, (float)cardX / 2.0f + 44.0f, y, 0.0f, 0.0f, 0.0f, alpha, 1.0f);
                }
                line += descriptionLines[i] + 1;
            }
        }
    }

    public static void drawCardBack(GuiGraphics matrix, int w, int h, float z, PlayerCommonState me) {
        if (me != null) {
            CardRenderingHelper.drawCardBack(matrix, w, h, z, CardBacks.get(me.getCardBackID()));
        } else {
            CardRenderingHelper.drawCardBack(matrix, w, h, z, CardBacks.STANDARD.getValueUnsafe());
        }
    }

    public static void drawCardBack(GuiGraphics matrix, int w, int h, float z, CardBack cb) {
        ResourceLocation tex = cb != null ? cb.getFile() : CardBacks.STANDARD.getValueUnsafe().getFile();
        ScreenHelper.drawImageQuad(tex, matrix, (float)w / 2.0f - 54.0f, (float)h / 2.0f - 83.75f, 108.0f, 167.5f, 0.0f, 0.0f, 1.0f, 1.0f, z);
    }

    public static void drawCard(GuiGraphics graphics, CommonCardState card, int w, int h, float z, float alpha, double rot, PlayerClientMyState me, PlayerClientOpponentState opp) {
        PokemonCardState temp;
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        if (rot != 0.0) {
            matrix.m_252880_((float)w / 2.0f, (float)h / 2.0f, 0.0f);
            matrix.m_252781_(QuaternionHelper.fromEuler((float)rot, 0.0f, 0.0f, 1.0f));
            matrix.m_252880_((float)(-w) / 2.0f, (float)(-h) / 2.0f, 0.0f);
        }
        int textColor = 0x202020;
        if (card.getMainEnergy() == Energy.DARKNESS || card.getMainEnergy() == Energy.RAINBOW || card.getData() != null && card.getData().isSpecial() && card.getCardType() == CardType.ENERGY) {
            textColor = 0xDDDDDD;
        }
        CardRenderingHelper.drawCardBackground(graphics, card, w, h, z, alpha);
        CardRenderingHelper.drawTypings(graphics, card, w, h, z, alpha);
        CardRenderingHelper.drawCardType(graphics, card, w, h, z, alpha);
        CardRenderingHelper.drawRarity(graphics, card, w, h, z, alpha);
        CardRenderingHelper.drawSet(graphics, card, w, h, z, alpha);
        CardRenderingHelper.drawSprite(graphics, card, w, h, z, alpha);
        if (card instanceof PokemonCardState) {
            CardRenderingHelper.drawPrevEvolution(graphics, (PokemonCardState)card, w, h, z, alpha);
            CardRenderingHelper.drawHP(graphics, (PokemonCardState)card, w, h, textColor, alpha);
            CardRenderingHelper.drawRetreat(graphics, (PokemonCardState)card, w, h, z, alpha, me, opp);
        } else if (card.getCardType().isPokemon()) {
            temp = new PokemonCardState(card.getData(), 0);
            CardRenderingHelper.drawPrevEvolution(graphics, temp, w, h, z, alpha);
            CardRenderingHelper.drawHP(graphics, temp, w, h, textColor, alpha);
            CardRenderingHelper.drawRetreat(graphics, temp, w, h, z, alpha, me, opp);
        } else if (card.getCardType() == CardType.TRAINER) {
            TrainerCardState trainer = new TrainerCardState(card.getData());
            PokemonCardState temp2 = new PokemonCardState(trainer.getData().getEffect(), trainer, 0);
            CardRenderingHelper.drawPrevEvolution(graphics, temp2, w, h, z, alpha);
            CardRenderingHelper.drawHP(graphics, temp2, w, h, textColor, alpha);
        }
        CardRenderingHelper.drawCardName(graphics, card, w, h, alpha);
        CardRenderingHelper.drawCardEffects(graphics, card, w, h, z, textColor, alpha);
        if (card instanceof PokemonCardState) {
            PokemonCardState pokemonCard = (PokemonCardState)card;
            status = pokemonCard.getStatus();
            CardRenderingHelper.drawWeakness(graphics, pokemonCard, w, h, z, alpha);
            CardRenderingHelper.drawResistance(graphics, pokemonCard, w, h, z, alpha);
            CardRenderingHelper.drawConditions(graphics, status.getConditions(), w, h, z, alpha);
            CardRenderingHelper.drawEnergies(graphics, pokemonCard.getAttachments(), w, h, z, alpha);
            CardRenderingHelper.drawStrikethrough(graphics, card, w, h, alpha);
            CardRenderingHelper.drawDamage(graphics, status.getDamage(), w, h, z, alpha);
            CardRenderingHelper.drawHP(graphics, pokemonCard, w, h, textColor, alpha);
        } else if (card.getCardType().isPokemon()) {
            temp = new PokemonCardState(card.getData(), 0);
            CardRenderingHelper.drawWeakness(graphics, temp, w, h, z, alpha);
            CardRenderingHelper.drawResistance(graphics, temp, w, h, z, alpha);
            status = temp.getStatus();
            CardRenderingHelper.drawConditions(graphics, status.getConditions(), w, h, z, alpha);
            CardRenderingHelper.drawDamage(graphics, status.getDamage(), w, h, z, alpha);
            CardRenderingHelper.drawEnergies(graphics, temp.getAttachments(), w, h, z, alpha);
            CardRenderingHelper.drawStrikethrough(graphics, temp, w, h, alpha);
            CardRenderingHelper.drawHP(graphics, temp, w, h, textColor, alpha);
        }
        matrix.m_85849_();
    }

    private static void drawEnergies(GuiGraphics graphics, List<CommonCardState> attachments, int cardX, int cardY, float zLevel, float alpha) {
        int energyCount = 0;
        if (!attachments.isEmpty()) {
            for (CommonCardState attachment : attachments) {
                List<CommonCardState> energies;
                if (attachment.getCardType() == CardType.ENERGY) {
                    ScreenHelper.drawImageQuad(attachment.getMainEnergy().getHighResTexture(), graphics, (float)(cardX - 100 + energyCount++ * 28) / 2.0f, (float)(cardY + 158) / 2.0f, 12.0f, 12.0f, 0.0f, 0.0f, 1.0f, 1.0f, alpha, zLevel);
                    if (attachment.getSecondaryEnergy() == null) continue;
                    ScreenHelper.drawImageQuad(attachment.getSecondaryEnergy().getHighResTexture(), graphics, (float)(cardX - 100 + energyCount++ * 28) / 2.0f, (float)(cardY + 158) / 2.0f, 12.0f, 12.0f, 0.0f, 0.0f, 1.0f, 1.0f, alpha, zLevel);
                    continue;
                }
                if (attachment.getAbility() == null || attachment.getAbility().getEffect() == null || (energies = attachment.getAbility().getEffect().getEnergyEquivalence(attachment)) == null) continue;
                for (CommonCardState energy : energies) {
                    ScreenHelper.drawImageQuad(energy.getMainEnergy().getHighResTexture(), graphics, (float)(cardX - 100 + energyCount++ * 28) / 2.0f, (float)(cardY + 158) / 2.0f, 12.0f, 12.0f, 0.0f, 0.0f, 1.0f, 1.0f, alpha, zLevel);
                }
            }
        }
    }

    private static void drawDamage(GuiGraphics graphics, int damage, int cardX, int cardY, float zLevel, float alpha) {
        if (damage > 0) {
            ScreenHelper.drawImageQuad(new ResourceLocation("tcg", "gui/cards/damage.png"), graphics, (float)(cardX + 75) / 2.0f, (float)(cardY - 180) / 2.0f, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, alpha, zLevel);
            String damageString = Integer.toString(damage);
            CardRenderingHelper.drawString(graphics, damageString, (cardX + 101) / 2, (cardY - 163) / 2, true, ((int)(alpha * 255.0f) << 24) + 0xFFFFFF, false);
        }
    }

    private static void drawConditions(GuiGraphics matrix, List<Pair<CardCondition, Integer>> conditions, int cardX, int cardY, float zLevel, float alpha) {
        for (Pair<CardCondition, Integer> condition : conditions) {
            switch ((CardCondition)((Object)condition.getLeft())) {
                case BURNT: 
                case POISONED: {
                    ScreenHelper.drawImageQuad(new ResourceLocation("tcg", "gui/cards/" + ((CardCondition)((Object)condition.getLeft())).getName().toLowerCase() + ".png"), matrix, (float)(cardX + 75) / 2.0f, (float)(cardY - (condition.getLeft() == CardCondition.BURNT ? 85 : 135)) / 2.0f, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, alpha, zLevel);
                }
            }
        }
    }

    public static int getBackgroundColor(Energy e) {
        switch (e) {
            case COLORLESS: {
                return -287449635;
            }
            case DARKNESS: {
                return -300871407;
            }
            case DRAGON: {
                return -294291424;
            }
            case FAIRY: {
                return -285249815;
            }
            case FIGHTING: {
                return -286889216;
            }
            case FIRE: {
                return -285269504;
            }
            case GRASS: {
                return -301936356;
            }
            case LIGHTNING: {
                return -285225967;
            }
            case METAL: {
                return -293107833;
            }
            case PSYCHIC: {
                return -294256426;
            }
            case WATER: {
                return -301956865;
            }
        }
        return 0;
    }

    public static int getForegroundColor(Energy e) {
        switch (e) {
            case COLORLESS: {
                return -16777216;
            }
            case DARKNESS: 
            case DRAGON: 
            case FAIRY: 
            case FIGHTING: 
            case FIRE: 
            case GRASS: 
            case LIGHTNING: 
            case METAL: 
            case PSYCHIC: 
            case WATER: {
                return -1;
            }
        }
        return 0;
    }

    public static ResourceLocation getCosmeticBackgroundTexture(CommonCardState c) {
        return c.getData().getCustomTexture();
    }

    public static ResourceLocation getBackgroundTexture(CardType cardType, Energy energy, boolean isSpecial) {
        switch (cardType) {
            case EX: {
                return new ResourceLocation("tcg:gui/cards/background/cardbase_" + energy.getUnlocalizedName() + "_EX.png");
            }
            case BASIC: {
                if (energy != null) {
                    return new ResourceLocation("tcg:gui/cards/background/cardbase_" + energy.getUnlocalizedName() + "_basic.png");
                }
                return new ResourceLocation("tcg:gui/cards/background/cardbase_trainer_base.png");
            }
            case ENERGY: {
                if (isSpecial) {
                    return new ResourceLocation("tcg:gui/cards/background/cardbase_" + energy.getUnlocalizedName() + "_senergy.png");
                }
                return new ResourceLocation("tcg:gui/cards/background/cardbase_" + energy.getUnlocalizedName() + "_energy.png");
            }
            case TRAINER: 
            case STADIUM: 
            case SUPPORTER: {
                return new ResourceLocation("tcg:gui/cards/background/cardbase_trainer_base.png");
            }
        }
        return new ResourceLocation("tcg:gui/cards/background/cardbase_" + energy.getUnlocalizedName() + ".png");
    }

    private static ResourceLocation getMaskTexture(CardType cardType, Energy energy) {
        switch (cardType) {
            case EX: {
                return new ResourceLocation("tcg:gui/cards/background/cardbase_" + energy.getUnlocalizedName() + "_EX_mask.png");
            }
            case BASIC: {
                if (energy != null) {
                    return new ResourceLocation("tcg:gui/cards/background/cardbase_" + energy.getUnlocalizedName() + "_basic_mask.png");
                }
                return new ResourceLocation("tcg:gui/cards/background/cardbase_trainer_base_mask.png");
            }
            case ENERGY: {
                return new ResourceLocation("tcg:gui/cards/background/cardbase_" + energy.getUnlocalizedName() + "_energy_mask.png");
            }
            case TRAINER: 
            case STADIUM: 
            case SUPPORTER: {
                return new ResourceLocation("tcg:gui/cards/background/cardbase_trainer_base_mask.png");
            }
        }
        return new ResourceLocation("tcg:gui/cards/background/cardbase_" + energy.getUnlocalizedName() + "_mask.png");
    }

    public static ResourceLocation getAbilityTexture(CardPower cardAbility) {
        switch (cardAbility.getType()) {
            case BODY: {
                return new ResourceLocation("tcg:gui/cards/icons/green.png");
            }
            case POWER: {
                return new ResourceLocation("tcg:gui/cards/icons/red.png");
            }
        }
        return null;
    }

    private static void drawTypings(GuiGraphics graphics, CommonCardState card, int w, int h, float z, float alpha) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        matrix.m_85837_(0.0, 0.5, 0.0);
        CardType ct = card.getCardType();
        if (ct.isPokemon() && card.getMainEnergy() != null) {
            if (card.getSecondaryEnergy() != null) {
                ScreenHelper.drawImageQuad(card.getMainEnergy().getTexture(), graphics, (float)w / 2.0f - 16.0f, (float)h / 2.0f - 78.5f, 10.0f, 10.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, alpha, z);
                ScreenHelper.drawImageQuad(card.getSecondaryEnergy().getTexture(), graphics, (float)w / 2.0f - 6.0f, (float)h / 2.0f - 78.5f, 10.0f, 10.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, alpha, z);
            } else {
                ScreenHelper.drawImageQuad(card.getMainEnergy().getTexture(), graphics, (float)w / 2.0f - 6.0f, (float)h / 2.0f - 78.5f, 10.0f, 10.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, alpha, z);
            }
        }
        matrix.m_85849_();
    }

    private static void drawCardType(GuiGraphics matrix, CommonCardState card, int w, int h, float z, float alpha) {
        CardType ct = card.getCardType();
        if (ct != CardType.ENERGY) {
            ScreenHelper.drawImageQuad(ct.getIcon(), matrix, (float)w / 2.0f - 48.0f, (float)h / 2.0f - 66.5f, 27.0f, 11.5f, 0.0f, 0.0f, 1.0f, 1.0f, alpha, z);
        }
    }

    private static void drawHP(GuiGraphics graphics, PokemonCardState card, int w, int h, int color, float alpha) {
        PoseStack matrix = graphics.m_280168_();
        int cardHealth = card.getHP();
        String cardHealthString = cardHealth + "HP";
        if (cardHealth > 0) {
            matrix.m_85836_();
            matrix.m_85837_(0.3, 0.3, 0.1);
            CardRenderingHelper.drawString(graphics, cardHealthString, w / 2 - 48, h / 2 - 77, false, ((int)(alpha * 255.0f) << 24) + 0xFFFFFF - color * 3, true);
            matrix.m_85849_();
            matrix.m_85836_();
            matrix.m_85837_(-0.3, -0.3, 0.1);
            CardRenderingHelper.drawString(graphics, cardHealthString, w / 2 - 48, h / 2 - 77, false, ((int)(alpha * 255.0f) << 24) + 0xFFFFFF - color * 3, true);
            matrix.m_85849_();
            matrix.m_85836_();
            matrix.m_85837_(0.3, -0.3, 0.1);
            CardRenderingHelper.drawString(graphics, cardHealthString, w / 2 - 48, h / 2 - 77, false, ((int)(alpha * 255.0f) << 24) + 0xFFFFFF - color * 3, true);
            matrix.m_85849_();
            matrix.m_85836_();
            matrix.m_85837_(-0.3, 0.3, 0.1);
            CardRenderingHelper.drawString(graphics, cardHealthString, w / 2 - 48, h / 2 - 77, false, ((int)(alpha * 255.0f) << 24) + 0xFFFFFF - color * 3, true);
            matrix.m_85849_();
            matrix.m_85836_();
            matrix.m_85837_(0.0, 0.0, 0.2);
            CardRenderingHelper.drawString(graphics, cardHealthString, w / 2 - 48, h / 2 - 77, false, ((int)(alpha * 255.0f) << 24) + color, true);
            matrix.m_85849_();
        }
    }

    private static void drawCardName(GuiGraphics matrix, CommonCardState card, int w, int h, float alpha) {
        String cardName = Component.m_237115_((String)card.getName().toLowerCase()).getString();
        matrix.m_280168_().m_85836_();
        float widthConstant = 66.0f;
        int offset = 0;
        if (card.getCardType() == CardType.ENERGY) {
            offset = 27;
        }
        if (card.getCardType() == CardType.STAGE1 || card.getCardType() == CardType.STAGE2 || card.getCardType() == CardType.EX || card.getCardType() == CardType.LVLX || card.getCardType() == CardType.GX) {
            widthConstant -= 17.0f;
        }
        ScreenHelper.drawSquashedString(matrix, Minecraft.m_91087_().f_91062_, cardName, true, widthConstant, (float)w / 2.0f - 18.0f - (float)offset, (float)h / 2.0f - 65.0f, ((int)(alpha * 255.0f) << 24) + 0x202020, false);
        matrix.m_280168_().m_85849_();
    }

    private static void drawSprite(GuiGraphics matrix, CommonCardState card, int w, int h, float z, float alpha) {
        if (card.getCardType().isCosmetic()) {
            return;
        }
        if (card.getCardType() != CardType.ENERGY) {
            if (card.hasTransformation()) {
                if (card.getTransformation().getHasCustomTex()) {
                    ScreenHelper.drawImageQuad(card.getTransformation().getCustomTexture(), matrix, (float)w / 2.0f - 23.5f, (float)h / 2.0f - 53.0f, 47.0f, 47.0f, 0.0f, 0.0f, 1.0f, 1.0f, alpha, z);
                } else {
                    ScreenHelper.drawImageQuad(card.getPokemonSprite(), matrix, (float)w / 2.0f - 32.0f, (float)h / 2.0f - 67.0f, 60.0f, 60.0f, 0.0f, 0.0f, 1.0f, 1.0f, alpha, z);
                }
            } else if (card.getData().getHasCustomTex()) {
                ScreenHelper.drawImageQuad(card.getData().getCustomTexture(), matrix, (float)w / 2.0f - 23.5f, (float)h / 2.0f - 53.0f, 47.0f, 47.0f, 0.0f, 0.0f, 1.0f, 1.0f, alpha, z);
            } else {
                ScreenHelper.drawImageQuad(card.getPokemonSprite(), matrix, (float)w / 2.0f - 32.0f, (float)h / 2.0f - 67.0f, 60.0f, 60.0f, 0.0f, 0.0f, 1.0f, 1.0f, alpha, z);
            }
        } else if (card.getData().getCustomTexture() != null) {
            if (card.getData().isSpecial()) {
                ScreenHelper.drawImageQuad(card.getData().getCustomTexture(), matrix, (float)w / 2.0f - 36.25f, (float)h / 2.0f - 50.0f + 10.0f, 72.5f, 72.5f, 0.0f, 0.0f, 1.0f, 1.0f, alpha, z);
            } else {
                ScreenHelper.drawImageQuad(card.getData().getCustomTexture(), matrix, (float)w / 2.0f - 36.25f, (float)h / 2.0f - 36.25f + 10.0f, 72.5f, 72.5f, 0.0f, 0.0f, 1.0f, 1.0f, alpha, z);
            }
        }
    }

    private static void drawPrevEvolution(GuiGraphics matrix, PokemonCardState card, int w, int h, float z, float alpha) {
        if (card.getCardType().isPokemon() && card.getPreviousPokemonID() > 0) {
            ResourceLocation tex = card.getPreviousPokemonID() == 10000 ? TCGResources.FOSSIL : card.getPreviousPokemonSprite();
            ScreenHelper.drawImageQuad(tex, matrix, (float)w / 2.0f + 31.0f, (float)h / 2.0f - 68.0f, 19.0f, 19.0f, 0.0f, 0.0f, 1.0f, 1.0f, alpha, z);
        }
    }

    private static void drawCardEffects(GuiGraphics matrix, CommonCardState card, int w, int h, float z, int t, float alpha) {
        int resetColor = t;
        if (card.getCardType() == CardType.STADIUM || card.getCardType() == CardType.TRAINER || card.getDescription() != null && !card.getDescription().isEmpty()) {
            if (card.getData().getEffect() == null && !card.getData().getCode().equalsIgnoreCase("BASE96") && !card.getData().getCode().equalsIgnoreCase("TERO80")) {
                t = 0xEE0000;
            }
            if (card.getCardType() == CardType.ENERGY) {
                CardRenderingHelper.drawCardText(matrix, card.getData(), 4, 3, 94, w, h, alpha, t);
            } else {
                CardRenderingHelper.drawCardText(matrix, card.getData(), -1, 8, 94, w, h, alpha, t);
            }
        } else {
            int lineCount = 0;
            CardPower cardAbility = card.getAbility();
            PokemonAttackStatus[] attacks = null;
            if (card instanceof PokemonCardState) {
                attacks = ((PokemonCardState)card).getAttacksStatus();
            } else if (card.getData().getAttacks() != null) {
                attacks = (PokemonAttackStatus[])card.getData().getAttacks().stream().map(PokemonAttackStatus::new).toArray(PokemonAttackStatus[]::new);
            }
            if (cardAbility != null) {
                int linesForAbility;
                ScreenHelper.drawImageQuad(CardRenderingHelper.getAbilityTexture(cardAbility), matrix, (float)w / 2.0f - 46.0f, (float)h / 2.0f + 1.0f, 6.0f, 6.0f, 0.0f, 0.0f, 1.0f, 1.0f, alpha, z);
                matrix.m_280168_().m_85836_();
                String name = "\u00a7l" + Component.m_237115_((String)cardAbility.getName().toLowerCase()).getString();
                float widthConstant = 88.0f;
                int altColor = ((int)(alpha * 255.0f) << 24) + 0x444444;
                if (cardAbility.getEffect() == null) {
                    t = 0xEE0000;
                    altColor = ((int)(alpha * 255.0f) << 24) + 0xDD0000;
                }
                ScreenHelper.drawSquashedString(matrix, Minecraft.m_91087_().f_91062_, name, true, widthConstant, (float)w / 2.0f - 46.0f + 8.0f, (float)h / 2.0f, ((int)(alpha * 255.0f) << 24) + t, false);
                matrix.m_280168_().m_85849_();
                String description = "\u00a7o" + Component.m_237115_((String)cardAbility.getDescription().toLowerCase()).getString();
                ++lineCount;
                int n = linesForAbility = attacks != null && attacks.length > 0 ? 2 : 5;
                if (attacks.length == 1 && !attacks[0].hasDescription()) {
                    linesForAbility = 4;
                }
                lineCount += CardRenderingHelper.drawMultiline(matrix, description, linesForAbility, w / 2 - 46, h / 2 + 9, 94, altColor);
                t = resetColor;
            }
            if (attacks != null) {
                int[] descriptionLines = CardRenderingHelper.calculateAttackDescriptionLines(attacks, cardAbility != null, 94);
                for (int i = 0; i < attacks.length; ++i) {
                    int bonus = 0;
                    if (card instanceof PokemonCardState) {
                        bonus = ((PokemonCardState)card).getAttacksStatus()[i].getDamageBonus();
                    }
                    lineCount += CardRenderingHelper.drawAttack(matrix, attacks[i], bonus, lineCount, descriptionLines[i], 94, w, h, z, t, alpha);
                }
            }
        }
    }

    public static int[] calculateAttackDescriptionLines(PokemonAttackStatus[] attacks, boolean hasAbility, int maxWidth) {
        int attackCount = 0;
        for (PokemonAttackStatus attack : attacks) {
            if (attack == null) continue;
            ++attackCount;
        }
        int availableLines = 6;
        if (hasAbility) {
            availableLines -= 3;
        }
        availableLines -= attackCount;
        int[] totalDescriptionLines = new int[attacks.length];
        int totalLines = 0;
        for (int i = 0; i < attacks.length; ++i) {
            if (attacks[i] == null || !attacks[i].hasDescription()) continue;
            List<String> lines = ScreenHelper.splitString(attacks[i].getLocalizedDescription().getString(), maxWidth, true);
            totalDescriptionLines[i] = lines.size();
            totalLines += lines.size();
        }
        int[] result = new int[attacks.length];
        if (totalLines <= availableLines) {
            result = totalDescriptionLines;
        } else {
            int averageLines = availableLines / attackCount;
            int extraLines = availableLines;
            for (int i = 0; i < attacks.length; ++i) {
                result[i] = Math.min(totalDescriptionLines[i], averageLines);
                extraLines -= result[i];
            }
            boolean updated = true;
            while (extraLines > 0 && updated) {
                updated = false;
                for (int i = 0; i < attacks.length; ++i) {
                    if (result[i] >= totalDescriptionLines[i]) continue;
                    int newLines = Math.min(totalDescriptionLines[i], result[i] + extraLines);
                    extraLines -= newLines - result[i];
                    result[i] = newLines;
                    updated = true;
                }
            }
        }
        return result;
    }

    public static int calculateTrainerDescriptionLines(ImmutableCard effect, int maxWidth) {
        int availableLines = 8;
        int totalDescriptionLines = 0;
        int totalLines = 0;
        if (effect != null && effect.getDescription() != null) {
            List<String> lines = ScreenHelper.splitString(effect.getDescription(), maxWidth, true);
            totalDescriptionLines = lines.size();
            totalLines += lines.size();
        }
        int result = 0;
        if (totalLines <= availableLines) {
            result = totalDescriptionLines;
        } else {
            int averageLines = availableLines;
            int extraLines = availableLines;
            result = Math.min(totalDescriptionLines, averageLines);
            extraLines -= result;
            boolean updated = true;
            while (extraLines > 0 && updated) {
                updated = false;
                if (result >= totalDescriptionLines) continue;
                int newLines = Math.min(totalDescriptionLines, result + extraLines);
                extraLines -= newLines - result;
                result = newLines;
                updated = true;
            }
        }
        return result;
    }

    private static int drawAttack(GuiGraphics matrix, PokemonAttackStatus attack, int bonus, int pos, int descriptionLineCount, int maxWidth, int width, int height, float zLevel, int color, float alpha) {
        matrix.m_280168_().m_85836_();
        matrix.m_280168_().m_252880_(0.0f, 0.0f, zLevel + 1.0f);
        if (attack != null) {
            int verticalOffset = pos * 9;
            int altColor = ((int)(alpha * 255.0f) << 24) + 0x444444;
            CardAttack data = attack.getData();
            if (data.getText() == null || !data.hasEffects()) {
                // empty if block
            }
            for (int x = 0; x < data.getCosts().size(); ++x) {
                ScreenHelper.drawImageQuad(attack.getData().getCosts().get(x).getTexture(), matrix, (float)width / 2.0f - 46.0f + (float)(x * 6), (float)height / 2.0f + 2.0f + (float)verticalOffset - 0.5f, 6.0f, 6.0f, 0.0f, 0.0f, 1.0f, 1.0f, alpha, zLevel);
            }
            int lineCount = 1;
            String modifier = data.getModifier() == null ? "" : data.getModifier().toString();
            int damage = data.getDamage();
            if (damage != 0) {
                String damageString = damage + modifier;
                if (bonus > 0) {
                    damageString = damage + "+" + bonus;
                } else if (bonus < 0) {
                    damageString = damage + "-" + -bonus;
                }
                ScreenHelper.drawString(matrix, damageString, (float)width / 2.0f + 35.0f, (float)height / 2.0f + (float)verticalOffset, ((int)(alpha * 255.0f) << 24) + color, false, true);
            }
            String name = Component.m_237115_((String)data.getName().toLowerCase()).getString();
            float widthConstant = 56.0f;
            double offset = Math.max(3, data.getCosts().size()) * 6 + 1;
            ScreenHelper.drawSquashedString(matrix, Minecraft.m_91087_().f_91062_, name, true, widthConstant, (float)width / 2.0f - 46.0f + (float)((int)offset), (float)height / 2.0f + (float)verticalOffset, ((int)(alpha * 255.0f) << 24) + color, false);
            if (attack.hasDescription()) {
                lineCount += CardRenderingHelper.drawMultiline(matrix, "\u00a7o" + attack.getLocalizedDescription().getString(), descriptionLineCount, width / 2 - 46, height / 2 + 9 + verticalOffset, maxWidth, altColor);
            }
            matrix.m_280168_().m_85849_();
            return lineCount;
        }
        matrix.m_280168_().m_85849_();
        return 0;
    }

    private static int drawCardText(GuiGraphics matrix, ImmutableCard card, int pos, int lines, int maxWidth, int width, int height, float o, int color) {
        boolean unicode = Minecraft.m_91087_().m_91390_();
        Minecraft.m_91087_().m_91336_(true);
        if (card != null) {
            int verticalOffset = pos * 9;
            int lineCount = 0;
            if (card.getDescription() != null) {
                lineCount += CardRenderingHelper.drawMultiline(matrix, Component.m_237115_((String)card.getDescription().toLowerCase()).getString(), lines, width / 2 - 46, height / 2 + 9 + verticalOffset, maxWidth, ((int)(o * 255.0f) << 24) + color);
            }
            return lineCount;
        }
        Minecraft.m_91087_().m_91336_(unicode);
        return 0;
    }

    private static void drawRarity(GuiGraphics matrix, CommonCardState card, int w, int h, float z, float alpha) {
        CardRarity cardRarity;
        if (card.getCardType() != CardType.ENERGY && (cardRarity = card.getRarity()) != null) {
            ScreenHelper.drawImageQuad(new ResourceLocation("tcg", "gui/cards/icons/" + cardRarity.getUnlocalizedName() + ".png"), matrix, (float)w / 2.0f + 42.0f, (float)h / 2.0f - 9.0f, 8.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, alpha, z);
        }
    }

    private static void drawSet(GuiGraphics matrix, CommonCardState card, int w, int h, float z, float alpha) {
        int setID;
        if (card.getCardType() != CardType.ENERGY && card.getSetID() != 1 && (setID = card.getSetID()) <= 1000) {
            ScreenHelper.drawImageQuad(new ResourceLocation("tcg", "gui/cards/icons/sets/" + setID + ".png"), matrix, (float)w / 2.0f - 46.0f, (float)h / 2.0f - 21.0f, 16.666666f, 16.666666f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.5f * alpha, z);
        }
    }

    private static void drawRetreat(GuiGraphics matrix, PokemonCardState card, int w, int h, float z, float alpha, PlayerClientMyState me, PlayerClientOpponentState opp) {
        if (card.getCardType().isPokemon() && card.getRetreatCost() != 0) {
            int costModifier = LogicHelper.getCostModifier(me, opp);
            costModifier = Math.max(costModifier, -card.getRetreatCost());
            int renderCost = card.getRetreatCost() + costModifier;
            int modo = 3 * renderCost;
            for (int i = 0; i < renderCost; ++i) {
                ScreenHelper.drawImageQuad(TCGResources.ENERGY_COLORLESS, matrix, (float)w / 2.0f + 31.0f + (float)(6 * i) - (float)modo, (float)h / 2.0f + 67.5f, 6.0f, 6.0f, 0.0f, 0.0f, 1.0f, 1.0f, alpha, z);
            }
        }
    }

    private static void drawWeakness(GuiGraphics matrix, PokemonCardState card, int w, int h, float z, float alpha) {
        if (card.getCardType().isPokemon() && card.getWeakness() != null) {
            String weaknessString = card.getWeaknessModifier().toString() + card.getWeaknessValue();
            int weaknessWidth = ScreenHelper.getStringWidth(weaknessString, true);
            ScreenHelper.drawImageQuad(card.getWeakness().getTexture(), matrix, (float)w / 2.0f - 38.0f - (float)weaknessWidth / 2.0f, (float)h / 2.0f + 67.5f, 6.0f, 6.0f, 0.0f, 0.0f, 1.0f, 1.0f, alpha, z);
            ScreenHelper.drawString(matrix, weaknessString, (float)w / 2.0f - 31.0f - (float)weaknessWidth / 2.0f, (float)h / 2.0f + 65.5f, ((int)(alpha * 255.0f) << 24) + 0xBBBBBB, false, true);
        }
    }

    private static void drawResistance(GuiGraphics matrix, PokemonCardState card, int w, int h, float z, float alpha) {
        if (card.getCardType().isPokemon() && card.getResistance() != null) {
            String resistanceString = card.getResistanceModifier().toString() + card.getResistanceValue();
            int resistanceWidth = ScreenHelper.getStringWidth(resistanceString, true);
            ScreenHelper.drawImageQuad(card.getResistance().getTexture(), matrix, (float)w / 2.0f - 7.0f - (float)resistanceWidth / 2.0f, (float)h / 2.0f + 67.5f, 6.0f, 6.0f, 0.0f, 0.0f, 1.0f, 1.0f, alpha, z);
            ScreenHelper.drawString(matrix, resistanceString, (float)w / 2.0f - (float)resistanceWidth / 2.0f, (float)h / 2.0f + 65.5f, ((int)(alpha * 255.0f) << 24) + 0xBBBBBB, false, true);
        }
    }

    private static void drawCardBackground(GuiGraphics matrix, CommonCardState card, int w, int h, float z, float alpha) {
        ResourceLocation tex = card.getCardType().isCosmetic() ? CardRenderingHelper.getCosmeticBackgroundTexture(card) : CardRenderingHelper.getBackgroundTexture(card.getCardType(), card.getMainEnergy(), card.getData().isSpecial());
        ScreenHelper.drawImageQuad(tex, matrix, (float)w / 2.0f - 54.0f, (float)h / 2.0f - 83.75f, 108.0f, 167.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, alpha, z);
    }

    private static int drawMultiline(GuiGraphics matrix, String description, int maxLines, int x, int y, int maxWidth, int color) {
        boolean unicode = Minecraft.m_91087_().m_91390_();
        Minecraft.m_91087_().m_91336_(true);
        String style = description.startsWith("\u00a7") ? description.substring(0, 2) : "";
        List properties = Minecraft.m_91087_().f_91062_.m_92865_().m_92432_(description, maxWidth, Style.f_131099_);
        int i = 0;
        for (FormattedText line : properties) {
            if (i + 1 == maxLines && properties.size() > maxLines) {
                line = Component.m_237113_((String)(((FormattedText)Minecraft.m_91087_().f_91062_.m_92865_().m_92432_(line.getString() + "------------------------------------", maxWidth, Style.f_131099_).get(0)).getString() + "..."));
            }
            matrix.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)(style + line.getString())), x, y + i * 8, color);
            if (++i < maxLines) continue;
            break;
        }
        Minecraft.m_91087_().m_91336_(unicode);
        return i;
    }

    private static void drawString(GuiGraphics matrix, String content, int x, int y, boolean centered, int color, boolean unicode) {
        ScreenHelper.drawString(matrix, Minecraft.m_91087_().f_91062_, content, x, y, color, false, unicode, centered);
    }
}

