/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.client.gui.duel;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.util.helpers.CursorHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.camera.CameraEntity;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.render.OverlayToggles;
import com.pixelmonmod.tcg.api.accessors.Coins;
import com.pixelmonmod.tcg.api.card.CardCondition;
import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.api.config.TCGConfigProxy;
import com.pixelmonmod.tcg.api.util.helper.LogicHelper;
import com.pixelmonmod.tcg.api.util.helper.NetworkHelper;
import com.pixelmonmod.tcg.api.util.helper.SelectorHelper;
import com.pixelmonmod.tcg.client.gui.PlayerTargetsScreen;
import com.pixelmonmod.tcg.client.gui.TargetScreen;
import com.pixelmonmod.tcg.client.gui.abilities.GuiOptional;
import com.pixelmonmod.tcg.client.gui.abilities.GuiPeek;
import com.pixelmonmod.tcg.client.gui.base.TCGScreenChattableBase;
import com.pixelmonmod.tcg.client.gui.duel.CardSelector;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.duel.DuelLogScreen;
import com.pixelmonmod.tcg.client.gui.duel.FlippingCoinScreen;
import com.pixelmonmod.tcg.client.gui.duel.InspectingCard;
import com.pixelmonmod.tcg.client.gui.duel.PrizeSelectorScreen;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorPurpose;
import com.pixelmonmod.tcg.client.helper.BattleHelper;
import com.pixelmonmod.tcg.client.helper.CardRenderingHelper;
import com.pixelmonmod.tcg.client.renderers.BattleControllerTileEntityRenderer;
import com.pixelmonmod.tcg.duel.RenderDuel;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GamePhase;
import com.pixelmonmod.tcg.duel.state.PlayerClientMyState;
import com.pixelmonmod.tcg.duel.state.PlayerClientOpponentState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.network.packets.GenericGUIPacket;
import com.pixelmonmod.tcg.network.packets.battles.GenericActionRequestPacket;
import com.pixelmonmod.tcg.network.packets.battles.UpdateServerCardRecordPacket;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import com.pixelmonmod.tcg.network.packets.enums.PhaseAction;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import org.apache.commons.lang3.tuple.Pair;

public class TCGScreen
extends TCGScreenChattableBase {
    public static final String GUI_PEEK_ID = "GUI_PEEK";
    public static final String GUI_OPTIONAL_ID = "GUI_OPTIONAL";
    private static final int BUTTON_ENDTURN_ID = 10;
    private static final int BUTTON_DISCARD_ID = 11;
    public BattleOwnedTileEntityController controller;
    private final int playerIndex;
    private boolean isCardInSelectMode = false;
    private CardWithLocation draggingCard = null;
    private final InspectingCard inspectingCard;
    private final CardSelector cardSelector;
    private final FlippingCoinScreen guiFlippingCoin;
    private final DuelLogScreen guiDuelLog;
    private final PrizeSelectorScreen guiPrizeSelector;
    boolean isSpectating = false;
    private int ticks = 0;
    public double guiScaling;
    public float scaledWidth;
    public float scaledHeight;
    public float scaledFactor;
    private final Set<Screen> subGui = Sets.newHashSet();
    private final PlayerTargetsScreen myTargets;
    private final PlayerTargetsScreen oppTargets;
    private final IndexedButton buttonEndTurn = new IndexedButton(10, 0, 0, 80, 20, "End turn", this::actionPerformed);
    private final IndexedButton buttonDiscard = new IndexedButton(11, 0, 0, 80, 20, "Discard", this::actionPerformed);
    private final TargetScreen buttonAbility;
    private final TargetScreen[] buttonAttacks;
    private final TargetScreen buttonRetreat;
    private final GuiPeek guiPeek;
    private final GuiOptional guiOptional;

    public TCGScreen(BattleOwnedTileEntityController controller, int playerIndex, boolean isSpectating) {
        this.controller = controller;
        this.playerIndex = playerIndex;
        this.isSpectating = isSpectating;
        this.inspectingCard = new InspectingCard(this);
        this.cardSelector = new CardSelector(this, controller);
        this.guiFlippingCoin = new FlippingCoinScreen(this, controller);
        this.guiDuelLog = new DuelLogScreen(this);
        this.guiPrizeSelector = new PrizeSelectorScreen(this, controller);
        this.guiPeek = new GuiPeek(this, controller);
        this.guiPeek.visible = false;
        this.guiOptional = new GuiOptional(this, controller);
        this.guiOptional.visible = false;
        this.myTargets = new PlayerTargetsScreen();
        this.oppTargets = new PlayerTargetsScreen();
        this.buttonAbility = new TargetScreen(0.0f);
        this.buttonAttacks = new TargetScreen[3];
        for (int i = 0; i < this.buttonAttacks.length; ++i) {
            this.buttonAttacks[i] = new TargetScreen(0.0f);
        }
        this.buttonRetreat = new TargetScreen(0.0f);
    }

    public InspectingCard getInspectingCard() {
        return this.inspectingCard;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.updateLocalDimensions();
        this.m_169413_();
        this.m_142416_((GuiEventListener)this.buttonEndTurn);
        this.m_142416_((GuiEventListener)this.buttonDiscard);
        this.buttonDiscard.f_93624_ = false;
        this.subGui.clear();
        this.subGui.add(this.cardSelector);
        this.subGui.add(this.guiFlippingCoin);
        this.subGui.add(this.guiPrizeSelector);
        this.subGui.add(this.guiPeek);
        this.subGui.add(this.guiOptional);
        this.subGui.forEach(screen -> screen.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_));
        this.updateTargetPositions();
        this.f_96541_.f_91066_.f_92062_ = true;
        OverlayToggles.disableOverlays(VanillaGuiOverlay.SCOREBOARD);
        CursorHelper.setCursor(CursorHelper.BATTLE_CURSOR);
    }

    @Override
    public void m_7379_() {
        super.m_7379_();
        this.f_96541_.f_91066_.f_92062_ = false;
        this.f_96541_.f_91066_.m_231928_().m_231514_((Object)TCGConfigProxy.getConfig().getSavedUIScale());
        OverlayToggles.resetOverlays();
        BattleHelper.resetViewEntity();
        NetworkHelper.sendToServer(new GenericGUIPacket(GenericGUIPacket.GUITypes.spectating(this.isSpectating), false, this.controller.m_58899_()));
        this.controller = null;
        CursorHelper.resetCursor();
    }

    @Override
    public void m_86600_() {
        if (this.controller == null) {
            this.f_96541_.f_91074_.m_6915_();
        }
        super.m_86600_();
        if (this.ticks == 0) {
            this.updateCameraPositions(BattleControllerTileEntityRenderer.getFacing(this.controller));
        }
        BattleHelper.setViewEntity((Entity)ClientProxy.camera);
        if (this.controller != null && this.controller.getClient() != null && this.controller.getClient().getMe() != null) {
            BaseTrainerEffect effect;
            float width;
            CommonCardState card;
            GameClientState client = this.controller.getClient();
            PlayerClientMyState me = client.getMe();
            PlayerClientOpponentState opp = client.getOpponent();
            if (me.getPendingPrizeCount() > 0 || !this.controller.getShowingPrizes().isEmpty()) {
                if (me.getPendingPrizePlayerIndex() == client.getPlayerIndex()) {
                    this.guiPrizeSelector.setPrizes(me.getPrizeCards());
                } else {
                    this.guiPrizeSelector.setPrizes(opp.getPrizeCards());
                }
            } else {
                this.guiPrizeSelector.setPrizes(null);
            }
            if (this.inspectingCard != null && this.inspectingCard.getCard() != null && (card = this.inspectingCard.getCard()) instanceof PokemonCardState) {
                PokemonCardState pokemon = (PokemonCardState)card;
                int line = 0;
                if (pokemon.getAbility() != null) {
                    line = 3;
                    if (pokemon.getData().getAttacks().size() == 1 && pokemon.getData().getAttacks().get(0).getText() == null) {
                        line = 5;
                    }
                }
                int[] attackLines = CardRenderingHelper.calculateAttackDescriptionLines(pokemon.getAttacksStatus(), pokemon.getAbility() != null, 94);
                for (int i = 0; i < attackLines.length; ++i) {
                    float spacing = 9.0f;
                    int offset = i > 0 && attackLines[i - 1] == 0 ? 2 : 0;
                    int height = 12 - offset;
                    if (attackLines[i] == 0 && i < attackLines.length - 1) {
                        height -= 2;
                    }
                    this.buttonAttacks[i].setHeight(height);
                    this.buttonAttacks[i].setX((int)((double)(this.scaledWidth / 2.0f) + (double)(this.inspectingCard.isPickingAttack() ? 0 : 150) * this.guiScaling - 56.0));
                    this.buttonAttacks[i].setY((int)(this.scaledHeight / 2.0f + (-2.0f + (float)line * spacing + (float)offset)));
                    line += attackLines[i] + 1;
                }
            }
            if (me.getActiveCard() == null && client.getGamePhase().after(GamePhase.PreMatch) && me.hasPrizeLeft() && opp.hasPrizeLeft() && this.guiPrizeSelector.getPrizes() == null) {
                if (this.cardSelector.getPurpose() == null) {
                    CardSelectorState state = SelectorHelper.generateSelectorForBench(me, "battle.selector.newactive");
                    this.cardSelector.set(CardSelectorPurpose.KnockoutSwitch, state);
                }
            } else if (me.getActiveCard() != null && this.cardSelector.getPurpose() == CardSelectorPurpose.KnockoutSwitch) {
                this.cardSelector.set(null, null);
            } else if (me.getCardSelectorState() != null) {
                this.cardSelector.set(CardSelectorPurpose.Trainer, this.controller.getClient().getMe().getCardSelectorState());
                this.inspectingCard.clear();
            } else if (this.cardSelector.getPurpose() == CardSelectorPurpose.Trainer) {
                this.cardSelector.set(null, null);
            }
            if ((this.cardSelector.getPurpose() == CardSelectorPurpose.FinishRetreating || this.cardSelector.getPurpose() == CardSelectorPurpose.StartRetreating) && this.cardSelector.getData().isCancellable() && !client.isMyTurn()) {
                this.cardSelector.set(null, null);
            }
            if (me.isChoosingOppAttack()) {
                this.inspectingCard.set(opp.getActiveCard(), false, BoardLocation.Active, 0, true, "Choose an attack", true);
            } else if (this.inspectingCard.isPickingAttack()) {
                this.inspectingCard.clear();
            }
            if (this.myTargets.handTargets.size() != me.getHand().size()) {
                ArrayList handTargets = Lists.newArrayList();
                for (int i = 0; i < me.getHand().size(); ++i) {
                    handTargets.add(new TargetScreen(0.0f));
                }
                this.myTargets.handTargets = handTargets;
            }
            for (int i = 0; i < this.myTargets.handTargets.size(); ++i) {
                double cardOffset = 12.6 * (double)i;
                double handOffset = -5.5 * (double)this.myTargets.handTargets.size() - 10.0;
                width = i < this.myTargets.handTargets.size() - 1 ? 12.6f : 26.0f;
                this.myTargets.handTargets.get(i).setWidth((int)((double)width * this.guiScaling));
                this.myTargets.handTargets.get(i).setHeight((int)(40.0 * this.guiScaling));
                this.myTargets.handTargets.get(i).setX((int)(this.scaledWidth / 2.0f + (float)((int)((handOffset + cardOffset) * this.guiScaling))));
                this.myTargets.handTargets.get(i).setY((int)(this.scaledHeight - (float)((int)(42.0 * this.guiScaling))));
            }
            if (this.oppTargets.handTargets.size() != opp.getHand().size()) {
                ArrayList<TargetScreen> handTargets = new ArrayList<TargetScreen>();
                for (int i = 0; i < opp.getHand().size(); ++i) {
                    handTargets.add(new TargetScreen(0.0f));
                }
                this.oppTargets.handTargets = handTargets;
            }
            for (int i = 0; i < this.oppTargets.handTargets.size(); ++i) {
                double cardOffset = 12.6 * (double)i;
                double handOffset = -5.5 * (double)this.oppTargets.handTargets.size() - 10.0;
                width = i < this.oppTargets.handTargets.size() - 1 ? 12.6f : 26.0f;
                this.oppTargets.handTargets.get(i).setWidth((int)((double)width * this.guiScaling));
                this.oppTargets.handTargets.get(i).setHeight((int)(40.0 * this.guiScaling));
                this.oppTargets.handTargets.get(i).setX((int)(this.scaledWidth / 2.0f + (float)((int)((handOffset + cardOffset) * this.guiScaling))));
                this.oppTargets.handTargets.get(i).setY((int)(-33.0 * this.guiScaling));
            }
            this.buttonEndTurn.f_93624_ = this.cardSelector.getData() == null && client.getCoinFlip() == null && !this.isSpectating;
            boolean bl = this.buttonEndTurn.f_93623_ = client.getGamePhase().after(GamePhase.PreMatch) && client.isMyTurn() || !client.getGamePhase().after(GamePhase.PreMatch) && me.getActiveCard() != null && !me.isReady();
            if (client.getGamePhase() == GamePhase.PreMatch && !this.controller.getClient().getMe().isReady() || client.getGamePhase() != GamePhase.PreMatch && this.controller.getClient().isMyTurn()) {
                if (client.getGamePhase() == GamePhase.PreMatch) {
                    this.buttonEndTurn.setMessage("Start Game");
                } else {
                    this.buttonEndTurn.setMessage("End Turn");
                }
            } else {
                this.buttonEndTurn.setMessage("Waiting...");
            }
            this.buttonDiscard.f_93624_ = false;
            if (this.inspectingCard != null && this.inspectingCard.getCard() != null && this.inspectingCard.isMine() && !this.isSpectating && (effect = this.inspectingCard.getCard().getData().getEffect()) != null && effect.showDiscardButton()) {
                this.buttonDiscard.f_93624_ = true;
            }
            if (me.getCustomGUI() != null) {
                switch (me.getCustomGUI()) {
                    case "GUI_PEEK": {
                        this.guiPeek.visible = true;
                        this.guiPeek.m_7856_();
                        break;
                    }
                    case "GUI_OPTIONAL": {
                        this.guiOptional.visible = true;
                        this.guiOptional.m_7856_();
                        break;
                    }
                    default: {
                        this.guiPeek.visible = false;
                        this.guiOptional.visible = false;
                        break;
                    }
                }
            } else {
                this.guiPeek.visible = false;
                this.guiOptional.visible = false;
            }
            this.inspectingCard.update(this.isRightMousePressed());
            this.subGui.forEach(Screen::m_86600_);
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        boolean enabled;
        GameClientState client = this.controller.getClient();
        PlayerClientMyState me = client.getMe();
        if (me == null) {
            return false;
        }
        PlayerClientOpponentState opp = client.getOpponent();
        List<ImmutableCard> myHand = me.getHand();
        boolean handled = false;
        boolean bl = enabled = this.cardSelector.getData() == null && (client.getCoinFlip() == null || client.getCoinFlip().getResults().isEmpty()) && this.guiPrizeSelector.getPrizes() == null && !this.guiPeek.visible && !this.guiOptional.visible;
        if (enabled && !this.isSpectating) {
            int pos;
            this.handleAbilityButton(this.controller.getClient().getPlayerIndex(), this.controller.getClient().isMyTurn(), mouseX, mouseY, me);
            this.handleAttackButtons(this.controller.getClient().getPlayerIndex(), this.controller.getClient().isMyTurn(), mouseX, mouseY, me);
            handled = this.handleRetreatButton(this.controller.getClient().isMyTurn(), mouseX, mouseY, me, opp) || handled;
            for (pos = 0; pos < myHand.size(); ++pos) {
                handled = this.handleCardInHand(mouseX, mouseY, mouseButton, myHand, opp.getHand(), pos, true) || handled;
            }
            for (pos = 0; pos < opp.getHand().size(); ++pos) {
                handled = this.handleCardInHand(mouseX, mouseY, mouseButton, myHand, opp.getHand(), pos, false) || handled;
            }
        }
        if (this.draggingCard == null) {
            this.isCardInSelectMode = false;
        }
        if (enabled) {
            handled = this.handleActiveCards(mouseX, mouseY, me, opp) || handled;
            handled = this.handleBenchCards(mouseX, mouseY, me, opp) || handled;
            boolean bl2 = handled = this.handleTrainerCards(mouseX, mouseY, me, opp) || handled;
        }
        if (!handled) {
            this.inspectingCard.clear();
        }
        if (this.draggingCard == null && me.getCardSelectorState() == null && this.isLeftMousePressed()) {
            if ((this.playerIndex == 0 && mouseX > (double)(this.scaledWidth / 2.0f - 106.0f) && mouseX < (double)(this.scaledWidth / 2.0f - 78.0f) && mouseY < (double)(this.scaledHeight / 2.0f + 72.0f) && mouseY > (double)(this.scaledHeight / 2.0f + 51.0f) || this.playerIndex == 1 && mouseX > (double)(this.scaledWidth / 2.0f + 79.0f) && mouseX < (double)(this.scaledWidth / 2.0f + 107.0f) && mouseY < (double)(this.scaledHeight / 2.0f + 72.0f) && mouseY > (double)(this.scaledHeight / 2.0f + 51.0f)) && !me.getDiscardPile().isEmpty()) {
                CardSelectorState discard = new CardSelectorState(0, 0, CardSelectorDisplay.Reveal, false, "selector.mydiscard");
                for (ImmutableCard c : me.getDiscardPile()) {
                    discard.getCardList().add(new CardWithLocation(new CommonCardState(c), true, BoardLocation.DiscardPile, 0));
                }
                me.setCardSelectorState(discard);
            }
            if ((this.playerIndex == 0 && mouseX > (double)(this.scaledWidth / 2.0f - 106.0f) && mouseX < (double)(this.scaledWidth / 2.0f - 78.0f) && mouseY < (double)(this.scaledHeight / 2.0f - 94.0f) && mouseY > (double)(this.scaledHeight / 2.0f - 115.0f) || this.playerIndex == 1 && mouseX > (double)(this.scaledWidth / 2.0f + 79.0f) && mouseX < (double)(this.scaledWidth / 2.0f + 107.0f) && mouseY < (double)(this.scaledHeight / 2.0f - 94.0f) && mouseY > (double)(this.scaledHeight / 2.0f - 115.0f)) && !opp.getDiscardPile().isEmpty()) {
                CardSelectorState discard = new CardSelectorState(0, 0, CardSelectorDisplay.Reveal, false, "selector.oppdiscard");
                for (ImmutableCard c : opp.getDiscardPile()) {
                    discard.getCardList().add(new CardWithLocation(new CommonCardState(c), false, BoardLocation.DiscardPile, 0));
                }
                me.setCardSelectorState(discard);
            }
        }
        this.subGui.forEach(screen -> screen.m_6375_(mouseX, mouseY, mouseButton));
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int state) {
        GameClientState client = this.controller.getClient();
        PlayerClientMyState me = client.getMe();
        if (me != null) {
            List<ImmutableCard> myHand = me.getHand();
            if (this.draggingCard != null) {
                this.releaseDraggingCard((int)mouseX, (int)mouseY, myHand, this.controller.getClient().getPlayerIndex());
            }
        }
        return super.m_6348_(mouseX, mouseY, state);
    }

    @Override
    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(matrix, mouseX, mouseY, partialTicks);
        this.updateLocalDimensions();
        this.updateTargetPositions();
        if (this.f_96541_ != null && this.controller != null && this.controller.getClient() != null) {
            if (this.controller.getClient().getMe() == null || this.controller.getClient().getOpponent() == null) {
                String s = "Waiting for another player...";
                ScreenHelper.drawString(matrix, s, this.scaledWidth / 2.0f - (float)ScreenHelper.getStringWidth(s) / 2.0f, this.scaledHeight / 2.0f, 0xFFFFFF, true);
                this.buttonEndTurn.f_93624_ = false;
            } else {
                Object text;
                this.myTargets.draw(matrix, mouseX, mouseY);
                this.oppTargets.draw(matrix, mouseX, mouseY);
                GameClientState client = this.controller.getClient();
                PlayerClientMyState me = client.getMe();
                PlayerClientOpponentState opp = client.getOpponent();
                List<ImmutableCard> myHand = me.getHand();
                List<ImmutableCard> oppHand = opp.getHand();
                if (client.getGamePhase() == GamePhase.PreMatch && !this.isSpectating) {
                    ResourceLocation tex = client.isMyTurn() ? Coins.get(this.controller.getClient().getMe().getCoinSetID()).getHeads() : Coins.get(this.controller.getClient().getMe().getCoinSetID()).getTails();
                    ScreenHelper.drawImageQuad(tex, matrix, (float)this.f_96541_.m_91268_().m_85441_() / this.scaledFactor - 50.0f, 33.0f, 40.0f, 40.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
                    text = client.isMyTurn() ? I18n.m_118938_((String)"battle.first", (Object[])new Object[0]) : I18n.m_118938_((String)"battle.second", (Object[])new Object[0]);
                    ScreenHelper.drawString(matrix, (String)text, this.scaledWidth - (float)ScreenHelper.getStringWidth((String)text) - 50.0f, 40.0f, 0xFFFFFF, true);
                    int topY = -60;
                    int lineHeight = 12;
                    int offset = 80;
                    RenderDuel.draw2DRectangle(matrix, this.scaledWidth / 2.0f + (float)offset - 5.0f, this.scaledWidth, this.scaledHeight / 2.0f + (float)topY + (float)(lineHeight * 4) + 8.0f + 5.0f, this.scaledHeight / 2.0f + (float)topY - 5.0f, 0.0f, 0.0f, 0.0f, 0.5f);
                    ScreenHelper.drawString(matrix, I18n.m_118938_((String)"battle.guide.settingup.title", (Object[])new Object[0]), this.scaledWidth / 2.0f + (float)offset, this.scaledHeight / 2.0f + (float)topY, 0xFFFFFF, true);
                    ScreenHelper.drawString(matrix, I18n.m_118938_((String)"battle.guide.settingup.1", (Object[])new Object[0]), this.scaledWidth / 2.0f + (float)offset, this.scaledHeight / 2.0f + (float)topY + (float)lineHeight, 0xFFFFFF, true);
                    ScreenHelper.drawString(matrix, I18n.m_118938_((String)"battle.guide.settingup.2", (Object[])new Object[0]), this.scaledWidth / 2.0f + (float)offset, this.scaledHeight / 2.0f + (float)topY + (float)(lineHeight * 2), 0xFFFFFF, true);
                    ScreenHelper.drawString(matrix, I18n.m_118938_((String)"battle.guide.settingup.3", (Object[])new Object[0]), this.scaledWidth / 2.0f + (float)offset, this.scaledHeight / 2.0f + (float)topY + (float)(lineHeight * 3), 0xFFFFFF, true);
                    ScreenHelper.drawString(matrix, I18n.m_118938_((String)"battle.guide.settingup.4", (Object[])new Object[0]), this.scaledWidth / 2.0f + (float)offset, this.scaledHeight / 2.0f + (float)topY + (float)(lineHeight * 4), 0xFFFFFF, true);
                }
                if (this.isSpectating) {
                    int topY = 10;
                    String title = I18n.m_118938_((String)"battleSpectator.title", (Object[])new Object[0]);
                    int titleWidth = ScreenHelper.getStringWidth(title);
                    Object player1 = this.controller.getClient().getMe().getPlayerName();
                    if (this.controller.getClient().isMyTurn()) {
                        player1 = ChatFormatting.AQUA + "> " + (String)player1;
                    }
                    int player1Width = ScreenHelper.getStringWidth((String)player1);
                    Object player2 = this.controller.getClient().getOpponent().getPlayerName();
                    if (!this.controller.getClient().isMyTurn()) {
                        player2 = ChatFormatting.AQUA + "> " + (String)player2;
                    }
                    int player2Width = ScreenHelper.getStringWidth((String)player2);
                    int maxWidth = Math.max(titleWidth, Math.max(player1Width, player2Width));
                    RenderDuel.draw2DRectangle(matrix, this.scaledWidth, this.scaledWidth - 20.0f - (float)maxWidth, topY - 5, topY + 32 + 5, 0.0f, 0.0f, 0.0f, 0.5f);
                    ScreenHelper.drawString(matrix, title, this.scaledWidth - 10.0f - (float)titleWidth, topY, 0xFFFFFF);
                    ScreenHelper.drawString(matrix, (String)player1, this.scaledWidth - 10.0f - (float)player1Width, topY + 12, 0xFFFFFF);
                    ScreenHelper.drawString(matrix, (String)player2, this.scaledWidth - 10.0f - (float)player2Width, topY + 24, 0xFFFFFF);
                }
                matrix.m_280168_().m_85836_();
                this.inspectingCard.render(matrix, me, opp, 3.0f);
                matrix.m_280168_().m_85849_();
                if (this.guiPrizeSelector.getPrizes() == null && !this.guiPeek.visible && !this.guiOptional.visible) {
                    this.drawHand(matrix, mouseX, mouseY, myHand, oppHand);
                    this.drawAbilityButtons(matrix, mouseX, mouseY, me);
                    this.drawAttackButtons(matrix, mouseX, mouseY, me);
                    this.drawRetreatButton(matrix, mouseX, mouseY, me, opp, client.isMyTurn());
                    if (this.draggingCard != null) {
                        this.drawDraggingCard(matrix, mouseX, mouseY, this.draggingCard.getCard(), me, opp);
                        if (this.isLeftMousePressed()) {
                            this.checkAndDrawActionHint(matrix, this.draggingCard.getCard().getData(), this.controller.getClient().isMyTurn(), mouseX, mouseY, me, this.controller.getClient().getPlayerIndex());
                        }
                    }
                    this.inspectingCard.drawTooltip(matrix, mouseX, mouseY, 4.0f);
                }
                this.guiDuelLog.draw(matrix, client.getLog(), mouseX, mouseY, 2.0f);
                for (Screen gui : this.subGui) {
                    gui.m_88315_(matrix, mouseX, mouseY, partialTicks);
                }
                if (me.getCounterEndTime() != null) {
                    int secondsLeft = (int)((me.getCounterEndTime().getTime() - Calendar.getInstance().getTime().getTime()) / 1000L);
                    if (secondsLeft < 0) {
                        secondsLeft = 0;
                    }
                    text = secondsLeft + "s";
                    int color = 0xFFFFFF;
                    if (secondsLeft < 10) {
                        color = 0xFF0000;
                    }
                    ScreenHelper.drawString(matrix, (String)text, 25.0f - (float)ScreenHelper.getStringWidth((String)text) / 2.0f, this.scaledHeight / 2.0f - 97.0f, color);
                } else if (opp.getCounterEndTime() != null) {
                    int secondsLeft = (int)((opp.getCounterEndTime().getTime() - Calendar.getInstance().getTime().getTime()) / 1000L);
                    if (secondsLeft < 0) {
                        secondsLeft = 0;
                    }
                    text = secondsLeft + "s";
                    ScreenHelper.drawString(matrix, (String)text, 25.0f - (float)ScreenHelper.getStringWidth((String)text) / 2.0f, this.scaledHeight / 2.0f - 97.0f, 0xBBBBBB);
                }
            }
        }
    }

    protected void actionPerformed(Button button) {
        if (this.isSpectating) {
            return;
        }
        if (button instanceof IndexedButton) {
            switch (((IndexedButton)button).getID()) {
                case 10: {
                    NetworkHelper.sendToServer(new GenericActionRequestPacket(this.controller.m_58899_(), PhaseAction.EndTurn, this.playerIndex, 0, 0));
                    break;
                }
                case 11: {
                    NetworkHelper.sendToServer(new GenericActionRequestPacket(this.controller.m_58899_(), PhaseAction.Discard, this.playerIndex, this.inspectingCard.getLocation().ordinal(), this.inspectingCard.getLocationSubIndex()));
                }
            }
        }
    }

    private void updateLocalDimensions() {
        this.guiScaling = (double)((float)this.f_96541_.m_91268_().m_85444_() / 240.0f) / this.f_96541_.m_91268_().m_85449_();
        this.scaledWidth = this.f_96541_.m_91268_().m_85445_();
        this.scaledHeight = this.f_96541_.m_91268_().m_85446_();
        this.scaledFactor = (float)this.f_96541_.m_91268_().m_85449_();
    }

    private void updateTargetPositions() {
        int i;
        double centerY = this.scaledHeight / 2.0f;
        float centerX = this.scaledWidth / 2.0f;
        double boardCenterY = (float)((double)(this.scaledHeight / 2.0f) - 20.0 * this.guiScaling);
        double cardWidth = 20.0;
        double scaledCardWidth = cardWidth * this.guiScaling;
        double cardHeight = 26.0;
        double scaledCardHeight = cardHeight * this.guiScaling;
        double activeTargetXOffset = (double)centerX - 9.0 * this.guiScaling;
        double trainerXOffset = (this.playerIndex == 1 ? -1.0 : 0.55) * (48.0 * this.guiScaling);
        double myYOffset = 11.0 * this.guiScaling;
        double oppYOffset = 40.0 * this.guiScaling;
        this.myTargets.activeTarget.setWidth(scaledCardWidth);
        this.myTargets.activeTarget.setHeight(scaledCardHeight);
        this.myTargets.activeTarget.setX(activeTargetXOffset);
        this.myTargets.activeTarget.setY(boardCenterY + myYOffset);
        this.oppTargets.activeTarget.setWidth(scaledCardWidth);
        this.oppTargets.activeTarget.setHeight(scaledCardHeight);
        this.oppTargets.activeTarget.setX(activeTargetXOffset);
        this.oppTargets.activeTarget.setY(boardCenterY - oppYOffset);
        this.myTargets.trainerTarget.setWidth(scaledCardWidth);
        this.myTargets.trainerTarget.setHeight(scaledCardHeight);
        this.myTargets.trainerTarget.setX((double)centerX + trainerXOffset);
        this.myTargets.trainerTarget.setY(boardCenterY + myYOffset);
        this.oppTargets.trainerTarget.setWidth(scaledCardWidth);
        this.oppTargets.trainerTarget.setHeight(scaledCardHeight);
        this.oppTargets.trainerTarget.setX((double)centerX + trainerXOffset);
        this.oppTargets.trainerTarget.setY(boardCenterY - oppYOffset);
        for (i = 0; i < 5; ++i) {
            double cardBuffer = 5.5;
            double halfBoardWidth = 60.5;
            float myCardX = (float)((halfBoardWidth - (double)i * (cardWidth + cardBuffer)) * this.guiScaling);
            float oppCardX = (float)((halfBoardWidth - (double)i * (cardWidth + cardBuffer)) * this.guiScaling);
            double myCardY = boardCenterY + 62.0 * this.guiScaling;
            double oppCardY = boardCenterY - 90.0 * this.guiScaling;
            this.myTargets.benchTargets[i].setWidth(scaledCardWidth);
            this.myTargets.benchTargets[i].setHeight(scaledCardHeight);
            this.myTargets.benchTargets[i].setX(centerX - myCardX);
            this.myTargets.benchTargets[i].setY(myCardY);
            this.oppTargets.benchTargets[i].setWidth(scaledCardWidth);
            this.oppTargets.benchTargets[i].setHeight(scaledCardHeight);
            this.oppTargets.benchTargets[i].setX(centerX - oppCardX);
            this.oppTargets.benchTargets[i].setY(oppCardY);
        }
        this.buttonAbility.setWidth(111.0);
        this.buttonAbility.setHeight(12.0);
        this.buttonAbility.setX((double)centerX + 150.0 * this.guiScaling - 56.0);
        this.buttonAbility.setY((double)(this.scaledHeight / 2.0f) + -1.0 * this.guiScaling);
        for (i = 0; i < 3; ++i) {
            this.buttonAttacks[i].setWidth(111.0);
        }
        this.buttonEndTurn.f_93620_ = (int)(this.scaledWidth - 10.0f - (float)this.buttonEndTurn.m_5711_());
        this.buttonEndTurn.f_93621_ = 10;
        this.buttonDiscard.f_93620_ = (int)(this.scaledWidth - 10.0f - (float)this.buttonDiscard.m_5711_() - 10.0f - (float)this.buttonEndTurn.m_5711_());
        this.buttonDiscard.f_93621_ = 10;
        this.buttonRetreat.setWidth(43.0);
        this.buttonRetreat.setHeight(20.0);
        this.buttonRetreat.setX((double)centerX + 150.0 * this.guiScaling + 12.0);
        this.buttonRetreat.setY((double)(this.scaledHeight / 2.0f) + 0.0 * this.guiScaling + 56.0);
    }

    private void updateCameraPositions(Direction facing) {
        CameraEntity cam = new CameraEntity((Level)this.f_96541_.f_91073_);
        this.f_96541_.execute(() -> {
            ClientProxy.camera = cam;
            int rotation = 90;
            float scale = this.controller.getScale();
            double diffX = 0.0;
            double diffZ = 0.0;
            switch (facing) {
                case EAST: {
                    diffX = 5.25 * (double)scale + 1.0;
                    rotation = 0;
                    diffZ = (this.playerIndex == 1 ? 2.2 : -1.2) * (double)scale;
                    break;
                }
                case NORTH: {
                    diffZ = 5.25 * (double)scale * -1.0;
                    rotation = -90;
                    diffX = (this.playerIndex == 1 ? 2.2 : -1.2) * (double)scale;
                    break;
                }
                case SOUTH: {
                    diffZ = 5.25 * (double)scale + 1.0;
                    diffX = (this.playerIndex == 0 ? 2.2 : -1.2) * (double)scale;
                    break;
                }
                case WEST: {
                    diffX = 5.25 * (double)scale * -1.0;
                    rotation = -180;
                    diffZ = (this.playerIndex == 0 ? 2.2 : -1.2) * (double)scale;
                }
            }
            if (this.playerIndex == 1) {
                rotation += 180;
            }
            double posX = this.controller.m_58899_().m_123341_();
            double posZ = this.controller.m_58899_().m_123343_();
            double y = (double)this.controller.m_58899_().m_123342_() + 13.5 * (double)scale;
            ClientProxy.camera.m_19890_(posX + diffX, y, posZ + diffZ, rotation, 90.0f);
            ClientProxy.camera.m_5616_(rotation);
            this.f_96541_.f_91073_.m_104739_((Entity)ClientProxy.camera);
        });
        this.ticks = 1;
    }

    private boolean handleActiveCards(double mouseX, double mouseY, PlayerClientMyState me, PlayerClientOpponentState opp) {
        boolean handled = false;
        if (this.draggingCard == null) {
            if (me.getActiveCard() != null && this.myTargets.activeTarget.isInside(mouseX, mouseY)) {
                this.isCardInSelectMode = true;
                this.inspectingCard.set(me.getActiveCard(), true, BoardLocation.Active, 0, true);
                handled = true;
            }
            if (opp.getActiveCard() != null && !opp.getActiveCard().getData().isFaceDown() && this.oppTargets.activeTarget.isInside(mouseX, mouseY)) {
                this.isCardInSelectMode = true;
                this.inspectingCard.set(opp.getActiveCard(), false, BoardLocation.Active, 0, true);
                handled = true;
            }
        }
        return handled;
    }

    private boolean handleBenchCards(double mouseX, double mouseY, PlayerClientMyState me, PlayerClientOpponentState opp) {
        boolean handled = false;
        if (this.draggingCard == null) {
            for (int bench = 0; bench < 5; ++bench) {
                if (me.getBenchCards()[bench] != null && this.myTargets.benchTargets[bench].isInside(mouseX, mouseY)) {
                    this.isCardInSelectMode = true;
                    this.inspectingCard.set(me.getBenchCards()[bench], true, BoardLocation.Bench, bench, true);
                    handled = true;
                }
                if (opp.getBenchCards()[bench] == null || opp.getBenchCards()[bench].getData().isFaceDown() || !this.oppTargets.benchTargets[bench].isInside(mouseX, mouseY)) continue;
                this.isCardInSelectMode = true;
                this.inspectingCard.set(opp.getBenchCards()[bench], false, BoardLocation.Bench, bench, true);
                handled = true;
            }
        }
        return handled;
    }

    private boolean handleTrainerCards(double mouseX, double mouseY, PlayerClientMyState me, PlayerClientOpponentState opp) {
        boolean handled = false;
        if (this.draggingCard == null) {
            if (me.getTrainerCard() != null && this.myTargets.trainerTarget.isInside(mouseX, mouseY)) {
                this.isCardInSelectMode = true;
                this.inspectingCard.set(me.getTrainerCard(), true, BoardLocation.Trainer, 0, true);
                handled = true;
            }
            if (opp.getTrainerCard() != null && this.oppTargets.trainerTarget.isInside(mouseX, mouseY)) {
                this.isCardInSelectMode = true;
                this.inspectingCard.set(opp.getTrainerCard(), false, BoardLocation.Trainer, 0, true);
                handled = true;
            }
        }
        return handled;
    }

    private void drawAbilityButtons(GuiGraphics matrix, int mouseX, int mouseY, PlayerClientMyState me) {
        PokemonCardState card;
        if (this.inspectingCard.isMine() && (this.inspectingCard.getLocation() == BoardLocation.Active || this.inspectingCard.getLocation() == BoardLocation.Bench) && me.getActiveCard() != null && this.controller.getClient().isMyTurn() && this.isCardInSelectMode && this.inspectingCard.getCard() instanceof PokemonCardState && (card = (PokemonCardState)this.inspectingCard.getCard()).getAbility() != null && card.getAbility().getEffect() != null && !card.getAbility().getEffect().isPassive()) {
            int stroke;
            boolean isEnabled = card.getAbility().getEffect().isEnabled(card, this.controller.getClient());
            int color = this.buttonAbility.isInside(mouseX, mouseY) ? 0x22FFFF00 : 0x11FFFFFF;
            int n = stroke = this.buttonAbility.isInside(mouseX, mouseY) ? -256 : -570425345;
            if (isEnabled && this.buttonAbility.isInside(mouseX, mouseY)) {
                this.drawRectWithBorder(matrix, (int)(this.buttonAbility.getX() - 1.0), (int)(this.buttonAbility.getY() - 1.0), (int)(this.buttonAbility.getX() + this.buttonAbility.getWidth() + 1.0), (int)(this.buttonAbility.getY() + this.buttonAbility.getHeight() + 1.0), color, stroke);
            } else if (isEnabled) {
                this.drawRectWithBorder(matrix, (int)this.buttonAbility.getX(), (int)this.buttonAbility.getY(), (int)(this.buttonAbility.getX() + this.buttonAbility.getWidth()), (int)(this.buttonAbility.getY() + this.buttonAbility.getHeight()), color, stroke);
            }
            if (this.buttonAbility.isInside(mouseX, mouseY)) {
                String error = null;
                if (!isEnabled) {
                    error = "Can't activate power";
                }
                if (error != null) {
                    ScreenHelper.drawString(matrix, error, mouseX + 4, mouseY + 4, 0xFF0000);
                }
            }
        }
    }

    private boolean handleAbilityButton(int playerIndex, boolean isMyTurn, double mouseX, double mouseY, PlayerClientMyState me) {
        PokemonCardState card;
        boolean handled = false;
        if (this.draggingCard == null && this.inspectingCard.isMine() && (this.inspectingCard.getLocation() == BoardLocation.Active || this.inspectingCard.getLocation() == BoardLocation.Bench) && me.getActiveCard() != null && isMyTurn && this.isCardInSelectMode && this.inspectingCard.getCard() instanceof PokemonCardState && (card = (PokemonCardState)this.inspectingCard.getCard()).getAbility() != null && card.getAbility().getEffect() != null && !card.getAbility().getEffect().isPassive() && card.getAbility().getEffect().isEnabled(card, this.controller.getClient()) && this.buttonAbility.isInside(mouseX, mouseY)) {
            NetworkHelper.sendToServer(new GenericActionRequestPacket(this.controller.m_58899_(), PhaseAction.UseAbility, playerIndex, this.inspectingCard.getLocation().ordinal(), this.inspectingCard.getLocationSubIndex()));
            handled = true;
        }
        return handled;
    }

    private void drawAttackButtons(GuiGraphics matrix, int mouseX, int mouseY, PlayerClientMyState me) {
        if (me != null && this.controller != null && this.controller.getClient() != null && this.controller.getClient().isMyTurn() && this.inspectingCard != null && (this.inspectingCard.isPickingAttack() || this.inspectingCard.isMine() && this.inspectingCard.getLocation() == BoardLocation.Active && me.getActiveCard() != null && this.isCardInSelectMode)) {
            PokemonCardState pokemon = (PokemonCardState)this.inspectingCard.getCard();
            boolean isParalyzed = false;
            boolean isAsleep = false;
            for (Pair<CardCondition, Integer> condition : pokemon.getStatus().getConditions()) {
                switch ((CardCondition)((Object)condition.getLeft())) {
                    case ASLEEP: {
                        isAsleep = true;
                        break;
                    }
                    case PARALYZED: {
                        isParalyzed = true;
                    }
                }
            }
            for (int i = 0; i < pokemon.getAttacksStatus().length; ++i) {
                int stroke;
                PokemonAttackStatus attack = pokemon.getAttacksStatus()[i];
                CardAttack data = attack.getData();
                boolean enoughEnergy = LogicHelper.isEnoughEnergy(data, pokemon.getAttachments(), pokemon);
                boolean isEnabled = this.inspectingCard.isPickingAttack() || !attack.isDisabled() && enoughEnergy && !isAsleep && !isParalyzed && me.getAvailableActions().isCanAttack();
                TargetScreen button = this.buttonAttacks[i];
                int color = button.isInside(mouseX, mouseY) ? 0x22FFFF00 : 0x11FFFFFF;
                int n = stroke = button.isInside(mouseX, mouseY) ? -256 : -570425345;
                if (isEnabled && button.isInside(mouseX, mouseY)) {
                    this.drawRectWithBorder(matrix, (int)button.getX() - 1, (int)button.getY() - 1, (int)(button.getX() + button.getWidth() + 1.0), (int)(button.getY() + button.getHeight() + 1.0), color, stroke);
                } else if (isEnabled) {
                    this.drawRectWithBorder(matrix, (int)button.getX(), (int)button.getY(), (int)(button.getX() + button.getWidth()), (int)(button.getY() + button.getHeight()), color, stroke);
                }
                if (!button.isInside(mouseX, mouseY)) continue;
                if (this.inspectingCard.isPickingAttack()) {
                    ScreenHelper.drawString(matrix, "Choose this attack!", mouseX + 4, mouseY + 4, 0xFFFFFF);
                    continue;
                }
                Object error = null;
                if (attack.isDisabled()) {
                    error = "This attack is disabled!";
                } else if (!me.getAvailableActions().isCanAttack()) {
                    error = "You can't attack this turn.";
                } else if (isAsleep) {
                    error = Component.m_237115_((String)pokemon.getData().getName().toLowerCase()).getString() + " is asleep!";
                } else if (isParalyzed) {
                    error = Component.m_237115_((String)pokemon.getData().getName().toLowerCase()).getString() + " is paralyzed!";
                } else if (!enoughEnergy) {
                    error = "Not enough energy!";
                }
                if (error == null) continue;
                ScreenHelper.drawString(matrix, (String)error, mouseX - ScreenHelper.getStringWidth((String)error), (float)(mouseY + 8), 0xFF0000, true);
            }
        }
    }

    private boolean handleAttackButtons(int playerIndex, boolean isMyTurn, double mouseX, double mouseY, PlayerClientMyState me) {
        boolean handled = false;
        if (isMyTurn && this.draggingCard == null && (this.inspectingCard.isPickingAttack() || this.inspectingCard.isMine() && this.inspectingCard.getLocation() == BoardLocation.Active && me.getActiveCard() != null && this.isCardInSelectMode && me.getAvailableActions().isCanAttack())) {
            PokemonCardState pokemon = (PokemonCardState)this.inspectingCard.getCard();
            boolean isParalyzed = false;
            boolean isAsleep = false;
            for (Pair<CardCondition, Integer> condition : pokemon.getStatus().getConditions()) {
                switch ((CardCondition)((Object)condition.getLeft())) {
                    case ASLEEP: {
                        isAsleep = true;
                        break;
                    }
                    case PARALYZED: {
                        isParalyzed = true;
                    }
                }
            }
            if (this.inspectingCard.isPickingAttack() || !isAsleep && !isParalyzed) {
                for (int i = 0; i < pokemon.getAttacksStatus().length; ++i) {
                    boolean enoughEnergy;
                    PokemonAttackStatus attackStatus = pokemon.getAttacksStatus()[i];
                    CardAttack cardAttack = attackStatus.getData();
                    if (cardAttack == null || attackStatus.isDisabled() || !this.buttonAttacks[i].isInside(mouseX, mouseY)) continue;
                    boolean bl = enoughEnergy = this.inspectingCard.isPickingAttack() || LogicHelper.isEnoughEnergy(cardAttack, pokemon.getAttachments(), pokemon);
                    if (!enoughEnergy) continue;
                    NetworkHelper.sendToServer(new GenericActionRequestPacket(this.controller.m_58899_(), PhaseAction.UseAttack, playerIndex, i, 0));
                    handled = true;
                }
            }
        }
        return handled;
    }

    private boolean drawRetreatButton(GuiGraphics matrix, int mouseX, int mouseY, PlayerClientMyState me, PlayerClientOpponentState opp, boolean isMyTurn) {
        boolean clickedSomething = false;
        if (this.inspectingCard.isMine() && this.inspectingCard.getLocation() == BoardLocation.Active && me.getActiveCard() != null && isMyTurn && this.isCardInSelectMode) {
            int stroke;
            PokemonCardState pokemon = (PokemonCardState)this.inspectingCard.getCard();
            boolean isParalyzed = false;
            boolean isAsleep = false;
            for (Pair<CardCondition, Integer> condition : pokemon.getStatus().getConditions()) {
                switch ((CardCondition)((Object)condition.getLeft())) {
                    case ASLEEP: {
                        isAsleep = true;
                        break;
                    }
                    case PARALYZED: {
                        isParalyzed = true;
                    }
                }
            }
            int retreatCost = Math.max(0, me.getActiveCard().getRetreatCost() + LogicHelper.getCostModifier(me, opp));
            boolean enoughEnergy = LogicHelper.isEnoughEnergy(retreatCost, pokemon.getAttachments(), pokemon);
            boolean hasBench = LogicHelper.hasBench(me);
            boolean canRetreat = me.getActiveCard().canRetreat();
            boolean enabled = hasBench && enoughEnergy && !isAsleep && !isParalyzed && me.getAvailableActions().isCanRetreatActive() && canRetreat;
            int color = this.buttonRetreat.isInside(mouseX, mouseY) ? 0x22FFFF00 : 0x11FFFFFF;
            int n = stroke = this.buttonRetreat.isInside(mouseX, mouseY) ? -256 : -570425345;
            if (enabled && this.buttonRetreat.isInside(mouseX, mouseY)) {
                this.drawRectWithBorder(matrix, (int)(this.buttonRetreat.getX() - 1.0), (int)(this.buttonRetreat.getY() - 1.0), (int)(this.buttonRetreat.getX() + this.buttonRetreat.getWidth() + 1.0), (int)(this.buttonRetreat.getY() + this.buttonRetreat.getHeight() + 1.0), color, stroke);
            } else if (enabled) {
                this.drawRectWithBorder(matrix, (int)this.buttonRetreat.getX(), (int)this.buttonRetreat.getY(), (int)(this.buttonRetreat.getX() + this.buttonRetreat.getWidth()), (int)(this.buttonRetreat.getY() + this.buttonRetreat.getHeight()), color, stroke);
            }
            if (this.buttonRetreat.isInside(mouseX, mouseY)) {
                Object error = null;
                if (!me.getAvailableActions().isCanRetreatActive()) {
                    error = "You can't retreat this turn";
                } else if (isAsleep) {
                    error = Component.m_237115_((String)pokemon.getData().getName().toLowerCase()) + " is asleep";
                } else if (isParalyzed) {
                    error = Component.m_237115_((String)pokemon.getData().getName().toLowerCase()) + " is paralyzed";
                } else if (!hasBench) {
                    error = "You have no card in bench";
                } else if (!enoughEnergy) {
                    error = "You don't have enough energy";
                } else if (!canRetreat) {
                    error = "This can't retreat";
                }
                if (error != null) {
                    ScreenHelper.drawString(matrix, (String)error, mouseX - ScreenHelper.getStringWidth((String)error), mouseY, 0xFF0000);
                }
            }
        }
        return clickedSomething;
    }

    private boolean handleRetreatButton(boolean isMyTurn, double mouseX, double mouseY, PlayerClientMyState me, PlayerClientOpponentState opp) {
        boolean clickedSomething = false;
        if (this.inspectingCard.isMine() && this.inspectingCard.getLocation() == BoardLocation.Active && this.draggingCard == null && this.buttonRetreat.isInside(mouseX, mouseY) && isMyTurn && this.isCardInSelectMode) {
            boolean enabled;
            PokemonCardState pokemon = (PokemonCardState)this.inspectingCard.getCard();
            boolean isParalyzed = false;
            boolean isAsleep = false;
            for (Pair<CardCondition, Integer> condition : pokemon.getStatus().getConditions()) {
                switch ((CardCondition)((Object)condition.getLeft())) {
                    case ASLEEP: {
                        isAsleep = true;
                        break;
                    }
                    case PARALYZED: {
                        isParalyzed = true;
                    }
                }
            }
            int cost = me.getActiveCard().getRetreatCost();
            cost = Math.max(0, cost + LogicHelper.getCostModifier(me, opp));
            boolean enoughEnergy = LogicHelper.isEnoughEnergy(cost, pokemon.getAttachments(), pokemon);
            boolean hasBench = LogicHelper.hasBench(me);
            boolean canRetreat = me.getActiveCard().canRetreat();
            boolean bl = enabled = hasBench && enoughEnergy && !isAsleep && !isParalyzed && me.getAvailableActions().isCanRetreatActive() && canRetreat;
            if (enabled) {
                CardSelectorState state = new CardSelectorState(cost, cost, true, CardSelectorDisplay.Discard, true);
                state.setCardList(LogicHelper.getEnergiesFromList(me.getActiveCard().getAttachments()));
                this.cardSelector.set(CardSelectorPurpose.StartRetreating, state);
                if (cost == 0) {
                    this.cardSelector.acceptSelection();
                }
                clickedSomething = true;
            }
        }
        return clickedSomething;
    }

    private void checkAndDrawActionHint(GuiGraphics matrix, ImmutableCard card, boolean isMyTurn, int mouseX, int mouseY, PlayerClientMyState me, int playerIndex) {
        CardType ct = card.getCardType();
        int c = 10;
        int color = 65280;
        int errorColor = 0xFF0000;
        if (this.controller.getClient().getGamePhase() == GamePhase.PreMatch || isMyTurn) {
            for (int bench = 0; bench < 5; ++bench) {
                if (!this.myTargets.benchTargets[bench].isInside(mouseX, mouseY)) continue;
                PokemonCardState benchCard = me.getBenchCards()[bench];
                this.showPokemonCardActionHint(matrix, mouseX, mouseY, ct, c, color, errorColor, me, benchCard, false);
            }
            if (this.myTargets.activeTarget.isInside(mouseX, mouseY)) {
                PokemonCardState activeCard = me.getActiveCard();
                this.showPokemonCardActionHint(matrix, mouseX, mouseY, ct, c, color, errorColor, me, activeCard, true);
            } else if ((double)mouseY < (double)this.scaledHeight / 1.5 && ct == CardType.TRAINER && card.getEffect() != null) {
                if (me.getAvailableActions().isCanPlayTrainer() && card.getEffect().canPlay(this.controller.getClient())) {
                    ScreenHelper.drawString(matrix, "Play Trainer card", mouseX + c, (float)(mouseY + c), color, true);
                } else {
                    ScreenHelper.drawString(matrix, "Cannot play Trainer card now", mouseX + c, (float)(mouseY + c), errorColor, true);
                }
            }
        } else {
            ScreenHelper.drawString(matrix, "Not your turn yet!", mouseX, (float)mouseY, errorColor, true);
        }
    }

    private void releaseDraggingCard(int mouseX, int mouseY, List<ImmutableCard> myHand, int playerIndex) {
        ImmutableCard card = this.draggingCard.getCard().getData();
        for (int benchIndex = 0; benchIndex < 5; ++benchIndex) {
            if (!this.myTargets.benchTargets[benchIndex].isInside(mouseX, mouseY)) continue;
            NetworkHelper.sendToServer(new UpdateServerCardRecordPacket(this.controller.m_58899_(), BoardLocation.Bench, benchIndex, card, this.draggingCard.locationSubIndex));
        }
        if (this.myTargets.activeTarget.isInside(mouseX, mouseY)) {
            NetworkHelper.sendToServer(new UpdateServerCardRecordPacket(this.controller.m_58899_(), BoardLocation.Active, 0, card, this.draggingCard.locationSubIndex));
        } else if ((double)mouseY < (double)this.scaledHeight / 1.5) {
            NetworkHelper.sendToServer(new UpdateServerCardRecordPacket(this.controller.m_58899_(), BoardLocation.Trainer, 0, card, this.draggingCard.locationSubIndex));
        }
        this.draggingCard = null;
    }

    private void drawDraggingCard(GuiGraphics graphics, int mouseX, int mouseY, CommonCardState card, PlayerClientMyState me, PlayerClientOpponentState opp) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        float scaleFactor = 0.35f;
        matrix.m_252880_((float)mouseX, (float)mouseY, 0.0f);
        matrix.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        CardRenderingHelper.drawCard(graphics, card, 0, 0, 0.0f, 1.0f, 0.0, me, opp);
        matrix.m_85841_(-scaleFactor, -scaleFactor, -scaleFactor);
        matrix.m_85849_();
    }

    private boolean handleCardInHand(double mouseX, double mouseY, int mouseButton, List<ImmutableCard> myHand, List<ImmutableCard> oppHand, int handIndex, boolean isMe) {
        boolean handled = false;
        if (isMe) {
            ImmutableCard card = myHand.get(handIndex);
            if ((this.draggingCard == null || this.isCardInSelectMode) && this.myTargets.handTargets.size() > handIndex && this.myTargets.handTargets.get(handIndex).isInside(mouseX, mouseY) && (mouseButton == 0 || mouseButton == 1)) {
                CommonCardState cardState;
                CommonCardState commonCardState = cardState = card.isPokemonCard() ? new PokemonCardState(card, this.controller.getClient().getTurnCount()) : new CommonCardState(card);
                if (mouseButton == 1) {
                    this.inspectingCard.set(cardState, true, BoardLocation.Hand, handIndex, true);
                    handled = true;
                }
                if (mouseButton == 0) {
                    this.draggingCard = new CardWithLocation(cardState, true, BoardLocation.Hand, handIndex);
                }
                this.isCardInSelectMode = false;
            }
        } else {
            ImmutableCard card = oppHand.get(handIndex);
            if ((this.draggingCard == null || this.isCardInSelectMode) && this.oppTargets.handTargets.size() > handIndex && this.oppTargets.handTargets.get(handIndex).isInside(mouseX, mouseY) && card != null && !card.isFaceDown()) {
                CommonCardState cardState = card.isPokemonCard() ? new PokemonCardState(card, this.controller.getClient().getTurnCount()) : new CommonCardState(card);
                this.inspectingCard.set(cardState, true, BoardLocation.Hand, handIndex, true);
                handled = true;
                this.isCardInSelectMode = false;
            }
        }
        return handled;
    }

    private void drawHand(GuiGraphics graphics, int mouseX, int mouseY, List<ImmutableCard> myHand, List<ImmutableCard> oppHand) {
        TargetScreen handTarget;
        ImmutableCard card;
        int i;
        PoseStack matrix = graphics.m_280168_();
        for (i = 0; i < myHand.size(); ++i) {
            if (i >= myHand.size()) {
                return;
            }
            if (i >= this.myTargets.handTargets.size()) {
                return;
            }
            card = myHand.get(i);
            handTarget = this.myTargets.handTargets.get(i);
            int offsetY = 0;
            float opacity = 1.0f;
            if ((this.draggingCard == null || this.isCardInSelectMode) && handTarget.isInside(mouseX, mouseY)) {
                offsetY = -15;
            }
            if (this.draggingCard != null && this.draggingCard.getLocation() == BoardLocation.Hand && this.draggingCard.getLocationSubIndex() == i) {
                opacity = 0.3f;
            }
            matrix.m_85836_();
            float scaleFactor = (float)(0.25 * this.guiScaling);
            matrix.m_85841_(scaleFactor, scaleFactor, scaleFactor);
            if (card == null || card.isFaceDown()) {
                CardRenderingHelper.drawCardBack(graphics, (int)(handTarget.getX() * 2.0 / (double)scaleFactor) + 100, (int)(handTarget.getY() * 2.0 / (double)scaleFactor) + offsetY + 150, 0.0f, this.controller.getClient().getMe());
            } else {
                CardRenderingHelper.drawCard(graphics, new CommonCardState(card), (int)(handTarget.getX() * 2.0 / (double)scaleFactor) + 100, (int)(handTarget.getY() * 2.0 / (double)scaleFactor) + offsetY + 150, 0.0f, opacity, 0.0, null, null);
            }
            matrix.m_85841_(-scaleFactor, -scaleFactor, -scaleFactor);
            matrix.m_85849_();
        }
        for (i = 0; i < oppHand.size(); ++i) {
            if (i >= oppHand.size()) {
                return;
            }
            if (i >= this.oppTargets.handTargets.size()) break;
            card = oppHand.get(i);
            handTarget = this.oppTargets.handTargets.get(i);
            matrix.m_85836_();
            float scaleFactor = (float)(0.25 * this.guiScaling);
            matrix.m_85841_(scaleFactor, scaleFactor, scaleFactor);
            int offsetY = 0;
            float opacity = 1.0f;
            if ((this.draggingCard == null || this.isCardInSelectMode) && handTarget.isInside(mouseX, mouseY)) {
                opacity = 0.5f;
                offsetY = 15;
            }
            if (card == null || card.isFaceDown()) {
                CardRenderingHelper.drawCardBack(graphics, (int)(handTarget.getX() * 2.0 / (double)scaleFactor) + 100, (int)(handTarget.getY() * 2.0 / (double)scaleFactor) + offsetY + 150, 0.0f, this.controller.getClient().getOpponent());
            } else {
                CardRenderingHelper.drawCard(graphics, new CommonCardState(card), (int)(handTarget.getX() * 2.0 / (double)scaleFactor) + 100, (int)(handTarget.getY() * 2.0 / (double)scaleFactor) + offsetY + 150, 0.0f, opacity, 180.0, null, null);
            }
            matrix.m_85841_(-scaleFactor, -scaleFactor, -scaleFactor);
            matrix.m_85849_();
        }
    }

    private void showPokemonCardActionHint(GuiGraphics matrix, int mouseX, int mouseY, CardType ct, int c, int color, int errorColor, PlayerClientMyState me, PokemonCardState card, boolean isActive) {
        if (ct == CardType.BASIC && card == null) {
            if (isActive) {
                ScreenHelper.drawString(matrix, "Play Active Pokemon", mouseX + c, (float)(mouseY + c), color, true);
            } else if (me.getActiveCard() != null) {
                ScreenHelper.drawString(matrix, "Play Benched Pokemon", mouseX + c, (float)(mouseY + c), color, true);
            } else {
                ScreenHelper.drawString(matrix, "Must play Active Pokemon first", mouseX + c, (float)(mouseY + c), errorColor, true);
            }
        } else if (ct == CardType.ENERGY && card != null) {
            if (me.getAvailableActions().isCanPlayEnergy()) {
                ScreenHelper.drawString(matrix, "Attach Energy", mouseX + c, (float)(mouseY + c), color, true);
            } else {
                ScreenHelper.drawString(matrix, "Cannot attach Energy this turn", mouseX + c, (float)(mouseY + c), errorColor, true);
            }
        } else if (ct == CardType.TOOL && card != null) {
            ScreenHelper.drawString(matrix, "Attach Tool", mouseX + c, (float)(mouseY + c), color, true);
        } else if ((ct == CardType.STAGE1 || ct == CardType.STAGE2) && card != null && this.draggingCard.getCard().getData().getPreviousEvolutionDexID() == card.getData().getPokemonID()) {
            if (LogicHelper.canEvolve(card.getTurn(), this.controller.getClient().getTurnCount())) {
                if (this.controller.getClient().isDisablingEvolution(card)) {
                    ScreenHelper.drawString(matrix, "Disabled by an power!", mouseX + c, (float)(mouseY + c), errorColor, true);
                } else {
                    ScreenHelper.drawString(matrix, "Evolve", mouseX + c, (float)(mouseY + c), color, true);
                }
            } else {
                ScreenHelper.drawString(matrix, "Cannot Evolve this turn!", mouseX + c, (float)(mouseY + c), errorColor, true);
            }
        } else if (ct == CardType.LVLX && this.draggingCard.getCard().getData().getPokemonID() == card.getData().getPokemonID()) {
            if (LogicHelper.canEvolve(card.getTurn(), this.controller.getClient().getTurnCount())) {
                ScreenHelper.drawString(matrix, "Level Up", mouseX + c, (float)(mouseY + c), color, true);
            } else {
                ScreenHelper.drawString(matrix, "Cannot Level Up this turn!", mouseX + c, (float)(mouseY + c), errorColor, true);
            }
        } else if (ct == CardType.MEGA && this.draggingCard.getCard().getData().getPokemonID() == card.getData().getPokemonID()) {
            if (LogicHelper.canEvolve(card.getTurn(), this.controller.getClient().getTurnCount())) {
                ScreenHelper.drawString(matrix, "Mega Evolve", mouseX + c, (float)(mouseY + c), color, true);
            } else {
                ScreenHelper.drawString(matrix, "Cannot Mega Evolve this turn!", mouseX + c, (float)(mouseY + c), errorColor, true);
            }
        } else {
            ScreenHelper.drawString(matrix, "Can't put that here", mouseX + c, (float)(mouseY + c), errorColor, true);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_6574_(Minecraft p_231152_1_, int p_231152_2_, int p_231152_3_) {
        super.m_6574_(p_231152_1_, p_231152_2_, p_231152_3_);
        this.m_7856_();
        this.updateLocalDimensions();
        this.updateTargetPositions();
    }
}

