/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.client.gui.duel;

import com.pixelmonmod.tcg.client.gui.base.TCGScreenBase;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.helper.CardRenderingHelper;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.PlayerClientMyState;
import com.pixelmonmod.tcg.duel.state.PlayerClientOpponentState;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;

public class InspectingCard
extends CardWithLocation {
    private Minecraft mc = Minecraft.m_91087_();
    private TCGScreenBase parent;
    private boolean isLocked;
    private float opacity;
    private boolean isUp = false;
    private String title = null;
    private int xOffset = 300;
    private boolean isPickingAttack;

    public InspectingCard(TCGScreenBase parent) {
        this.parent = parent;
    }

    public void set(CommonCardState card, boolean isMine, BoardLocation location, int locationSubIndex, boolean isLocked) {
        if (card.getData().isFaceDown()) {
            return;
        }
        this.set(card, isMine, location, locationSubIndex, isLocked, null, false);
    }

    public void set(CommonCardState card, boolean isMine, BoardLocation location, int locationSubIndex, boolean isLocked, String title) {
        this.set(card, isMine, location, locationSubIndex, isLocked, title, false);
    }

    public void set(CommonCardState card, boolean isMine, BoardLocation location, int locationSubIndex, boolean isLocked, String title, boolean isPickingAttack) {
        if (isMine != this.isMine || location != this.location || locationSubIndex != this.locationSubIndex) {
            this.opacity = 0.0f;
            this.set(card, isMine, location, locationSubIndex);
            this.isLocked = isLocked;
            this.isUp = true;
            this.title = title;
            this.isPickingAttack = isPickingAttack;
            this.xOffset = isPickingAttack ? 0 : 300;
        }
    }

    public void clear() {
        this.location = null;
        this.isLocked = false;
        this.isUp = false;
        this.isPickingAttack = false;
    }

    @Override
    public BoardLocation getLocation() {
        return this.location;
    }

    public void update(boolean isButtonPressed) {
        if (!this.isLocked && !isButtonPressed) {
            this.isUp = false;
            this.clear();
        }
        if (this.isUp && this.opacity < 1.0f) {
            this.opacity = (float)((double)this.opacity + (0.25 + 0.1 * (double)this.mc.m_91296_()));
            if (this.opacity >= 1.0f) {
                this.opacity = 1.0f;
            }
        } else if (!this.isLocked && !this.isUp && this.opacity > 0.0f) {
            this.opacity = (float)((double)this.opacity - (0.25 + 0.1 * (double)this.mc.m_91296_()));
            if (this.opacity <= 0.0f) {
                this.opacity = 0.0f;
                this.card = null;
            }
        }
    }

    public void render(GuiGraphics matrix, PlayerClientMyState me, PlayerClientOpponentState opp, float zLevel) {
        if (this.card != null) {
            float opacity;
            float guiScaling = (float)this.mc.m_91268_().m_85445_() / 240.0f;
            int pushToSide = (int)((float)this.xOffset * guiScaling);
            int cardX = this.mc.m_91268_().m_85445_() * 2 - 108;
            int cardY = this.mc.m_91268_().m_85446_();
            if (this.title != null) {
                int width = this.mc.f_91062_.m_92895_(this.title);
                matrix.m_280488_(Minecraft.m_91087_().f_91062_, this.title, (this.mc.m_91268_().m_85445_() + pushToSide) / 2 - width / 2, this.mc.m_91268_().m_85446_() / 2 - 95, 0xFFFFFF);
            }
            if ((opacity = Mth.m_14036_((float)(this.opacity < 0.1f ? 0.0f : this.opacity), (float)0.0f, (float)1.0f)) > 0.1f) {
                CardRenderingHelper.drawCard(matrix, this.card, cardX, cardY, zLevel, opacity, 0.0, me, opp);
            }
        }
    }

    void drawTooltip(GuiGraphics matrix, int mouseX, int mouseY, float zLevel) {
        if (this.card != null) {
            float guiScaling = (float)this.mc.m_91268_().m_85446_() / 240.0f;
            int pushToSide = (int)(300.0f * guiScaling);
            this.parent.drawEffectTooltip(matrix, this.card, mouseX, mouseY, pushToSide / 2, 0);
        }
    }

    public int getxOffset() {
        return this.xOffset;
    }

    boolean isPickingAttack() {
        return this.isPickingAttack;
    }
}

