/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.client.gui.duel;

import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.tcg.api.accessors.Coins;
import com.pixelmonmod.tcg.api.card.personalization.Coin;
import com.pixelmonmod.tcg.api.util.helper.NetworkHelper;
import com.pixelmonmod.tcg.client.gui.base.TCGScreenBase;
import com.pixelmonmod.tcg.client.gui.duel.TCGScreen;
import com.pixelmonmod.tcg.duel.attack.enums.CoinSide;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GamePhase;
import com.pixelmonmod.tcg.network.packets.battles.CoinFlipAckPacket;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;

public class FlippingCoinScreen
extends TCGScreenBase {
    private static final int OK_BUTTON_ID = 1000;
    private final TCGScreen parent;
    private final BattleOwnedTileEntityController controller;
    private final IndexedButton okButton = new IndexedButton(1000, 0, 0, 40, 20, "OK", this::actionPerformed);

    public FlippingCoinScreen(TCGScreen parent, BattleOwnedTileEntityController controller) {
        this.parent = parent;
        this.controller = controller;
    }

    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)this.okButton);
    }

    @Override
    public void m_86600_() {
        if (this.controller == null || this.controller.getClient() == null || this.controller.getClient().getCoinFlip() == null) {
            return;
        }
        super.m_86600_();
        this.okButton.f_93624_ = !this.parent.isSpectating && this.controller.getClient().getPlayerIndex() == this.controller.getClient().getCoinFlip().getPlayerIndex();
        this.okButton.f_93620_ = this.getScaledWidth() / 2 - 20;
        this.okButton.f_93621_ = this.getScaledHeight() / 2 + 10;
    }

    @Override
    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.controller == null || this.controller.getClient() == null || this.controller.getClient().getCoinFlip() == null) {
            return;
        }
        GameClientState client = this.controller.getClient();
        List<CoinSide> results = client.getCoinFlip().getResults();
        if (results != null && !results.isEmpty()) {
            super.m_88315_(matrix, mouseX, mouseY, partialTicks);
            int size = 40;
            int space = 5;
            int start = this.getScaledWidth() / 2 - (size * results.size() + space * (results.size() - 1)) / 2;
            Coin coin = Coins.PIKACHU.getValueUnsafe();
            if (client.getPlayerIndex() == client.getCoinFlip().getPlayerIndex()) {
                coin = Coins.get(client.getMe().getCoinSetID());
            } else {
                Coins.get(client.getOpponent().getCoinSetID());
            }
            for (int i = 0; i < results.size(); ++i) {
                ScreenHelper.drawImageQuad(results.get(i) == CoinSide.Head ? coin.getHeads() : coin.getTails(), matrix, start + i * (size + space), (float)this.getScaledHeight() / 2.0f - (float)size / 2.0f - 20.0f, size, size, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
            }
            if (this.controller.getClient().getGamePhase().after(GamePhase.PreMatch)) {
                String title = String.format("%s is flipping coins", this.controller.getClient().isMyTurn() ? this.controller.getClient().getMe().getPlayerName() : this.controller.getClient().getOpponent().getPlayerName());
                if (!this.parent.isSpectating && this.controller.getClient().isMyTurn()) {
                    title = "Flipping coins";
                }
                ScreenHelper.drawString(matrix, title, (float)this.getScaledWidth() / 2.0f - (float)ScreenHelper.getStringWidth(title) / 2.0f, (float)this.getScaledHeight() / 2.0f - 55.0f, 0xFFFFFF, true);
            }
        }
    }

    protected void actionPerformed(Button button) {
        NetworkHelper.sendToServer(new CoinFlipAckPacket(this.controller.m_58899_()));
    }
}

