/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.client.gui.duel;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.client.gui.duel.TCGScreen;
import com.pixelmonmod.tcg.duel.log.DuelLog;
import com.pixelmonmod.tcg.duel.log.DuelLogItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DuelLogScreen {
    protected static final ResourceLocation BAR = ResourceLocationHelper.of("tcg", "gui/game/log/bar.png");
    protected static final ResourceLocation SELF = ResourceLocationHelper.of("tcg", "gui/game/log/actions/self.png");
    protected static final ResourceLocation OPPONENT = ResourceLocationHelper.of("tcg", "gui/game/log/actions/opponent.png");
    private final Minecraft mc = Minecraft.m_91087_();
    private final TCGScreen parent;

    public DuelLogScreen(TCGScreen parent) {
        this.parent = parent;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiGraphics graphics, DuelLog log, int mX, int mY, float zL) {
        if (this.parent == null || this.parent.controller == null) {
            return;
        }
        float scaledHeight = this.parent.scaledHeight;
        ScreenHelper.drawImageQuad(BAR, graphics, 10.0f, this.parent.scaledHeight / 2.0f - 87.0f, 28.0f, 175.0f, 0.0f, 0.0f, 1.0f, 1.0f, zL);
        if (log != null) {
            List<DuelLogItem> items = log.getItems(8);
            for (int i = 0; i < items.size(); ++i) {
                String playerName;
                DuelLogItem item = items.get(i);
                ScreenHelper.drawImageQuad(item.getType().getResourceLocation(), graphics, 15.0f, scaledHeight / 2.0f - 87.0f + 5.0f + (float)(21 * i), 18.0f, 18.0f, 0.0f, 0.0f, 1.0f, 1.0f, zL);
                if (item.getPlayerSide() >= 0) {
                    if (item.getPlayerSide() == this.parent.controller.getClient().getPlayerIndex()) {
                        ScreenHelper.drawImageQuad(SELF, graphics, 15.0f, scaledHeight / 2.0f - 87.0f + 5.0f + (float)(21 * i), 18.0f, 18.0f, 0.0f, 0.0f, 1.0f, 1.0f, zL);
                    } else {
                        ScreenHelper.drawImageQuad(OPPONENT, graphics, 15.0f, scaledHeight / 2.0f - 87.0f + 5.0f + (float)(21 * i), 18.0f, 18.0f, 0.0f, 0.0f, 1.0f, 1.0f, zL);
                    }
                }
                if (mX <= 15 || mX >= 33 || !((float)mY > scaledHeight / 2.0f - 87.0f + 5.0f + (float)(21 * i)) || !((float)mY < scaledHeight / 2.0f - 87.0f + 5.0f + (float)(21 * i + 18))) continue;
                ArrayList lines = Lists.newArrayList();
                lines.add(Component.m_237113_((String)item.toString()));
                String string = playerName = item.getPlayerSide() == this.parent.controller.getClient().getPlayerIndex() ? this.parent.controller.getClient().getMe().getPlayerName() : this.parent.controller.getClient().getOpponent().getPlayerName();
                if (!this.parent.isSpectating && item.getPlayerSide() == this.parent.controller.getClient().getPlayerIndex()) {
                    playerName = I18n.m_118938_((String)"duel.log.you", (Object[])new Object[0]);
                }
                switch (item.getType()) {
                    case ATTACK: {
                        lines.remove(0);
                        lines.add(Component.m_237115_((String)I18n.m_118938_((String)"duel.log.attack", (Object[])new Object[]{item.getAttackParameters().getAttacker().getData().getTranslatedName().getString(), item.getAttackParameters().getAttacking().getData().getTranslatedName().getString(), item.getAttackParameters().getAttack().getTranslatedName().getString()})));
                        break;
                    }
                    case ABILITY: {
                        ImmutableCard card = item.getAbilityParameters().getCard().getData();
                        lines.remove(0);
                        lines.add(Component.m_237115_((String)I18n.m_118938_((String)"duel.log.ability", (Object[])new Object[]{card.getTranslatedName().getString(), card.getAbility().getTranslatedName().getString()})));
                        break;
                    }
                    case ATTACH: {
                        lines.remove(0);
                        lines.add(Component.m_237115_((String)I18n.m_118938_((String)"duel.log.attach", (Object[])new Object[]{playerName, item.getAttachCardParameters().getAttachment().getData().getTranslatedName().getString(), item.getAttachCardParameters().getPokemon().getData().getTranslatedName().getString()})));
                        break;
                    }
                    case DRAW: {
                        lines.remove(0);
                        lines.add(Component.m_237115_((String)I18n.m_118938_((String)"duel.log.draw", (Object[])new Object[]{playerName, item.getDrawParameters().getNumber()})));
                        break;
                    }
                    case DISCARD: {
                        lines.remove(0);
                        MutableComponent name = Component.m_237115_((String)I18n.m_118938_((String)"duel.log.acard", (Object[])new Object[0]));
                        if (item.getDiscardParameters().getCard() != null) {
                            name = item.getDiscardParameters().getCard().getData().getTranslatedName();
                        }
                        lines.add(Component.m_237115_((String)I18n.m_118938_((String)"duel.log.discard", (Object[])new Object[]{playerName, name.getString()})));
                        break;
                    }
                    case KNOCKOUT: {
                        lines.remove(0);
                        lines.add(Component.m_237115_((String)I18n.m_118938_((String)"duel.log.knockout", (Object[])new Object[]{item.getKnockoutParameters().getCard().getData().getTranslatedName().getString()})));
                        break;
                    }
                    case PLAY: {
                        lines.remove(0);
                        MutableComponent name = Component.m_237115_((String)I18n.m_118938_((String)"duel.log.acard", (Object[])new Object[0]));
                        if (item.getPlayParameters().getCard().getData() != null && !item.getPlayParameters().getCard().getData().isFaceDown()) {
                            name = item.getPlayParameters().getCard().getData().getTranslatedName();
                        }
                        lines.add(Component.m_237115_((String)I18n.m_118938_((String)"duel.log.play", (Object[])new Object[]{playerName, name.getString()})));
                        break;
                    }
                    case EVOLVE: {
                        lines.remove(0);
                        lines.add(Component.m_237115_((String)(item.getPlayerSide() == this.parent.controller.getClient().getPlayerIndex() ? I18n.m_118938_((String)"duel.log.evolve.you", (Object[])new Object[]{item.getEvolveParameters().getFrom().getData().getTranslatedName().getString(), item.getEvolveParameters().getTo().getData().getTranslatedName().getString()}) : I18n.m_118938_((String)"duel.log.evolve.opponent", (Object[])new Object[]{item.getEvolveParameters().getFrom().getData().getTranslatedName().getString(), item.getEvolveParameters().getTo().getData().getTranslatedName().getString()}))));
                        break;
                    }
                    case SWITCH: {
                        lines.remove(0);
                        lines.add(Component.m_237115_((String)I18n.m_118938_((String)"duel.log.switch", (Object[])new Object[]{playerName, item.getSwitchParameters().getCard().getData().getTranslatedName().getString()})));
                        break;
                    }
                    case PASSTURN: {
                        lines.remove(0);
                        lines.add(Component.m_237115_((String)I18n.m_118938_((String)"duel.log.passturn", (Object[])new Object[]{playerName})));
                        break;
                    }
                    case STARTGAME: {
                        lines.remove(0);
                        lines.add(Component.m_237115_((String)I18n.m_118938_((String)"duel.log.gamestarted", (Object[])new Object[0])));
                    }
                }
                this.parent.drawHoveringText(graphics, lines, mX, mY, Energy.COLORLESS);
            }
        }
    }
}

