/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.client.gui.duel;

import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.network.ByteBufTCG;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import net.minecraft.network.FriendlyByteBuf;

public class CardWithLocation {
    protected CommonCardState card;
    protected boolean isMine;
    protected BoardLocation location;
    protected int locationSubIndex;

    public CardWithLocation() {
    }

    public CardWithLocation(CommonCardState card, boolean isMine, BoardLocation location, int locationSubIndex) {
        this.set(card, isMine, location, locationSubIndex);
    }

    public CardWithLocation(FriendlyByteBuf buf) {
        this.card = ByteBufTCG.readCardState(buf);
        this.isMine = buf.readBoolean();
        int locationIndex = buf.readInt();
        this.location = locationIndex == -1 ? null : BoardLocation.values()[locationIndex];
        this.locationSubIndex = buf.readInt();
    }

    public void write(FriendlyByteBuf buf) {
        ByteBufTCG.writeCardState(buf, this.card);
        buf.writeBoolean(this.isMine);
        if (this.location == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.location.ordinal());
        }
        buf.writeInt(this.locationSubIndex);
    }

    public void set(CommonCardState card, boolean isMine, BoardLocation location, int locationSubIndex) {
        this.isMine = isMine;
        this.card = card;
        this.location = location;
        this.locationSubIndex = locationSubIndex;
    }

    public boolean isMine() {
        return this.isMine;
    }

    public CommonCardState getCard() {
        return this.card;
    }

    public BoardLocation getLocation() {
        return this.location;
    }

    public int getLocationSubIndex() {
        return this.locationSubIndex;
    }
}

