/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.client.gui.duel;

import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.tcg.api.util.helper.NetworkHelper;
import com.pixelmonmod.tcg.api.util.helper.SelectorHelper;
import com.pixelmonmod.tcg.client.gui.base.TCGScreenBase;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.duel.TCGScreen;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorPurpose;
import com.pixelmonmod.tcg.client.helper.CardRenderingHelper;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.PlayerClientMyState;
import com.pixelmonmod.tcg.duel.state.PlayerClientOpponentState;
import com.pixelmonmod.tcg.network.packets.battles.CardSelectorToServerPacket;
import com.pixelmonmod.tcg.network.packets.battles.RetreatAndSwitchPacket;
import com.pixelmonmod.tcg.network.packets.battles.SwitchPacket;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class CardSelector
extends TCGScreenBase {
    protected static final ResourceLocation DISCARD = ResourceLocationHelper.of("tcg", "gui/cards/discard.png");
    protected static final ResourceLocation SELECT = ResourceLocationHelper.of("tcg", "gui/cards/select.png");
    private static final int SCROLL_SPEED = 70;
    private static final int BUTTON_ACCEPT_ID = 101;
    private static final int BUTTON_CANCEL_ID = 102;
    private final TCGScreen parent;
    private CardSelectorState data = null;
    private CardSelectorPurpose purpose = null;
    private CardWithLocation renderLast = null;
    private int renderLastPos = -1;
    private BattleOwnedTileEntityController controller;
    private boolean[] isSelectedAtPosition;
    private int scrollModifier = 0;
    private boolean mousePressed = false;
    private boolean isMouseInGrid = false;
    private boolean tooFarLeft = false;
    private boolean tooFarRight = false;
    private boolean canScroll = true;
    private IndexedButton acceptButton = new IndexedButton(101, 0, 0, 40, 20, "OK", this::actionPerformed);
    private IndexedButton cancelButton = new IndexedButton(102, 0, 0, 40, 20, "Cancel", this::actionPerformed);

    public CardSelector(TCGScreen parent, BattleOwnedTileEntityController controller) {
        this.parent = parent;
        this.controller = controller;
    }

    public void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        if (!this.parent.isSpectating) {
            this.m_142416_((GuiEventListener)this.acceptButton);
            this.m_142416_((GuiEventListener)this.cancelButton);
        }
    }

    @Override
    public void m_86600_() {
        if (this.data == null) {
            return;
        }
        super.m_86600_();
        this.cancelButton.f_93624_ = this.data.isCancellable();
        this.acceptButton.f_93624_ = this.getSelectionCount() >= this.data.getMinimumCount();
        this.acceptButton.f_93620_ = this.getScaledWidth() / 2 - (this.data.isCancellable() ? 45 : 20);
        this.acceptButton.f_93621_ = this.getScaledHeight() / 2 + 50;
        this.cancelButton.f_93620_ = this.getScaledWidth() / 2 + (this.data.getMaximumCount() > 0 ? 5 : -20);
        this.cancelButton.f_93621_ = this.getScaledHeight() / 2 + 50;
    }

    @Override
    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        MutableComponent hint;
        if (this.data == null) {
            return;
        }
        super.m_88315_(matrix, mouseX, mouseY, partialTicks);
        List<CardWithLocation> cardList = this.data.getCardList();
        MutableComponent mutableComponent = hint = this.data.getCustomText() == null ? null : Component.m_237115_((String)this.data.getCustomText());
        if (hint == null) {
            if (this.data.getMaximumCount() > 0) {
                String rangeText = "" + this.data.getMaximumCount();
                if (this.data.getMaximumCount() > this.data.getMinimumCount()) {
                    rangeText = this.data.getMinimumCount() + "-" + this.data.getMaximumCount();
                }
                String suffix = this.data.getMaximumCount() > 1 ? (this.data.isCountEnergy() ? I18n.m_118938_((String)"tcg.energy.plural", (Object[])new Object[0]) : I18n.m_118938_((String)"tcg.card.plural", (Object[])new Object[0])) : (this.data.isCountEnergy() ? I18n.m_118938_((String)"tcg.energy.singular", (Object[])new Object[0]) : I18n.m_118938_((String)"tcg.card.singular", (Object[])new Object[0]));
                hint = Component.m_237115_((String)I18n.m_118938_((String)"tcg.cardselector.hint", (Object[])new Object[]{this.data.getDisplayType().toString(), rangeText, suffix}));
            } else if (this.data.getDisplayType() == CardSelectorDisplay.Reveal) {
                hint = Component.m_237115_((String)I18n.m_118938_((String)"tcg.battle.reveal", (Object[])new Object[]{this.controller.getClient().getOpponent().getPlayerName()}));
            }
        }
        if (hint != null) {
            ScreenHelper.drawString(matrix, hint.getString(), this.getScaledWidth() / 2 - this.f_96541_.f_91062_.m_92852_((FormattedText)hint) / 2, (float)(this.getScaledHeight() / 2 - 65), 0xFFFFFF, true);
        }
        GameClientState client = this.controller.getClient();
        PlayerClientMyState me = client.getMe();
        PlayerClientOpponentState opp = client.getOpponent();
        int size = cardList.size();
        boolean isMouseOut = true;
        for (int cardIndex = 0; cardIndex < size; ++cardIndex) {
            CardWithLocation card = cardList.get(cardIndex);
            Button target = this.getGuiTarget(cardIndex, size);
            this.isMouseInGrid = target.m_5953_((double)mouseX, (double)mouseY);
            float scaleFactor = 0.5f;
            if (this.isMouseInGrid) {
                this.renderLast = card;
                this.renderLastPos = cardIndex;
                isMouseOut = false;
                this.canScroll = false;
            } else {
                this.canScroll = true;
                matrix.m_280168_().m_85836_();
                matrix.m_280168_().m_85841_(scaleFactor, scaleFactor, scaleFactor);
                int cardX = (int)((float)(this.getScaledWidth() * 2 + cardIndex * 250 - (size - 1) * 125 + this.scrollModifier) / (scaleFactor * 2.0f));
                int cardY = (int)((float)(this.getScaledHeight() * 2) / (scaleFactor * 2.0f));
                float cardZ = this.isMouseInGrid ? 1.1f : 1.0f;
                float opacity = this.getCardOpacity(cardIndex);
                if (card == null) {
                    CardRenderingHelper.drawCardBack(matrix, cardX, cardY, cardZ - 0.1f, me);
                } else {
                    CardRenderingHelper.drawCard(matrix, card.getCard(), cardX, cardY, cardZ - 0.1f, opacity, 0.0, me, opp);
                }
                matrix.m_280168_().m_85841_(-scaleFactor, -scaleFactor, -scaleFactor);
                matrix.m_280168_().m_85849_();
                String title = "";
                if (card == null) {
                    title = BoardLocation.Deck.toString();
                } else if (card.getLocation() != null) {
                    title = card.getLocation().toString();
                }
                matrix.m_280488_(this.f_96547_, title, (int)((float)cardX * scaleFactor / 2.0f) - this.f_96541_.f_91062_.m_92895_(title) / 2, this.getScaledHeight() / 2 - 51, 0xFFFFFF);
                if (this.isSelectedAtPosition[cardIndex]) {
                    this.drawSelectionOverlay(matrix, target, scaleFactor, 0.9f);
                }
                if (cardIndex == 0) {
                    boolean bl = this.tooFarLeft = cardX > 285;
                }
                if (cardIndex == size - 1) {
                    boolean bl = this.tooFarRight = cardX < this.f_96543_ + 1180;
                }
            }
            if (!this.parent.isSpectating && this.isLeftMousePressed()) {
                if (!this.isMouseInGrid || this.mousePressed) continue;
                if (this.getSelectionCount() == this.getData().getMaximumCount() && !this.isSelectedAtPosition[cardIndex]) {
                    if (this.getData().getMaximumCount() == 1) {
                        this.isSelectedAtPosition = new boolean[this.isSelectedAtPosition.length];
                        this.isSelectedAtPosition[cardIndex] = true;
                    }
                } else {
                    this.isSelectedAtPosition[cardIndex] = !this.isSelectedAtPosition[cardIndex];
                }
                this.mousePressed = true;
                continue;
            }
            if (this.isLeftMousePressed() || !this.mousePressed) continue;
            this.mousePressed = false;
        }
        if (isMouseOut) {
            this.renderLast = null;
            this.renderLastPos = -1;
        }
        if (this.renderLast != null || this.renderLastPos != -1) {
            float cardZ;
            Button target = this.getGuiTarget(this.renderLastPos, size);
            this.isMouseInGrid = target.m_5953_((double)mouseX, (double)mouseY);
            float scaleFactor = 0.5f;
            if (this.mousePressed && this.isMouseInGrid) {
                scaleFactor = 0.9f;
            } else if (this.isMouseInGrid) {
                scaleFactor = 1.0f;
            }
            float opacity = this.getCardOpacity(this.renderLastPos);
            matrix.m_280168_().m_85836_();
            matrix.m_280168_().m_85841_(scaleFactor, scaleFactor, scaleFactor);
            int cardX = (int)((float)(this.getScaledWidth() * 2 + this.renderLastPos * 250 - (size - 1) * 125 + this.scrollModifier) / (scaleFactor * 2.0f));
            int cardY = (int)((float)(this.getScaledHeight() * 2) / (scaleFactor * 2.0f));
            float f = cardZ = this.isMouseInGrid ? 1.1f : 1.0f;
            if (this.renderLast == null) {
                CardRenderingHelper.drawCardBack(matrix, cardX, cardY, cardZ - 0.1f, me);
            } else {
                CardRenderingHelper.drawCard(matrix, this.renderLast.getCard(), cardX, cardY, cardZ - 0.1f, opacity, 0.0, me, opp);
            }
            matrix.m_280168_().m_85841_(-scaleFactor, -scaleFactor, -scaleFactor);
            matrix.m_280168_().m_85849_();
            if (this.isSelectedAtPosition[this.renderLastPos]) {
                this.drawSelectionOverlay(matrix, target, scaleFactor, 0.5f);
            }
            String title = null;
            if (this.renderLast == null) {
                title = I18n.m_118938_((String)"tcg.deck.title", (Object[])new Object[0]);
            } else if (this.renderLast.getLocation() != null) {
                title = this.renderLast.getLocation().toString();
            }
            matrix.m_280488_(this.f_96547_, title, (int)((float)cardX * scaleFactor / 2.0f) - this.f_96541_.f_91062_.m_92895_(title) / 2, this.getScaledHeight() / 2 - 93, 0xFFFFFF);
        }
    }

    private void drawSelectionOverlay(GuiGraphics graphics, Button target, float scaleFactor, float opacity) {
        switch (this.data.getDisplayType()) {
            case Discard: {
                graphics.m_280246_(0.0f, 0.0f, 0.0f, opacity / 2.0f);
                ScreenHelper.drawImageQuad(DISCARD, graphics, (float)((double)((float)(target.f_93620_ + target.m_5711_() / 2) - 24.0f * scaleFactor) + 0.5), (float)((double)((float)(target.f_93621_ + target.m_93694_() / 2) - 24.0f * scaleFactor) + 0.5), 48.0f * scaleFactor, 48.0f * scaleFactor, 0.0f, 0.0f, 1.0f, 1.0f, 1.2f);
                graphics.m_280246_(1.0f, 0.0f, 0.0f, opacity);
                ScreenHelper.drawImageQuad(DISCARD, graphics, (float)(target.f_93620_ + target.m_5711_() / 2) - 24.0f * scaleFactor, (float)(target.f_93621_ + target.m_93694_() / 2) - 24.0f * scaleFactor, 48.0f * scaleFactor, 48.0f * scaleFactor, 0.0f, 0.0f, 1.0f, 1.0f, 1.2f);
                break;
            }
            case Draw: 
            case Select: {
                graphics.m_280246_(0.0f, 0.0f, 0.0f, opacity / 2.0f);
                ScreenHelper.drawImageQuad(SELECT, graphics, (float)((double)((float)(target.f_93620_ + target.m_5711_() / 2) - 24.0f * scaleFactor) + 0.5), (float)((double)((float)(target.f_93621_ + target.m_93694_() / 2) - 24.0f * scaleFactor) + 0.5), 48.0f * scaleFactor, 48.0f * scaleFactor, 0.0f, 0.0f, 1.0f, 1.0f, 1.2f);
                graphics.m_280246_(0.2f, 0.3f, 1.0f, opacity);
                ScreenHelper.drawImageQuad(SELECT, graphics, (float)(target.f_93620_ + target.m_5711_() / 2) - 24.0f * scaleFactor, (float)(target.f_93621_ + target.m_93694_() / 2) - 24.0f * scaleFactor, 48.0f * scaleFactor, 48.0f * scaleFactor, 0.0f, 0.0f, 1.0f, 1.0f, 1.2f);
                break;
            }
        }
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private Button getGuiTarget(int cardIndex, int size) {
        int sizeModXA = -26;
        int sizeModXB = 27;
        int sizeModYA = -42;
        int sizeModYB = 40;
        return new Button(this.getScaledWidth() / 2 + cardIndex * 250 / 4 - (size - 1) * 125 / 4 + this.scrollModifier / 4 - sizeModXB, this.getScaledHeight() / 2 - sizeModYB, sizeModXB - sizeModXA, sizeModYB - sizeModYA, (Component)Component.m_237119_(), p_93751_ -> {}, p_onPress_1_ -> Component.m_237119_());
    }

    protected void actionPerformed(Button button) {
        if (this.data == null || !(button instanceof IndexedButton)) {
            return;
        }
        switch (((IndexedButton)button).getID()) {
            case 101: {
                this.scrollModifier = 0;
                this.acceptSelection();
                break;
            }
            case 102: {
                this.scrollModifier = 0;
                this.set(null, null);
            }
        }
    }

    @Override
    public boolean m_5534_(char key, int code) {
        if (this.data == null) {
            return true;
        }
        return super.m_5534_(key, code);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.data == null) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public void set(CardSelectorPurpose purpose, CardSelectorState data) {
        if (data == null && this.data != null && this.data.getDisplayType() == CardSelectorDisplay.Reveal) {
            return;
        }
        CardSelectorState oldData = this.data;
        this.purpose = purpose;
        this.data = data;
        if (data == null && oldData != null || data != null && oldData == null || data != null && oldData != null && oldData.getId() != data.getId()) {
            this.initialize();
            if (purpose == CardSelectorPurpose.Trainer) {
                NetworkHelper.sendToServer(new CardSelectorToServerPacket(this.controller.m_58899_(), true, null));
            }
        }
    }

    public CardSelectorState getData() {
        return this.data;
    }

    public CardSelectorPurpose getPurpose() {
        return this.purpose;
    }

    public void initialize() {
        this.isSelectedAtPosition = null;
        if (this.data != null) {
            this.isSelectedAtPosition = new boolean[this.data.getCardList().size()];
        }
    }

    public List<CommonCardState> getSelectedCards() {
        ArrayList<CommonCardState> cards = new ArrayList<CommonCardState>();
        for (int i = 0; i < this.data.getCardList().size(); ++i) {
            if (!this.isSelectedAtPosition[i]) continue;
            cards.add(this.data.getCardList().get(i).getCard());
        }
        return cards;
    }

    void acceptSelection() {
        if (this.data.getDisplayType() == CardSelectorDisplay.Reveal) {
            this.data = null;
            this.purpose = null;
            return;
        }
        int selectionCount = this.getSelectionCount();
        switch (this.purpose) {
            case Trainer: {
                if (selectionCount > this.data.getMaximumCount() || selectionCount < this.data.getMinimumCount()) break;
                NetworkHelper.sendToServer(new CardSelectorToServerPacket(this.controller.m_58899_(), true, this.isSelectedAtPosition));
                break;
            }
            case StartRetreating: {
                if (selectionCount >= this.data.getMinimumCount()) {
                    this.controller.energySelectionForRetreat = this.isSelectedAtPosition;
                }
                PlayerClientMyState me = this.controller.getClient().getMe();
                CardSelectorState state = SelectorHelper.generateSelectorForBench(me, "battle.selector.newactive");
                state.setCancellable(true);
                this.set(CardSelectorPurpose.FinishRetreating, state);
                break;
            }
            case FinishRetreating: {
                for (int i = 0; i < this.data.getCardList().size(); ++i) {
                    if (!this.isSelectedAtPosition[i]) continue;
                    NetworkHelper.sendToServer(new RetreatAndSwitchPacket(this.controller.m_58899_(), this.controller.energySelectionForRetreat, this.data.getCardList().get(i).getLocationSubIndex()));
                }
                this.controller.energySelectionForRetreat = null;
                this.set(null, null);
                break;
            }
            case KnockoutSwitch: {
                for (int i = 0; i < this.data.getCardList().size(); ++i) {
                    if (!this.isSelectedAtPosition[i]) continue;
                    NetworkHelper.sendToServer(new SwitchPacket(this.controller.m_58899_(), this.data.getCardList().get(i).getLocationSubIndex()));
                }
                this.set(null, null);
            }
        }
    }

    private int getSelectionCount() {
        int selectionCount = 0;
        for (int i = 0; i < this.isSelectedAtPosition.length; ++i) {
            if (!this.isSelectedAtPosition[i]) continue;
            ++selectionCount;
            if (!this.data.isCountEnergy() || this.data.getCardList().get(i).getCard().getSecondaryEnergy() == null) continue;
            ++selectionCount;
        }
        return selectionCount;
    }

    private float getCardOpacity(int pos) {
        return 1.0f;
    }
}

