/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.client.gui.base;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import com.pixelmonmod.tcg.client.gui.base.TCGScreenBase;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.ChatVisiblity;

public class TCGScreenChattableBase
extends TCGScreenBase {
    private int bPosX = 0;
    private int bPosY = 0;
    private int bWidth = 0;
    public static boolean chatOpen = false;
    private int sentHistoryCursor = -1;
    protected EditBox inputField;
    private boolean autoComplete;
    private int nameCycle;
    private ArrayList<String> onlineNames = Lists.newArrayList();
    private String savedText;

    public TCGScreenChattableBase() {
        this.f_96541_ = Minecraft.m_91087_();
        chatOpen = false;
        this.inputField = new EditBox(this.f_96541_.f_91062_, 0, 0, 0, 0, (Component)Component.m_237119_());
        this.inputField.m_94199_(100);
        this.inputField.m_93692_(true);
        this.inputField.m_94144_("");
        this.inputField.m_94190_(false);
        this.inputField.m_94194_(false);
    }

    public void m_7856_() {
        super.m_7856_();
        this.sentHistoryCursor = this.f_96541_.f_91065_.m_93076_().m_93797_().size();
        this.handleResize(this.f_96541_);
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        if (this.inputField != null) {
            // empty if block
        }
    }

    private void handleResize(Minecraft mc) {
        Window window = this.f_96541_.m_91268_();
        float guiScaling = (float)((double)((float)window.m_85442_() / 240.0f) / window.m_85449_());
        this.bPosX = 42;
        this.bPosY = this.f_96544_ - (int)(56.0f * guiScaling);
        this.bWidth = this.f_96543_ - 124;
        this.inputField.f_93620_ = this.bPosX + 2;
        this.inputField.f_93621_ = this.bPosY + 2;
        this.inputField.m_93674_(this.bWidth - 2);
        this.inputField.m_293384_(this.bPosY + 10);
    }

    public void m_7379_() {
        super.m_7379_();
        this.f_96541_.f_91065_.m_93076_().m_93810_();
        chatOpen = false;
    }

    public void chatOpened(String start) {
        if (this.f_96541_.f_91066_.f_92119_.m_231551_() == ChatVisiblity.HIDDEN || this.inputField == null) {
            return;
        }
        if (start != null) {
            this.inputField.m_94144_(start);
        } else {
            this.inputField.m_94144_("");
        }
        chatOpen = true;
        this.inputField.m_94194_(true);
    }

    public void chatClosed() {
        chatOpen = false;
        this.inputField.m_94194_(false);
        this.inputField.m_94144_("");
    }

    @Override
    public boolean m_5534_(char key, int keyCode) {
        if (!(keyCode != Minecraft.m_91087_().f_91066_.f_92098_.getKey().m_84873_() && keyCode != 47 || chatOpen)) {
            this.chatOpened(keyCode == 47 ? "/" : null);
            return true;
        }
        if (keyCode == 1 && chatOpen) {
            this.chatClosed();
            return true;
        }
        if (chatOpen) {
            if (keyCode == 258) {
                this.completePlayerName();
            } else {
                this.autoComplete = false;
            }
            if (keyCode != 28 && keyCode != 156) {
                if (keyCode == 200) {
                    this.getSentHistory(-1);
                } else if (keyCode == 208) {
                    this.getSentHistory(1);
                } else if (keyCode == 201) {
                    this.f_96541_.f_91065_.m_93076_().m_205360_(1);
                } else if (keyCode == 209) {
                    this.f_96541_.f_91065_.m_93076_().m_205360_(-1);
                } else {
                    this.inputField.m_5534_(key, keyCode);
                }
            } else {
                String s = this.inputField.m_94155_().trim();
                if (!s.isEmpty()) {
                    this.f_96541_.f_91065_.m_93076_().m_93785_((Component)Component.m_237113_((String)s));
                    this.f_96541_.f_91074_.f_108617_.m_246175_(s);
                }
                this.inputField.m_94144_("");
                this.chatClosed();
            }
        }
        return super.m_5534_(key, keyCode);
    }

    public void completePlayerName() {
        if (this.autoComplete) {
            this.inputField.m_94180_(this.inputField.m_94184_(-1) - this.inputField.m_94207_());
            if (this.nameCycle >= this.onlineNames.size()) {
                this.nameCycle = 0;
            }
        } else {
            int i = this.inputField.m_94184_(-1);
            this.onlineNames.clear();
            this.nameCycle = 0;
            String s1 = this.inputField.m_94155_().substring(i).toLowerCase();
            String s = this.inputField.m_94155_().substring(0, this.inputField.m_94207_());
            if (this.onlineNames.isEmpty()) {
                return;
            }
            this.autoComplete = true;
            this.inputField.m_94180_(i - this.inputField.m_94207_());
        }
        if (this.onlineNames.size() > 1) {
            StringBuilder stringbuilder = new StringBuilder();
            for (String s : this.onlineNames) {
                if (stringbuilder.length() > 0) {
                    stringbuilder.append(", ");
                }
                stringbuilder.append(s);
            }
            this.f_96541_.f_91065_.m_93076_().m_93785_((Component)Component.m_237113_((String)stringbuilder.toString()));
        }
        this.inputField.m_94144_(this.inputField.m_94155_() + ChatFormatting.m_126649_((String)this.onlineNames.get(this.nameCycle++)));
    }

    public void getSentHistory(int par1) {
        int j = this.sentHistoryCursor + par1;
        int k = this.f_96541_.f_91065_.m_93076_().m_93797_().size();
        if (j < 0) {
            j = 0;
        }
        if (j > k) {
            j = k;
        }
        if (j != this.sentHistoryCursor) {
            try {
                if (j == k) {
                    this.sentHistoryCursor = k;
                    this.inputField.m_94144_(this.savedText);
                } else {
                    if (this.sentHistoryCursor == k) {
                        this.savedText = this.inputField.m_94155_();
                    }
                    this.inputField.m_94144_((String)this.f_96541_.f_91065_.m_93076_().m_93797_().get(j));
                    this.sentHistoryCursor = j;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.inputField.m_6375_(mouseX, mouseY, mouseButton);
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public int getChatWidth() {
        return TCGScreenChattableBase.calculateChatboxWidth((Double)this.f_96541_.f_91066_.m_232113_().m_231551_());
    }

    public int getChatHeight() {
        return TCGScreenChattableBase.calculateChatboxHeight((Double)this.f_96541_.f_91066_.m_232117_().m_231551_());
    }

    public double getChatScale() {
        return (Double)this.f_96541_.f_91066_.m_232110_().m_231551_();
    }

    public static int calculateChatboxWidth(double p_146233_0_) {
        int short1 = 320;
        int b0 = 40;
        return Mth.m_14107_((double)(p_146233_0_ * (double)(short1 - b0) + (double)b0));
    }

    public static int calculateChatboxHeight(double p_146243_0_) {
        int short1 = 180;
        int b0 = 20;
        return Mth.m_14107_((double)(p_146243_0_ * (double)(short1 - b0) + (double)b0));
    }

    public int getLineCount() {
        return this.getChatHeight() / 9;
    }
}

