/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.client.gui.base;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.api.card.ability.CardPower;
import com.pixelmonmod.tcg.client.helper.CardRenderingHelper;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class TCGScreenBase
extends Screen {
    public boolean visible = true;
    private int buttonPressed = -1;
    protected List<EditBox> textFieldList = new ArrayList<EditBox>();

    public TCGScreenBase() {
        super((Component)Component.m_237119_());
        if (this.f_96541_ == null) {
            this.f_96541_ = Minecraft.m_91087_();
        }
    }

    public void m_86600_() {
        if (this.visible) {
            super.m_86600_();
        }
    }

    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            this.textFieldList.forEach(field -> field.m_88315_(matrix, mouseX, mouseY, partialTicks));
            super.m_88315_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        for (EditBox textField : this.textFieldList) {
            if (!textField.m_7933_(key, scanCode, modifiers)) continue;
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    public boolean m_5534_(char key, int code) {
        for (EditBox textField : this.textFieldList) {
            if (!textField.m_5534_(key, code)) continue;
            return true;
        }
        return super.m_5534_(key, code);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.buttonPressed = mouseButton;
        if (this.visible) {
            for (EditBox textField : this.textFieldList) {
                if (!textField.m_6375_(mouseX, mouseY, mouseButton)) continue;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        this.buttonPressed = -1;
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    public boolean isLeftMousePressed() {
        return this.buttonPressed == 0;
    }

    public boolean isRightMousePressed() {
        return this.buttonPressed == 1;
    }

    public void drawEffectTooltip(GuiGraphics matrix, CommonCardState card, int mouseX, int mouseY, int xOffset, int yOffset) {
        int lines = 0;
        int x0 = this.f_96543_ / 2 + xOffset;
        int y0 = this.f_96544_ / 2 + yOffset;
        PokemonAttackStatus[] attacks = null;
        if (card instanceof PokemonCardState) {
            attacks = ((PokemonCardState)card).getAttacksStatus();
        } else if (card.getData().getAttacks() != null) {
            attacks = (PokemonAttackStatus[])card.getData().getAttacks().stream().map(PokemonAttackStatus::new).toArray(PokemonAttackStatus[]::new);
        }
        CardPower cardAbility = card.getData().getAbility();
        if (cardAbility != null) {
            int linesForAbility;
            int n = linesForAbility = attacks != null && attacks.length > 0 ? 2 : 5;
            if (attacks.length == 1 && !attacks[0].hasDescription()) {
                linesForAbility = 4;
            }
            int x1 = x0 - 46;
            int x2 = x0 + 46;
            int y1 = y0 + 9;
            int y2 = y0 - 1 + (linesForAbility + 1) * 9;
            if (mouseX > x1 && mouseX < x2 && mouseY > y1 && mouseY < y2) {
                ArrayList list = Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)cardAbility.getName()).m_130940_(ChatFormatting.BOLD), Component.m_237115_((String)cardAbility.getDescription()).m_130940_(ChatFormatting.BOLD)});
                this.drawHoveringText(matrix, list, mouseX, mouseY, card.getMainEnergy());
            }
            lines += linesForAbility;
        }
        if (attacks != null && attacks.length > 0) {
            int[] descriptionLines = CardRenderingHelper.calculateAttackDescriptionLines(attacks, cardAbility != null, 94);
            for (int i = 0; i < attacks.length; ++i) {
                if (attacks[i] == null) continue;
                if (attacks[i].hasDescription()) {
                    int x1 = x0 - 46;
                    int x2 = x0 + 46;
                    int y1 = y0 - 1 + (lines + 1 + (cardAbility != null ? 1 : 0)) * 9;
                    int y2 = y0 - 1 + (lines + 1 + (cardAbility != null ? 1 : 0) + descriptionLines[i]) * 9;
                    if (mouseX > x1 && mouseX < x2 && mouseY > y1 && mouseY < y2) {
                        this.drawHoveringText(matrix, Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)attacks[i].getData().getName()).m_130940_(ChatFormatting.BOLD), attacks[i].getLocalizedDescription()}), mouseX, mouseY, card.getMainEnergy());
                    }
                    lines += 1 + descriptionLines[i];
                    continue;
                }
                ++lines;
            }
        }
    }

    public void drawHoveringText(GuiGraphics matrix, List<Component> textLines, int x, int y, Energy type) {
        if (!textLines.isEmpty()) {
            int popupWidth = 130;
            int lineCount = 0;
            for (Component s : textLines) {
                List<String> lines = ScreenHelper.splitString(s.getString(), popupWidth);
                lineCount += lines.size();
            }
            int startX = x + 12;
            int startY = y - 12;
            int popupHeight = 2 + lineCount * 9;
            if (startX + popupWidth > this.f_96543_) {
                startX -= 20 + popupWidth;
            }
            if (startY + popupHeight + 6 > this.f_96544_) {
                startY = this.f_96544_ - popupHeight - 6;
            }
            int j1 = CardRenderingHelper.getBackgroundColor(type);
            ScreenHelper.drawGradientRect(matrix, startX - 4, startY - 4, 300.0f, startX + popupWidth + 3, startY - 3, j1, j1);
            ScreenHelper.drawGradientRect(matrix, startX - 4, startY + popupHeight + 3, 300.0f, startX + popupWidth + 3, startY + popupHeight + 4, j1, j1);
            ScreenHelper.drawGradientRect(matrix, startX - 4, startY - 3, 300.0f, startX + popupWidth + 3, startY + popupHeight + 3, j1, j1);
            ScreenHelper.drawGradientRect(matrix, startX - 5, startY - 3, 300.0f, startX - 3, startY + popupHeight + 3, j1, j1);
            ScreenHelper.drawGradientRect(matrix, startX + popupWidth + 3, startY - 3, 300.0f, startX + popupWidth + 4, startY + popupHeight + 3, j1, j1);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            ScreenHelper.drawGradientRect(matrix, startX - 4, startY - 3 + 1, 300.0f, startX - 4 + 1, startY + popupHeight + 3 - 1, k1, l1);
            ScreenHelper.drawGradientRect(matrix, startX + popupWidth + 2, startY - 3 + 1, 300.0f, startX + popupWidth + 3, startY + popupHeight + 3 - 1, k1, l1);
            ScreenHelper.drawGradientRect(matrix, startX - 4, startY - 3, 300.0f, startX + popupWidth + 3, startY - 3 + 1, k1, k1);
            ScreenHelper.drawGradientRect(matrix, startX - 4, startY + popupHeight + 2, 300.0f, startX + popupWidth + 3, startY + popupHeight + 3, l1, l1);
            for (int i = 0; i < textLines.size(); ++i) {
                ScreenHelper.drawSplitString(matrix, textLines.get(i).getString(), startX, startY + i * 12, popupWidth, CardRenderingHelper.getForegroundColor(type));
            }
        }
    }

    public void drawRectWithBorder(GuiGraphics matrix, int x1, int y1, int x2, int y2, int backgroundColor, int borderColor) {
        matrix.m_280509_(x1, y1, x2, y2, backgroundColor);
        matrix.m_280656_(x1, x2, y1, borderColor);
        matrix.m_280656_(x1, x2, y2, borderColor);
        matrix.m_280315_(x1, y1, y2, borderColor);
        matrix.m_280315_(x2, y1, y2, borderColor);
    }

    public int getScaledWidth() {
        return this.f_96541_.m_91268_().m_85445_();
    }

    public int getScaledHeight() {
        return this.f_96541_.m_91268_().m_85446_();
    }
}

