/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.client.gui;

import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.tcg.api.util.helper.NetworkHelper;
import com.pixelmonmod.tcg.client.gui.base.TCGScreenBase;
import com.pixelmonmod.tcg.network.packets.RulebookUpdatePacket;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class TCGRuleEditorScreen
extends TCGScreenBase {
    public static ResourceLocation background = new ResourceLocation("tcg", "gui/background.png");
    private int deckSize;
    private int prizeCount;
    private int timeLimit;
    private String startingCommand;
    private String endingCommand;
    private String startingMessage;
    private String endingMessage;
    private int eloMinimum;
    private EditBox deckSizeTextField;
    private EditBox prizeCountTextField;
    private EditBox startingCommandTextField;
    private EditBox endingCommandTextField;
    private EditBox timeLimitTextField;
    private EditBox startingMessageTextField;
    private EditBox endingMessageTextField;
    private EditBox eloMinimumTextField;
    private final ItemStack book;
    private int hotbarSlot;
    private IndexedButton doneBtn;
    private IndexedButton cancelBtn;
    private static final int DONE_BUTTON_ID = 0;
    private static final int CANCEL_BUTTON_ID = 1;

    public TCGRuleEditorScreen(Player player, ItemStack book) {
        this.book = book;
        this.deckSize = book.m_41783_() != null ? book.m_41783_().m_128451_("DeckSize") : 60;
        this.timeLimit = book.m_41783_() != null ? book.m_41783_().m_128451_("TimeLimit") : 0;
        this.prizeCount = book.m_41783_() != null ? book.m_41783_().m_128451_("PrizeCount") : 6;
        this.startingCommand = book.m_41783_() != null ? book.m_41783_().m_128461_("StartingCommand") : "";
        this.endingCommand = book.m_41783_() != null ? book.m_41783_().m_128461_("EndingCommand") : "";
        this.startingMessage = book.m_41783_() != null ? book.m_41783_().m_128461_("StartingMessage") : "";
        this.endingMessage = book.m_41783_() != null ? book.m_41783_().m_128461_("EndingMessage") : "";
        this.eloMinimum = book.m_41783_() != null ? book.m_41783_().m_128451_("EloMinimum") : 0;
        this.hotbarSlot = player.m_150109_().f_35977_;
    }

    public void m_7856_() {
        this.f_96541_ = Minecraft.m_91087_();
        if (!this.book.m_41782_()) {
            this.book.m_41751_(new CompoundTag());
        }
        this.m_169413_();
        this.textFieldList.clear();
        this.doneBtn = new IndexedButton(0, this.f_96543_ / 2 - 4 - 150, 210, 150, 20, (Component)Component.m_237115_((String)"gui.done"), this::actionPerformed);
        this.m_142416_((GuiEventListener)this.doneBtn);
        this.cancelBtn = new IndexedButton(1, this.f_96543_ / 2 + 4, 210, 150, 20, (Component)Component.m_237115_((String)"gui.cancel"), this::actionPerformed);
        this.m_142416_((GuiEventListener)this.cancelBtn);
        this.deckSizeTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 150, 45, 23, 20, (Component)Component.m_237119_());
        this.textFieldList.add(this.deckSizeTextField);
        this.deckSizeTextField.m_94199_(Short.MAX_VALUE);
        this.deckSizeTextField.m_93692_(false);
        this.deckSizeTextField.m_94144_(Integer.toString(this.deckSize));
        this.prizeCountTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 80, 45, 23, 20, (Component)Component.m_237119_());
        this.textFieldList.add(this.prizeCountTextField);
        this.prizeCountTextField.m_94199_(Short.MAX_VALUE);
        this.prizeCountTextField.m_93692_(false);
        this.prizeCountTextField.m_94144_(Integer.toString(this.prizeCount));
        this.timeLimitTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 10, 45, 23, 20, (Component)Component.m_237119_());
        this.textFieldList.add(this.timeLimitTextField);
        this.timeLimitTextField.m_94199_(Short.MAX_VALUE);
        this.timeLimitTextField.m_93692_(false);
        this.timeLimitTextField.m_94144_(Integer.toString(this.timeLimit));
        this.eloMinimumTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 + 60, 45, 23, 20, (Component)Component.m_237119_());
        this.textFieldList.add(this.eloMinimumTextField);
        this.eloMinimumTextField.m_94199_(Short.MAX_VALUE);
        this.eloMinimumTextField.m_93692_(false);
        this.eloMinimumTextField.m_94144_(Integer.toString(this.eloMinimum));
        this.startingCommandTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 150, 115, 276, 20, (Component)Component.m_237119_());
        this.textFieldList.add(this.startingCommandTextField);
        this.startingCommandTextField.m_94199_(Short.MAX_VALUE);
        this.startingCommandTextField.m_93692_(false);
        this.startingCommandTextField.m_94144_(this.startingCommand);
        this.endingCommandTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 150, 180, 276, 20, (Component)Component.m_237119_());
        this.textFieldList.add(this.endingCommandTextField);
        this.endingCommandTextField.m_94199_(Short.MAX_VALUE);
        this.endingCommandTextField.m_93692_(false);
        this.endingCommandTextField.m_94144_(this.endingCommand);
        this.doneBtn.f_93623_ = this.deckSizeTextField.m_94155_().trim().length() > 0;
        super.m_7856_();
    }

    protected void actionPerformed(Button button) {
        if (button.f_93623_) {
            if (!this.book.m_41782_()) {
                this.book.m_41751_(new CompoundTag());
            }
            CompoundTag tag = this.book.m_41783_();
            if (button instanceof IndexedButton) {
                switch (((IndexedButton)button).getID()) {
                    case 1: {
                        this.f_96541_.m_91152_(null);
                        break;
                    }
                    case 0: {
                        try {
                            int deckSize = Integer.parseInt(this.deckSizeTextField.m_94155_());
                            if (deckSize == 30 || deckSize == 60) {
                                tag.m_128405_("DeckSize", deckSize);
                            } else {
                                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Deck size has to be 30 or 60!")));
                            }
                        }
                        catch (Exception e) {
                            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Invalid deck size!")));
                        }
                        try {
                            int prizeCount = Integer.parseInt(this.prizeCountTextField.m_94155_());
                            if (prizeCount >= 1 && prizeCount <= 6) {
                                tag.m_128405_("PrizeCount", prizeCount);
                            } else {
                                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Prize count has to be 1 to 6!")));
                            }
                        }
                        catch (Exception e) {
                            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Invalid prize count!")));
                        }
                        try {
                            int timeLimit = Integer.parseInt(this.timeLimitTextField.m_94155_());
                            if (timeLimit >= 0) {
                                tag.m_128405_("TimeLimit", timeLimit);
                            } else {
                                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Time limit has to be larger or equal to 0!")));
                            }
                        }
                        catch (Exception e) {
                            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Invalid time limit!")));
                        }
                        try {
                            int eloMinimum = Integer.parseInt(this.eloMinimumTextField.m_94155_());
                            if (eloMinimum >= 0) {
                                tag.m_128405_("EloMinimum", eloMinimum);
                            } else {
                                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Elo requirement has to be larger or equal to 0!")));
                            }
                        }
                        catch (Exception e) {
                            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Invalid Elo requirement!")));
                        }
                        tag.m_128359_("StartingCommand", this.startingCommandTextField.m_94155_());
                        tag.m_128359_("EndingCommand", this.endingCommandTextField == null ? "" : this.endingCommandTextField.m_94155_());
                        tag.m_128359_("StartingMessage", this.startingMessageTextField == null ? "" : this.startingMessageTextField.m_94155_());
                        tag.m_128359_("EndingMessage", this.endingMessageTextField == null ? "" : this.endingMessageTextField.m_94155_());
                        NetworkHelper.sendToServer(new RulebookUpdatePacket(tag, this.hotbarSlot));
                        this.f_96541_.m_91152_(null);
                    }
                }
            }
        }
    }

    @Override
    public boolean m_5534_(char typedChar, int keyCode) {
        this.doneBtn.f_93623_ = this.deckSizeTextField.m_94155_().trim().length() > 0;
        this.deckSizeTextField.m_94144_(this.deckSizeTextField.m_94155_().trim());
        this.prizeCountTextField.m_94144_(this.prizeCountTextField.m_94155_().trim());
        this.timeLimitTextField.m_94144_(this.timeLimitTextField.m_94155_().trim());
        if (!this.deckSizeTextField.m_94155_().equals("")) {
            try {
                int number = Integer.parseInt(this.deckSizeTextField.m_94155_());
                if (number > 60) {
                    number = 60;
                }
                this.deckSize = number;
            }
            catch (Exception number) {
                // empty catch block
            }
            this.deckSizeTextField.m_94144_(Integer.toString(this.deckSize));
        }
        if (!this.prizeCountTextField.m_94155_().equals("")) {
            try {
                int number = Integer.parseInt(this.prizeCountTextField.m_94155_());
                if (number > 6) {
                    number = 6;
                }
                if (number < 1) {
                    number = 1;
                }
                this.prizeCount = number;
            }
            catch (Exception number) {
                // empty catch block
            }
            this.prizeCountTextField.m_94144_(Integer.toString(this.prizeCount));
        }
        if (!this.timeLimitTextField.m_94155_().equals("")) {
            try {
                int number = Integer.parseInt(this.timeLimitTextField.m_94155_());
                if (number < 0) {
                    number = 0;
                }
                this.timeLimit = number;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.timeLimitTextField.m_94144_(Integer.toString(this.timeLimit));
        }
        if (keyCode != 28 && keyCode != 156) {
            if (keyCode == 1) {
                this.actionPerformed(this.cancelBtn);
            }
        } else {
            this.actionPerformed(this.doneBtn);
        }
        return super.m_5534_(typedChar, keyCode);
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
    }

    @Override
    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        matrix.m_280163_(background, this.f_96543_ / 2 - 175, 0, 0.0f, 0.0f, 350, 350, 350, 350);
        super.m_88315_(matrix, mouseX, mouseY, partialTicks);
        ScreenHelper.drawCenteredString(matrix, ChatFormatting.BOLD + I18n.m_118938_((String)"battleRule.setRule", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f, 10.0f, 0xFFFFFF);
        ScreenHelper.drawString(matrix, I18n.m_118938_((String)"battleRule.deckSize", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 150.0f, 30.0f, 0xFFFFFF);
        ScreenHelper.drawString(matrix, I18n.m_118938_((String)"battleRule.prizeCount", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 80.0f, 30.0f, 0xFFFFFF);
        ScreenHelper.drawString(matrix, I18n.m_118938_((String)"battleRule.timeLimit", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 10.0f, 30.0f, 0xFFFFFF);
        ScreenHelper.drawString(matrix, I18n.m_118938_((String)"battlerule.setstartingcommands", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 150.0f, 76.0f, 0xFFFFFF);
        ScreenHelper.drawString(matrix, I18n.m_118938_((String)"battlerule.setendingcommands", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 150.0f, 141.0f, 0xFFFFFF);
    }
}

