/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.block;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.tcg.api.accessors.TCGBlocks;
import com.pixelmonmod.tcg.api.config.TCGConfigProxy;
import com.pixelmonmod.tcg.init.registry.BlockRegistration;
import com.pixelmonmod.tcg.listener.TCGServerEventListeners;
import com.pixelmonmod.tcg.tileentity.EssenceJarTileEntity;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EssenceJarBlock
extends BaseEntityBlock {
    public static final BooleanProperty CONTENTS = BooleanProperty.m_61465_((String)"contents");
    private static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public EssenceJarBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60955_().m_60977_());
    }

    public static ItemStack createJarItem(DyeColor dyeColor) {
        Color color = new Color(dyeColor.m_41071_());
        return EssenceJarBlock.createJarItem(0.0, color, dyeColor.m_41065_());
    }

    public static ItemStack createJarItem(double jarPercentFull, Color color, String colorName) {
        if (TCGBlocks.essence_jar == null) {
            return ItemStack.f_41583_;
        }
        Item item = TCGBlocks.essence_jar.m_5456_();
        ItemStack itemStack = new ItemStack((ItemLike)item);
        itemStack.m_41784_();
        itemStack.m_41698_("BlockEntityTag").m_128347_("EssenceJarPercent", jarPercentFull);
        int amountOfEssenceToFillJar = TCGConfigProxy.getConfig() == null ? 100 : TCGConfigProxy.getConfig().getEssenceToFillJar();
        itemStack.m_41698_("BlockEntityTag").m_128405_("EssenceJarCount", (int)((double)amountOfEssenceToFillJar * jarPercentFull));
        itemStack.m_41698_("BlockEntityTag").m_128405_("EssenceJarColorRed", color.getRed());
        itemStack.m_41698_("BlockEntityTag").m_128405_("EssenceJarColorGreen", color.getGreen());
        itemStack.m_41698_("BlockEntityTag").m_128405_("EssenceJarColorBlue", color.getBlue());
        itemStack.m_41698_("BlockEntityTag").m_128359_("EssenceJarColorName", Component.Serializer.m_130703_((Component)Component.m_237115_((String)("color.minecraft." + colorName.toLowerCase(Locale.ROOT)))));
        return itemStack;
    }

    public static ItemStack createFullJarItem(DyeColor dyeColor) {
        Color color = new Color(dyeColor.m_41071_());
        return EssenceJarBlock.createFullJarItem(color, dyeColor.m_41065_());
    }

    public static ItemStack createFullJarItem(Color color, String colorName) {
        if (TCGBlocks.essence_jar == null) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = EssenceJarBlock.createJarItem(1.0, color, colorName);
        itemStack.m_41698_("BlockEntityTag").m_128405_("EssenceJarCount", TCGConfigProxy.getConfig() == null ? 100 : TCGConfigProxy.getConfig().getEssenceToFillJar());
        itemStack.m_41698_("BlockEntityTag").m_128347_("EssenceJarPercent", 1.0);
        return itemStack;
    }

    public static int addEssence(ItemStack stack, int essence, ServerPlayer player) {
        CompoundTag nbt = stack.m_41698_("BlockEntityTag");
        int current = nbt.m_128451_("EssenceJarCount") + essence;
        int target = TCGConfigProxy.getConfig().getEssenceToFillJar();
        int finalCurrent = Math.min(current, target);
        nbt.m_128347_("EssenceJarPercent", Math.min(1.0, (double)finalCurrent / (double)target));
        nbt.m_128405_("EssenceJarCount", finalCurrent);
        if (!nbt.m_128441_("EssenceJarColorRed")) {
            DyeColor dyeColor = RandomHelper.getRandomElementFromArray(DyeColor.values());
            Color color = new Color(dyeColor.m_41071_());
            nbt.m_128405_("EssenceJarColorRed", color.getRed());
            nbt.m_128405_("EssenceJarColorGreen", color.getGreen());
            nbt.m_128405_("EssenceJarColorBlue", color.getBlue());
            nbt.m_128359_("EssenceJarColorName", Component.Serializer.m_130703_((Component)Component.m_237115_((String)("color.minecraft." + dyeColor.m_41065_()))));
        }
        Color color = new Color(nbt.m_128451_("EssenceJarColorRed"), nbt.m_128451_("EssenceJarColorGreen"), nbt.m_128451_("EssenceJarColorBlue"));
        TCGServerEventListeners.playEssenceJarEffect(finalCurrent, essence, current, target, player.m_284548_(), player.m_20183_().m_7918_(0, 1, 0), color);
        return Math.max(0, current - target);
    }

    public void m_5871_(ItemStack itemStack, BlockGetter blockGetter, List<Component> lore, TooltipFlag flag) {
        MutableComponent ftc;
        super.m_5871_(itemStack, blockGetter, lore, flag);
        CompoundTag nbt = itemStack.m_41698_("BlockEntityTag");
        if (nbt.m_128441_("EssenceJarColorName") && (ftc = Component.Serializer.m_130701_((String)nbt.m_128461_("EssenceJarColorName"))) != null) {
            lore.add((Component)ftc.m_130940_(ChatFormatting.GRAY));
        }
        lore.add((Component)Component.m_237110_((String)"block.tcg.essence_jar.lore", (Object[])new Object[]{(int)(nbt.m_128459_("EssenceJarPercent") * 100.0)}).m_130940_(ChatFormatting.GRAY));
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        BlockEntity te;
        if (TCGConfigProxy.getConfig().shouldRandomTickGainEssence() && (te = serverLevel.m_7702_(blockPos)) instanceof EssenceJarTileEntity) {
            ((EssenceJarTileEntity)te).addEssence(1);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CONTENTS});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)CONTENTS, (Comparable)Boolean.valueOf(false));
    }

    public ItemStack m_7397_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        ItemStack itemStack = super.m_7397_(blockGetter, blockPos, blockState);
        BlockEntity te = blockGetter.m_7702_(blockPos);
        if (te instanceof EssenceJarTileEntity) {
            ((EssenceJarTileEntity)te).applyValuesToItem(itemStack);
        }
        return itemStack;
    }

    public List<ItemStack> m_49635_(BlockState p_287732_, LootParams.Builder context) {
        ArrayList drops = Lists.newArrayList();
        ItemStack stack = new ItemStack((ItemLike)BlockRegistration.ESSENCE_JAR.get());
        BlockEntity te = (BlockEntity)context.m_287159_(LootContextParams.f_81462_);
        if (te instanceof EssenceJarTileEntity) {
            ((EssenceJarTileEntity)te).applyValuesToItem(stack);
        }
        drops.add(stack);
        return drops;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity te;
        if (placer instanceof ServerPlayer && (te = worldIn.m_7702_(pos)) instanceof EssenceJarTileEntity) {
            EssenceJarTileEntity jar = (EssenceJarTileEntity)te;
            if (!jar.setValuesFromItem(stack)) {
                jar.setColor(RandomHelper.getRandomElementFromArray(DyeColor.values()));
            }
            jar.m_6596_();
        }
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPE;
    }

    public VoxelShape getVisualShape(BlockState p_230322_1_, LevelReader p_230322_2_, BlockPos p_230322_3_, CollisionContext p_230322_4_) {
        return Shapes.m_83040_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState p_220080_1_, LevelReader p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState p_49928_, BlockGetter p_49929_, BlockPos p_49930_) {
        return true;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity te = level.m_7702_(pos);
        if (te instanceof EssenceJarTileEntity) {
            EssenceJarTileEntity jar = (EssenceJarTileEntity)te;
            return Mth.m_14045_((int)((int)(jar.getFillPercentDirect() * 16.0)), (int)0, (int)15);
        }
        return 0;
    }

    public RenderShape m_7514_(BlockState p_149645_1_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new EssenceJarTileEntity(blockPos, blockState);
    }
}

