/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.block;

import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.tcg.api.accessors.TCGItems;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.util.helper.LogicHelper;
import com.pixelmonmod.tcg.api.util.helper.NetworkHelper;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.init.registry.TileEntityRegistration;
import com.pixelmonmod.tcg.item.DeckItem;
import com.pixelmonmod.tcg.item.RulebookItem;
import com.pixelmonmod.tcg.item.ShadowWandItem;
import com.pixelmonmod.tcg.network.packets.battles.TCGGuiClientPacket;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import com.pixelmonmod.tcg.tileentity.BattleRuleOwnedTileEntity;
import com.pixelmonmod.tcg.tileentity.ServerOwnedTileEntityBattleController;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BattleControllerBlock
extends GenericRotatableModelBlock {
    public static final BooleanProperty ON = BooleanProperty.m_61465_((String)"on");
    private float scale;

    public BattleControllerBlock(String name, float scale) {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 10.0f));
        this.scale = scale;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ON, (Comparable)Boolean.valueOf(false)));
    }

    public float getScale() {
        return this.scale;
    }

    @Override
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new ServerOwnedTileEntityBattleController(p_153215_, p_153216_);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    @Override
    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (worldIn.f_46443_ || !(placer instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)placer;
        if (player.m_150109_() == null) {
            return;
        }
        for (ItemStack items : player.m_150109_().f_35974_) {
            if (items == null || items.m_41720_() != TCGItems.rulebook || !items.m_41782_() || worldIn.m_7702_(pos) == null) continue;
            CompoundTag tag = items.m_41783_();
            BattleRuleOwnedTileEntity te = (BattleRuleOwnedTileEntity)worldIn.m_7702_(pos);
            te.setDeckSize(tag.m_128451_("DeckSize"));
            te.setPrizeCount(tag.m_128451_("PrizeCount"));
            te.setTimeLimit(tag.m_128451_("TimeLimit"));
            te.setEloMinimum(tag.m_128451_("EloMinimum"));
            te.setStartingCommand(tag.m_128461_("StartingCommand"));
            te.setEndingCommand(tag.m_128461_("EndingCommand"));
            te.setStartingMessage(tag.m_128461_("StartingMessage"));
            te.setEndingMessage(tag.m_128461_("EndingMessage"));
            player.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.AQUA + "Placed BattleBox with following rules:")));
            player.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.LIGHT_PURPLE + "Deck size: " + ChatFormatting.WHITE + tag.m_128451_("DeckSize"))));
            player.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.LIGHT_PURPLE + "Prize count: " + ChatFormatting.WHITE + tag.m_128451_("PrizeCount"))));
            player.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.LIGHT_PURPLE + "Turn time limit: " + ChatFormatting.WHITE + tag.m_128451_("TimeLimit"))));
            player.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.LIGHT_PURPLE + "Elo requirement: " + ChatFormatting.WHITE + tag.m_128451_("EloMinimum"))));
            player.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.LIGHT_PURPLE + "Starting command: " + ChatFormatting.WHITE + tag.m_128461_("StartingCommand"))));
            player.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.LIGHT_PURPLE + "Ending command: " + ChatFormatting.WHITE + tag.m_128461_("EndingCommand"))));
            player.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.LIGHT_PURPLE + "Starting message: " + ChatFormatting.WHITE + tag.m_128461_("StartingMessage"))));
            player.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.LIGHT_PURPLE + "Ending message: " + ChatFormatting.WHITE + tag.m_128461_("EndingMessage"))));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult HitResult2) {
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        player.m_20256_(Vec3.f_82478_);
        BattleOwnedTileEntityController bc = (BattleOwnedTileEntityController)world.m_7702_(pos);
        if (player.m_21120_(hand) != ItemStack.f_41583_ && player.m_21120_(hand).m_41720_() instanceof RulebookItem) {
            if (player.m_21120_(hand).m_41782_() && world.m_7702_(pos) != null) {
                CompoundTag tag = player.m_21120_(hand).m_41783_();
                bc.setDeckSize(tag.m_128451_("DeckSize"));
                bc.setPrizeCount(tag.m_128451_("PrizeCount"));
                bc.setTimeLimit(tag.m_128451_("TimeLimit"));
                bc.setEloMinimum(tag.m_128451_("EloMinimum"));
                bc.setStartingCommand(tag.m_128461_("StartingCommand"));
                bc.setEndingCommand(tag.m_128461_("EndingCommand"));
                bc.setStartingMessage(tag.m_128461_("StartingMessage"));
                bc.setEndingMessage(tag.m_128461_("EndingMessage"));
                player.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.AQUA + "Updated BattleBox with following rules:")));
                player.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.LIGHT_PURPLE + "Deck size: " + ChatFormatting.WHITE + tag.m_128451_("DeckSize"))));
                player.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.LIGHT_PURPLE + "Prize count: " + ChatFormatting.WHITE + tag.m_128451_("PrizeCount"))));
                player.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.LIGHT_PURPLE + "Turn time limit: " + ChatFormatting.WHITE + tag.m_128451_("TimeLimit"))));
                player.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.LIGHT_PURPLE + "Elo requirement: " + ChatFormatting.WHITE + tag.m_128451_("EloMinimum"))));
                player.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.LIGHT_PURPLE + "Starting command: " + ChatFormatting.WHITE + tag.m_128461_("StartingCommand"))));
                player.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.LIGHT_PURPLE + "Ending command: " + ChatFormatting.WHITE + tag.m_128461_("EndingCommand"))));
                player.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.LIGHT_PURPLE + "Starting message: " + ChatFormatting.WHITE + tag.m_128461_("StartingMessage"))));
                player.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.LIGHT_PURPLE + "Ending message: " + ChatFormatting.WHITE + tag.m_128461_("EndingMessage"))));
            }
            return InteractionResult.PASS;
        }
        if (bc != null) {
            GameServerState server = bc.getGameServer();
            if (server == null) {
                return InteractionResult.PASS;
            }
            ServerPlayer p = (ServerPlayer)player;
            boolean joined = false;
            for (int i = 0; i < 2; ++i) {
                if (server.getPlayer(i) == null || !server.getPlayer(i).getEntityPlayer().m_36316_().getId().equals(p.m_36316_().getId())) continue;
                server.getPlayer(i).setEntityPlayer((Player)p);
                server.getPlayer(i).setInGUI(true);
                joined = true;
                NetworkHelper.sendPacket(new TCGGuiClientPacket(pos, i, false), p);
                break;
            }
            if (!joined) {
                if (server.isGameInProgress()) {
                    int playerIndex = 0;
                    NetworkHelper.sendPacket(new TCGGuiClientPacket(pos, playerIndex, true), p);
                    server.getSpectators().put(p.m_20148_(), playerIndex);
                    return InteractionResult.SUCCESS;
                }
                if (player.m_21120_(hand) != null && player.m_21120_(hand).m_41720_() instanceof ShadowWandItem) {
                    bc.toggleShadowGame();
                    if (bc.isShadowGame()) {
                        ChatHandler.sendFormattedChat((CommandSource)player, ChatFormatting.DARK_PURPLE, "Dark powers now dwell in this BattleBox.", new Object[0]);
                    } else {
                        ChatHandler.sendFormattedChat((CommandSource)player, ChatFormatting.DARK_PURPLE, "Dark powers no longer dwell in this BattleBox.", new Object[0]);
                    }
                    return InteractionResult.PASS;
                }
                if (player.m_21120_(hand) == null || !(player.m_21120_(hand).m_41720_() instanceof DeckItem)) {
                    ChatHandler.sendFormattedChat((CommandSource)player, ChatFormatting.RED, "You have to hold a deck to join!", new Object[0]);
                    return InteractionResult.PASS;
                }
                List<ImmutableCard> cards = LogicHelper.getCards(player, player.m_21120_(hand));
                String error = LogicHelper.validateDeck(cards, bc.getDeckSize());
                if (error != null) {
                    ChatHandler.sendFormattedChat((CommandSource)player, ChatFormatting.RED, error, new Object[0]);
                    return InteractionResult.PASS;
                }
                for (int i = 0; i < 2; ++i) {
                    if (server.getPlayer(i) != null) continue;
                    server.setPlayer(i, new PlayerServerState((Player)p));
                    joined = true;
                    NetworkHelper.sendPacket(new TCGGuiClientPacket(pos, i, false), p);
                    break;
                }
            }
            if (!joined) {
                ChatHandler.sendFormattedChat((CommandSource)p, ChatFormatting.RED, "BattleBox is busy!", new Object[0]);
            }
            world.m_7260_(pos, state, (BlockState)state.m_61124_((Property)ON, (Comparable)Boolean.valueOf(server.isGameInProgress())), 3);
            return joined ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ON});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BattleControllerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TileEntityRegistration.BATTLE_CONTROLLER.get()), ServerOwnedTileEntityBattleController::tick);
    }
}

