/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.util.helper;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.util.TargetPoint;
import com.pixelmonmod.tcg.TCG;
import com.pixelmonmod.tcg.network.data.TCGPacket;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class NetworkHelper {
    public static void sendPacket(TCGPacket packet, ServerPlayer serverPlayer) {
        TCG.network.send((Object)packet, PacketDistributor.PLAYER.with((Object)serverPlayer));
        if (Pixelmon.LOG_PACKETS) {
            TCG.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
        }
    }

    public static void sendPacket(ServerPlayer serverPlayer, TCGPacket packet) {
        TCG.network.send((Object)packet, PacketDistributor.PLAYER.with((Object)serverPlayer));
        if (Pixelmon.LOG_PACKETS) {
            TCG.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
        }
    }

    public static void sendNearbyPacket(TCGPacket packet, PacketDistributor.TargetPoint targetPoint) {
        TCG.network.send((Object)packet, PacketDistributor.NEAR.with((Object)targetPoint));
        if (Pixelmon.LOG_PACKETS) {
            TCG.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
        }
    }

    public static void sendNearbyPacket(PacketDistributor.TargetPoint targetPoint, TCGPacket packet) {
        TCG.network.send((Object)packet, PacketDistributor.NEAR.with((Object)targetPoint));
        if (Pixelmon.LOG_PACKETS) {
            TCG.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
        }
    }

    public static void sendNearbyPacket(TargetPoint targetPoint, Function<ServerPlayer, TCGPacket> packetFunction) {
        double radiusSq = targetPoint.getRadius() * targetPoint.getRadius();
        List players = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_();
        for (int i = 0; i < players.size(); ++i) {
            double d2;
            double d1;
            double d0;
            ServerPlayer player = (ServerPlayer)players.get(i);
            if (player.m_9236_().m_46472_() != targetPoint.getDimension() || !((d0 = targetPoint.getX() - player.m_20185_()) * d0 + (d1 = targetPoint.getY() - player.m_20186_()) * d1 + (d2 = targetPoint.getZ() - player.m_20189_()) * d2 < radiusSq)) continue;
            NetworkHelper.sendPacket(player, packetFunction.apply(player));
        }
    }

    public static void sendToDimension(TCGPacket packet, Level level) {
        TCG.network.send((Object)packet, PacketDistributor.DIMENSION.with((Object)level.m_46472_()));
        if (Pixelmon.LOG_PACKETS) {
            TCG.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
        }
    }

    public static void sendToAllTracking(TCGPacket packet, Entity entity) {
        TCG.network.send((Object)packet, PacketDistributor.TRACKING_ENTITY.with((Object)entity));
        if (Pixelmon.LOG_PACKETS) {
            TCG.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
        }
    }

    public static void sendToAll(TCGPacket packet) {
        TCG.network.send((Object)packet, PacketDistributor.ALL.noArg());
        if (Pixelmon.LOG_PACKETS) {
            TCG.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
        }
    }

    public static void sendToServer(TCGPacket packet) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            TCG.network.send((Object)packet, PacketDistributor.SERVER.noArg());
            if (Pixelmon.LOG_PACKETS) {
                TCG.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
            }
        }
    }
}

