/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.util.helper;

import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.accessors.TCGItems;
import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.PlayerClientMyState;
import com.pixelmonmod.tcg.duel.state.PlayerCommonState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.item.DeckItem;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class LogicHelper {
    public static List<ImmutableCard> getCardsAndCosmetics(ItemStack itemStack, PlayerServerState self) {
        List<ImmutableCard> deck = LogicHelper.getCards(self.getEntityPlayer(), itemStack);
        Tuple<String, String> cosmetics = LogicHelper.getCosmetics(self.getEntityPlayer(), itemStack);
        if (!((String)cosmetics.m_14418_()).isEmpty()) {
            self.setCardBack((String)cosmetics.m_14418_());
        }
        if (!((String)cosmetics.m_14419_()).isEmpty()) {
            self.setCoinSet((String)cosmetics.m_14419_());
        }
        return deck;
    }

    public static List<ImmutableCard> getCards(Player player, ItemStack itemStack) {
        DeckItem.Deck deck;
        ArrayList<ImmutableCard> cards = new ArrayList<ImmutableCard>();
        if (itemStack.m_41782_() && (deck = DeckItem.Deck.readFromItemStack(player, itemStack)) != null) {
            for (int i = 0; i < 60; ++i) {
                ItemStack card = deck.inventory.m_8020_(i);
                if (card.m_41619_() || !card.m_41782_()) continue;
                cards.add(Cards.fromNBT(card.m_41783_()));
            }
        }
        return cards;
    }

    public static Tuple<String, String> getCosmetics(Player player, ItemStack itemStack) {
        DeckItem.Deck deck;
        String cardBack = "";
        String coin = "";
        if (itemStack.m_41782_() && (deck = DeckItem.Deck.readFromItemStack(player, itemStack)) != null) {
            ItemStack coinItem;
            ItemStack cardBackItem = deck.inventory.m_8020_(60);
            if (!cardBackItem.m_41619_() && cardBackItem.m_41782_()) {
                cardBack = cardBackItem.m_41783_().m_128461_("CardBackID");
            }
            if (!(coinItem = deck.inventory.m_8020_(61)).m_41619_() && coinItem.m_41782_()) {
                coin = coinItem.m_41783_().m_128461_("CoinID");
            }
        }
        return new Tuple((Object)cardBack, (Object)coin);
    }

    public static List<ImmutableCard> getCards(List<ItemStack> items) {
        ArrayList<ImmutableCard> deck = new ArrayList<ImmutableCard>();
        for (ItemStack item : items) {
            CompoundTag tag;
            if (item == null || item.m_41720_() != TCGItems.card || !item.m_41782_() || (tag = item.m_41783_()) == null) continue;
            deck.add(Cards.fromNBT(tag));
        }
        return deck;
    }

    public static ResourceLocation validateDeckInHolder(List<ImmutableCard> cards) {
        ResourceLocation red = new ResourceLocation("tcg", "gui/deck/red.png");
        ResourceLocation amber = new ResourceLocation("tcg", "gui/deck/amber.png");
        ResourceLocation green = new ResourceLocation("tcg", "gui/deck/green.png");
        if (!cards.stream().anyMatch(c -> c.getCardType() == CardType.BASIC) && !cards.stream().anyMatch(c -> c.getCardType() == CardType.EX)) {
            return red;
        }
        List nonEnergy = cards.stream().filter(c -> c.getCardType() != CardType.ENERGY || c.getSecondaryEnergy() != null).map(c -> Component.m_237115_((String)c.getName().toLowerCase())).collect(Collectors.toList());
        Component previousName = null;
        int count = 0;
        int maxCount = 4;
        for (Component name : nonEnergy) {
            count = name.equals(previousName) ? ++count : 1;
            if (count > maxCount) {
                return red;
            }
            previousName = name;
        }
        if (cards.size() != 60) {
            return amber;
        }
        return green;
    }

    public static String validateDeck(List<ImmutableCard> cards, int deckSize) {
        if (cards.size() != deckSize) {
            return "You need to have " + deckSize + " cards in the deck!";
        }
        if (!cards.stream().anyMatch(c -> c.getCardType() == CardType.BASIC) && !cards.stream().anyMatch(c -> c.getCardType() == CardType.EX)) {
            return "You need at least a basic Pokemon card!";
        }
        List nonEnergy = cards.stream().filter(c -> c.getCardType() != CardType.ENERGY || c.getSecondaryEnergy() != null).map(c -> Component.m_237115_((String)c.getName().toLowerCase())).collect(Collectors.toList());
        Component previousName = null;
        int count = 0;
        int maxCount = 4;
        for (Component name : nonEnergy) {
            count = name.equals(previousName) ? ++count : 1;
            if (count > maxCount) {
                return "You have more than " + maxCount + " '" + name + "' card!";
            }
            previousName = name;
        }
        return null;
    }

    public static void shuffleCardList(List<ImmutableCard> cards) {
        Collections.shuffle(cards);
    }

    public static boolean isEnoughEnergy(CardAttack cardAttack, List<CommonCardState> attachments, PokemonCardState pokemon) {
        ArrayList<Energy> energyRequirements = new ArrayList<Energy>(cardAttack.getCosts());
        return LogicHelper.isEnoughEnergy(energyRequirements, attachments, pokemon);
    }

    public static boolean isEnoughEnergy(int count, List<CommonCardState> attachments, PokemonCardState pokemon) {
        ArrayList<Energy> energyRequirements = new ArrayList<Energy>();
        for (int x = 0; x < count; ++x) {
            energyRequirements.add(Energy.COLORLESS);
        }
        return LogicHelper.isEnoughEnergy(energyRequirements, attachments, pokemon);
    }

    public static boolean isEnoughEnergy(List<Energy> energyRequirements, List<CommonCardState> attachments, PokemonCardState pokemon) {
        ImmutableCard card;
        int unmarked = 0;
        for (CommonCardState attachment : attachments) {
            List<CommonCardState> energyEquivalence;
            card = attachment.getData();
            if (card.getCardType() == CardType.ENERGY) {
                if (!LogicHelper.removeEnergyRequirement(energyRequirements, attachment.getMainEnergy(), pokemon)) {
                    ++unmarked;
                }
                if (attachment.getSecondaryEnergy() == null || LogicHelper.removeEnergyRequirement(energyRequirements, attachment.getSecondaryEnergy(), pokemon)) continue;
                ++unmarked;
                continue;
            }
            if (!pokemon.getData().isPokemonCard() || pokemon.getAbility() == null || pokemon.getAbility().getEffect() == null || (energyEquivalence = pokemon.getAbility().getEffect().getEnergyEquivalence(attachment)) == null) continue;
            for (CommonCardState energy : energyEquivalence) {
                if (LogicHelper.removeEnergyRequirement(energyRequirements, energy.getMainEnergy(), pokemon)) continue;
                ++unmarked;
            }
        }
        for (CommonCardState attachment : attachments) {
            card = attachment.getData();
            if (card.getCardType() != CardType.ENERGY) continue;
            if (card.getMainEnergy() == Energy.RAINBOW && !energyRequirements.isEmpty() && unmarked > 0) {
                energyRequirements.remove(0);
                --unmarked;
            }
            if (card.getSecondaryEnergy() != Energy.RAINBOW || energyRequirements.isEmpty() || unmarked <= 0) continue;
            energyRequirements.remove(0);
        }
        while (unmarked > 0 && energyRequirements.size() > 0 && energyRequirements.get(0) == Energy.COLORLESS) {
            --unmarked;
            energyRequirements.remove(0);
        }
        return energyRequirements.isEmpty();
    }

    public static boolean canEvolve(int cardTurn, int currentTurn) {
        return currentTurn > 1 && cardTurn < currentTurn;
    }

    private static boolean removeEnergyRequirement(List<Energy> energies, Energy energy, PokemonCardState pokemon) {
        for (int i = 0; i < energies.size(); ++i) {
            if (energy == Energy.RAINBOW || energies.get(i) != energy && (pokemon.getAbility() == null || pokemon.getAbility().getEffect() == null || !pokemon.getAbility().getEffect().ignoreEnergyTypes()) && (pokemon.getHiddenAbility() == null || pokemon.getHiddenAbility().getEffect() == null || !pokemon.getHiddenAbility().getEffect().ignoreEnergyTypes())) continue;
            energies.remove(i);
            return true;
        }
        return false;
    }

    public static List<CardWithLocation> getEnergiesFromList(List<CommonCardState> cards) {
        ArrayList<CardWithLocation> tempList = new ArrayList<CardWithLocation>();
        cards.stream().filter(card -> card.isEnergyEquivalence()).forEach(card -> {
            CardWithLocation card2 = new CardWithLocation();
            card2.set((CommonCardState)card, true, BoardLocation.Attachment, 0);
            tempList.add(card2);
        });
        return tempList;
    }

    public static boolean hasBench(PlayerClientMyState player) {
        for (PokemonCardState bench : player.getBenchCards()) {
            if (bench == null) continue;
            return true;
        }
        return false;
    }

    public static PokemonCardState evolveCard(ImmutableCard card, PokemonCardState activeCard, int turnCount) {
        PokemonCardState newCard = new PokemonCardState(card, turnCount);
        newCard.getAttachments().add(activeCard);
        newCard.getAttachments().addAll(activeCard.getAttachments());
        newCard.getStatus().setDamage(activeCard.getStatus().getDamage());
        activeCard.getAttachments().clear();
        activeCard.getStatus().setDamage(0);
        activeCard.getStatus().getConditions().clear();
        return newCard;
    }

    public static int getCostModifier(PlayerCommonState me, PlayerCommonState opp) {
        int costModifier = 0;
        if (me != null) {
            for (PokemonCardState pokemon : me.getActiveAndBenchCards()) {
                if (pokemon.getAbility() == null || pokemon.getAbility().getEffect() == null) continue;
                costModifier += pokemon.getAbility().getEffect().retreatModifier(pokemon, me);
            }
        }
        if (opp != null) {
            for (PokemonCardState pokemon : opp.getActiveAndBenchCards()) {
                if (pokemon.getAbility() == null || pokemon.getAbility().getEffect() == null) continue;
                costModifier += pokemon.getAbility().getEffect().retreatModifier(pokemon, me);
            }
        }
        return costModifier;
    }
}

