/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.typeadapters;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.ThemeDeck;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ThemeDeckTypeAdapter
implements JsonSerializer<ThemeDeck>,
JsonDeserializer<ThemeDeck> {
    public ThemeDeck deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        int id = object.getAsJsonPrimitive("id").getAsInt();
        String name = object.getAsJsonPrimitive("name").getAsString();
        List<ImmutableCard> cards = this.getCardsFromJSONArray(object.getAsJsonArray("cards"));
        List<ImmutableCard> extraCards = this.getCardsFromJSONArray(object.getAsJsonArray("extraCards"));
        return new ThemeDeck(id, name, cards, extraCards, object.toString());
    }

    public JsonElement serialize(ThemeDeck src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        JsonArray cards = new JsonArray();
        JsonArray extraCards = new JsonArray();
        for (ImmutableCard card : src.getCards()) {
            cards.add(card.getCode());
        }
        for (ImmutableCard card : src.getExtraCards()) {
            cards.add(card.getCode());
        }
        object.addProperty("id", (Number)src.getID());
        object.addProperty("name", src.getName());
        object.add("cards", (JsonElement)cards);
        object.add("extraCards", (JsonElement)extraCards);
        return object;
    }

    protected List<ImmutableCard> getCardsFromJSONArray(JsonArray cardsArray) {
        ArrayList cards = Lists.newArrayList();
        for (JsonElement jsonElement : cardsArray) {
            cards.add(Cards.fromCode(jsonElement.getAsString()));
        }
        return cards;
    }
}

