/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.events;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class PackOpenEvent
extends Event {
    protected final ServerPlayer player;
    protected final ItemStack packItem;
    protected ImmutableCard[] cards;

    public PackOpenEvent(ServerPlayer player, ItemStack packItem, ImmutableCard[] cards) {
        this.player = player;
        this.packItem = packItem;
        this.cards = cards;
        if (Pixelmon.isDevEnvironment()) {
            for (ImmutableCard card : cards) {
                Pixelmon.LOGGER.warn("Pack contained card: " + card.getName());
            }
        }
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public ItemStack getPackItem() {
        return this.packItem;
    }

    public ImmutableCard[] getCards() {
        return this.cards;
    }

    public static class Post
    extends PackOpenEvent {
        public Post(ServerPlayer player, ItemStack packItem, ImmutableCard[] cards) {
            super(player, packItem, cards);
        }
    }

    @Cancelable
    public static class Pre
    extends PackOpenEvent {
        public Pre(ServerPlayer player, ItemStack packItem, ImmutableCard[] cards) {
            super(player, packItem, cards);
        }

        public void getCards(ImmutableCard[] cards) {
            this.cards = cards;
        }
    }
}

