/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.card.attack;

import com.google.common.collect.Lists;
import com.pixelmonmod.tcg.TCG;
import com.pixelmonmod.tcg.api.accessors.AttackEffects;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.attack.enums.CoinSide;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CardAttackEffectParser {
    public static List<BaseAttackEffect> parseEffects(String effectsString) {
        ArrayList effects = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)effectsString)) {
            for (String data : effectsString.split(" ")) {
                BaseAttackEffect effect = CardAttackEffectParser.parseEffect(data);
                if (effect == null) continue;
                effects.add(effect);
            }
        }
        return effects;
    }

    public static BaseAttackEffect parseEffect(String data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        CoinSide needCoinSide = null;
        boolean isOptional = false;
        if (data.startsWith("HEAD-")) {
            needCoinSide = CoinSide.Head;
            data = data.substring(5);
        } else if (data.startsWith("TAIL-")) {
            needCoinSide = CoinSide.Tail;
            data = data.substring(5);
        } else if (data.startsWith("OPTIONAL-")) {
            isOptional = true;
            data = data.substring(9);
        }
        String[] parameters = data.split(":");
        String code = parameters[0];
        BaseAttackEffect baseAttackEffect = AttackEffects.get(code);
        if (baseAttackEffect == null) {
            TCG.LOGGER.debug("Couldn't find attack effect with code: " + code);
            return null;
        }
        return baseAttackEffect.setOptional(isOptional).setRequiredCoinSide(needCoinSide).parse(parameters);
    }
}

