/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.card.attack;

import com.google.common.collect.Lists;
import com.pixelmonmod.tcg.api.card.CardModifier;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.api.card.attack.CardAttackEffectParser;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import java.util.List;
import java.util.Locale;
import net.minecraft.network.chat.Component;

public class CardAttack {
    private final String name;
    private final List<Energy> costs;
    private final int damage;
    private final CardModifier modifier;
    private final String text;
    private final String effectsString;
    private final transient List<BaseAttackEffect> effects = Lists.newArrayList();
    private transient String id;

    public CardAttack(String name, List<Energy> costs, int damage, CardModifier modifier, String text, String effectsString) {
        this.name = name.toLowerCase();
        this.costs = costs;
        this.damage = damage;
        this.modifier = modifier;
        this.text = text.toLowerCase();
        this.effectsString = effectsString;
        this.effects.addAll(CardAttackEffectParser.parseEffects(effectsString));
    }

    public CardAttack(String name, List<Energy> costs, int damage, CardModifier modifier, String text, List<BaseAttackEffect> effects) {
        this.name = name.toLowerCase();
        this.costs = costs;
        this.damage = damage;
        this.modifier = modifier;
        this.text = text.toLowerCase();
        this.effectsString = "";
        this.effects.addAll(effects);
    }

    public CardAttack withEffect(BaseAttackEffect effect) {
        this.effects.add(effect);
        return this;
    }

    public void setID(String code, int index) {
        this.id = code + "#" + index;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Component getTranslatedName() {
        return Component.m_237115_((String)this.getName().toLowerCase(Locale.ROOT));
    }

    public List<Energy> getCosts() {
        return this.costs;
    }

    public int getDamage() {
        return this.damage;
    }

    public CardModifier getModifier() {
        return this.modifier;
    }

    public String getText() {
        return this.text;
    }

    public String getEffectsString() {
        return this.effectsString;
    }

    public List<BaseAttackEffect> getEffects() {
        return this.effects;
    }

    public boolean hasEffects() {
        return this.effects != null && !this.effects.isEmpty();
    }
}

