/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.card;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.init.registry.ItemRegistration;
import com.pixelmonmod.tcg.item.DeckItem;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ThemeDeck {
    private final int id;
    private final String name;
    private List<ImmutableCard> cards = Lists.newArrayList();
    private List<ImmutableCard> extraCards = Lists.newArrayList();
    private final transient String json;

    public ThemeDeck(int id, String name, List<ImmutableCard> cards, List<ImmutableCard> extraCards, String json) {
        this.id = id;
        this.name = name;
        this.cards = cards;
        this.extraCards = extraCards;
        this.json = json;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<ImmutableCard> getCards() {
        return this.cards;
    }

    public List<ImmutableCard> getExtraCards() {
        return this.extraCards;
    }

    public Component getLocalizedName() {
        return Component.m_237115_((String)("deck." + this.getName().toLowerCase() + ".name"));
    }

    public ItemStack getItemStack(int count) {
        ItemStack itemDeck = new ItemStack((ItemLike)ItemRegistration.DECK.get(), 1);
        DeckItem.Deck deck = new DeckItem.Deck((Container)new SimpleContainer(62), false, -1);
        int i = 0;
        for (ImmutableCard card : this.getCards()) {
            try {
                deck.inventory.m_6836_(i, card.getItemStack(1));
                ++i;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Pixelmon.LOGGER.error("Theme Deck: " + this.name + " had more than 60 cards! Please remove cards till it only has 60 cards");
                break;
            }
        }
        deck.writeToStack(itemDeck);
        itemDeck.m_41764_(count);
        itemDeck.m_41714_(this.getLocalizedName());
        return itemDeck;
    }

    public ItemStack getItemStack() {
        return this.getItemStack(1);
    }

    public String getJson() {
        return this.json;
    }
}

