/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.card;

import com.pixelmonmod.api.registry.RegistryManager;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.tcg.api.accessors.TCGItems;
import com.pixelmonmod.tcg.api.card.CardModifier;
import com.pixelmonmod.tcg.api.card.CardRarity;
import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.api.card.ability.CardPower;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import java.util.List;
import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ImmutableCard {
    private static final ResourceLocation FALL_BACK_TEXTURE = new ResourceLocation("tcg", "gui/cards/foreground/fallback.png");
    @Deprecated
    public static int FACE_DOWN_ID = -1;
    public static String FACE_DOWN_CODE = "FACEDOWN";
    @Deprecated
    public static String CARD_ID_NBT_KEY = "CardID";
    public static String CARD_CODE_NBT_KEY = "CardCode";
    public static String IS_HOLO_NBT_KEY = "ReverseHolo";
    private final int id;
    private final int setId;
    private final CardType cardType;
    private final boolean isSpecial;
    private final int hp;
    private final Energy energy1;
    private final Energy energy2;
    private final int pokemonId;
    private final String code;
    private final String name;
    private final String description;
    private final int previousPokemonId;
    private final CardPower cardAbility;
    private final List<CardAttack> cardAttacks;
    private final Energy energyResistance;
    private final int resistanceValue;
    private final CardModifier resistanceCardModifier;
    private final Energy energyWeakness;
    private final int weaknessValue;
    private final CardModifier weaknessCardModifier;
    private final int retreatCost;
    private final CardRarity cardRarity;
    private final ResourceLocation customTexture;
    private final int customTextureX;
    private final int customTextureY;
    private BaseTrainerEffect effect;
    private final transient String json;
    private transient RegistryValue<ImmutableCard> registryValue = null;

    public static ImmutableCard faceDown() {
        return new ImmutableCard("{}", FACE_DOWN_ID, 0, null, false, 0, null, null, 0, FACE_DOWN_CODE, "", "", 0, null, null, null, 0, null, null, 0, null, 0, null, null, 0, 0, null);
    }

    public ImmutableCard(String json, int id, int setId, CardType cardType, boolean isSpecial, int hp, Energy energy1, Energy energy2, int pokemonId, String code, String name, String description, int previousPokemonId, CardPower cardAbility, List<CardAttack> cardAttacks, Energy energyResistance, int resistanceValue, CardModifier resistanceCardModifier, Energy energyWeakness, int weaknessValue, CardModifier weaknessCardModifier, int retreatCost, CardRarity cardRarity, ResourceLocation customTexture, int customTextureX, int customTextureY, BaseTrainerEffect effect) {
        this.json = json;
        this.id = id;
        this.setId = setId;
        this.cardType = cardType;
        this.isSpecial = isSpecial;
        this.hp = hp;
        this.energy1 = energy1;
        this.energy2 = energy2;
        this.pokemonId = pokemonId;
        this.code = code.toLowerCase();
        this.name = name.toLowerCase();
        this.description = description.toLowerCase();
        this.previousPokemonId = previousPokemonId;
        this.cardAbility = cardAbility;
        this.cardAttacks = cardAttacks;
        this.energyResistance = energyResistance;
        this.resistanceValue = resistanceValue;
        this.resistanceCardModifier = resistanceCardModifier;
        this.energyWeakness = energyWeakness;
        this.weaknessValue = weaknessValue;
        this.weaknessCardModifier = weaknessCardModifier;
        this.retreatCost = retreatCost;
        this.cardRarity = cardRarity;
        this.customTexture = customTexture;
        this.customTextureX = customTextureX;
        this.customTextureY = customTextureY;
        this.effect = effect;
    }

    public RegistryValue<ImmutableCard> getRegistryValue() {
        if (this.registryValue == null) {
            this.registryValue = RegistryManager.getRegistryValue(this);
        }
        return this.registryValue;
    }

    public String getJson() {
        return this.json;
    }

    public boolean isHolo() {
        return this.cardRarity == CardRarity.HOLORARE;
    }

    public int getID() {
        return this.id;
    }

    public boolean isFaceDown() {
        return this.code.equalsIgnoreCase(FACE_DOWN_CODE);
    }

    public int getSetID() {
        return this.setId;
    }

    public String getCode() {
        return this.code;
    }

    public int getHP() {
        return this.hp;
    }

    public CardType getCardType() {
        return this.cardType;
    }

    public boolean isSpecial() {
        return this.isSpecial;
    }

    public BaseTrainerEffect getEffect() {
        return this.effect;
    }

    public boolean isPokemonCard() {
        switch (this.cardType) {
            case BASIC: 
            case STAGE1: 
            case STAGE2: 
            case LVLX: 
            case EX: 
            case BREAK: 
            case LEGEND: 
            case MEGA: {
                return true;
            }
        }
        return false;
    }

    public boolean isEvolution() {
        switch (this.cardType) {
            case STAGE1: 
            case STAGE2: 
            case MEGA: {
                return true;
            }
        }
        return false;
    }

    public boolean isCosmetic() {
        return this.cardType.isCosmetic();
    }

    public Energy getMainEnergy() {
        return this.energy1;
    }

    public Energy getSecondaryEnergy() {
        return this.energy2;
    }

    public int getPokemonID() {
        return this.pokemonId;
    }

    public String getName() {
        return this.name;
    }

    public Component getTranslatedName() {
        return Component.m_237115_((String)this.getName().toLowerCase(Locale.ROOT));
    }

    public String getDescription() {
        return this.description;
    }

    public int getPreviousEvolutionDexID() {
        return this.previousPokemonId;
    }

    public CardPower getAbility() {
        return this.cardAbility;
    }

    public List<CardAttack> getAttacks() {
        return this.cardAttacks;
    }

    public Energy getEnergyResistance() {
        return this.energyResistance;
    }

    public int getResistanceValue() {
        return this.resistanceValue;
    }

    public CardModifier getResistanceModifier() {
        return this.resistanceCardModifier;
    }

    public Energy getEnergyWeakness() {
        return this.energyWeakness;
    }

    public int getWeaknessValue() {
        return this.weaknessValue;
    }

    public CardModifier getWeaknessModifier() {
        return this.weaknessCardModifier;
    }

    public int getRetreatCost() {
        return this.retreatCost;
    }

    public CardRarity getRarity() {
        return this.cardRarity;
    }

    public boolean getHasCustomTex() {
        return this.customTexture != null;
    }

    public ResourceLocation getCustomTexture() {
        if (this.customTexture == null) {
            if (this.getCardType() == CardType.ENERGY) {
                if (this.getMainEnergy().getHighResTexture() != null) {
                    return this.getMainEnergy().getHighResTexture();
                }
                if (this.getMainEnergy().getTexture() != null) {
                    return this.getMainEnergy().getTexture();
                }
                return FALL_BACK_TEXTURE;
            }
            return FALL_BACK_TEXTURE;
        }
        return this.customTexture;
    }

    public int getImageXFromCard() {
        return this.customTextureX;
    }

    public int getImageYFromCard() {
        return this.customTextureY;
    }

    public ItemStack getItemStack(int count) {
        ItemStack itemStack = new ItemStack((ItemLike)TCGItems.card, count);
        CompoundTag tag = new CompoundTag();
        itemStack.m_41714_(this.getTranslatedName());
        this.write(tag);
        itemStack.m_41751_(tag);
        return itemStack;
    }

    public void write(CompoundTag tag) {
        tag.m_128359_(CARD_CODE_NBT_KEY, this.code);
    }
}

