/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.card;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.tcg.client.gui.TCGResources;
import net.minecraft.resources.ResourceLocation;

public enum Energy {
    GRASS("grass", TCGResources.ENERGY_GRASS, TCGResources.ENERGY_GRASS_HD, TCGResources.ENERGY_GRASS_HDA),
    FIRE("fire", TCGResources.ENERGY_FIRE, TCGResources.ENERGY_FIRE_HD, TCGResources.ENERGY_FIRE_HDA),
    WATER("water", TCGResources.ENERGY_WATER, TCGResources.ENERGY_WATER_HD, TCGResources.ENERGY_WATER_HDA),
    LIGHTNING("lightning", TCGResources.ENERGY_LIGHTNING, TCGResources.ENERGY_LIGHTNING_HD, TCGResources.ENERGY_LIGHTNING_HDA),
    FIGHTING("fighting", TCGResources.ENERGY_FIGHTING, TCGResources.ENERGY_FIGHTING_HD, TCGResources.ENERGY_FIGHTING_HDA),
    PSYCHIC("psychic", TCGResources.ENERGY_PSYCHIC, TCGResources.ENERGY_PSYCHIC_HD, TCGResources.ENERGY_PSYCHIC_HDA),
    COLORLESS("colorless", TCGResources.ENERGY_COLORLESS, TCGResources.ENERGY_COLORLESS_HD, TCGResources.ENERGY_COLORLESS_HDA),
    DARKNESS("darkness", TCGResources.ENERGY_DARKNESS, TCGResources.ENERGY_DARKNESS_HD, TCGResources.ENERGY_DARKNESS_HDA),
    METAL("metal", TCGResources.ENERGY_METAL, TCGResources.ENERGY_METAL_HD, TCGResources.ENERGY_METAL_HDA),
    DRAGON("dragon", TCGResources.ENERGY_DRAGON, TCGResources.ENERGY_DRAGON_HD, TCGResources.ENERGY_DRAGON_HDA),
    FAIRY("fairy", TCGResources.ENERGY_FAIRY, TCGResources.ENERGY_FAIRY_HD, TCGResources.ENERGY_FAIRY_HDA),
    RAINBOW("rainbow", TCGResources.ENERGY_RAINBOW, TCGResources.ENERGY_RAINBOW_HD, TCGResources.ENERGY_RAINBOW_HDA);

    private final String unlocalizedName;
    private final ResourceLocation resourceLocation;
    private final ResourceLocation highRes;
    private final ResourceLocation highResAlt;

    private Energy(String unlocalizedName, ResourceLocation resourceLocation, ResourceLocation highRes, ResourceLocation highResAlt) {
        this.unlocalizedName = unlocalizedName;
        this.resourceLocation = resourceLocation;
        this.highRes = highRes;
        this.highResAlt = highResAlt;
    }

    public static Energy getEnergyFromString(String name) {
        for (Energy value : Energy.values()) {
            if (!value.getUnlocalizedName().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    public static Energy getEnergyFromType(Element type) {
        switch (type) {
            case NORMAL: 
            case FLYING: {
                return COLORLESS;
            }
            case FIRE: {
                return FIRE;
            }
            case WATER: 
            case ICE: {
                return WATER;
            }
            case GROUND: 
            case ROCK: 
            case FIGHTING: {
                return FIGHTING;
            }
            case POISON: 
            case PSYCHIC: {
                return PSYCHIC;
            }
            case BUG: 
            case GRASS: {
                return GRASS;
            }
            case GHOST: 
            case DARK: {
                return DARKNESS;
            }
            case STEEL: {
                return METAL;
            }
            case DRAGON: {
                return DRAGON;
            }
            case FAIRY: {
                return FAIRY;
            }
            case ELECTRIC: {
                return LIGHTNING;
            }
        }
        return COLORLESS;
    }

    public ResourceLocation getTexture() {
        return this.resourceLocation;
    }

    public ResourceLocation getHighResTexture() {
        return this.highRes;
    }

    public ResourceLocation getHighResAlt() {
        return this.highResAlt;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }
}

