/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.card;

import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.StringHelper;
import java.util.Locale;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;

public enum CardType {
    BASIC("BASIC"),
    STAGE1("STAGE1"),
    STAGE2("STAGE2"),
    MEGA("MEGA"),
    EX("EX"),
    LVLX("LVLX"),
    BREAK("BREAK"),
    LEGEND("LEGEND"),
    GX("GX"),
    TRAINER("TRAINER"),
    STADIUM("STADIUM"),
    ITEM("ITEM"),
    SUPPORTER("SUPPORTER"),
    ENERGY("ENERGY"),
    TOOL("TOOL"),
    TM("TECHNICAL MACHINE"),
    ASPEC("A-SPEC"),
    COSMETIC("COSMETIC");

    private final String name;

    private CardType(String name) {
        this.name = name;
    }

    public boolean isPokemon() {
        return this == BASIC || this == STAGE1 || this == STAGE2 || this == MEGA || this == LEGEND || this == LVLX || this == EX;
    }

    public boolean isCosmetic() {
        return this == COSMETIC;
    }

    public static CardType getCardTypeFromString(String name) {
        for (CardType value : CardType.values()) {
            if (!value.getUnlocalizedName().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    public ResourceLocation getIcon() {
        if (this.isCosmetic()) {
            return ResourceLocationHelper.of("tcg", "gui/cards/icons/cosmetic.png");
        }
        if (this == EX) {
            return ResourceLocationHelper.of("tcg", "gui/cards/icons/basic.png");
        }
        return ResourceLocationHelper.of("tcg", "gui/cards/icons/" + StringHelper.stripSpecialCharacters(this.name).replace(" ", "_") + ".png");
    }

    public String getUnlocalizedName() {
        return this.name.toLowerCase();
    }

    public String getLocalizedName() {
        return I18n.m_118938_((String)("card.types." + this.getUnlocalizedName().toLowerCase(Locale.ROOT).replace(" ", "")), (Object[])new Object[0]);
    }
}

