/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.card;

import com.google.common.collect.Lists;
import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class Card {
    private String code;
    private int grade;
    private final List<String> tags = Lists.newArrayList();
    private transient ImmutableCard base = null;

    public Card(CompoundTag nbt) {
        this.load(nbt);
    }

    public Card(FriendlyByteBuf buffer) {
        this.code = buffer.m_130277_();
        this.grade = buffer.readInt();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            this.tags.add(buffer.m_130277_());
        }
    }

    public Card(String code, int grade, String ... tags) {
        this.code = code;
        this.grade = grade;
        this.tags.addAll(Lists.newArrayList((Object[])tags));
    }

    public static Card of(ImmutableCard card) {
        return new Card(card.getCode(), 0, new String[0]);
    }

    public static Card from(ItemStack stack) {
        if (stack.m_41782_()) {
            return new Card(stack.m_41783_());
        }
        return null;
    }

    public ImmutableCard getBase() {
        if (this.base == null) {
            this.base = Cards.fromCode(this.code);
        }
        return this.base;
    }

    public boolean is(String ... tags) {
        for (String tag : tags) {
            if (!this.tags.contains(tag)) continue;
            return true;
        }
        return false;
    }

    public int getGrade() {
        return this.grade;
    }

    public void load(ItemStack itemStack) {
        this.load(itemStack.m_41783_());
    }

    public void load(CompoundTag tag) {
        this.code = tag.m_128461_("CardCode");
        this.grade = tag.m_128451_("CardGrade");
        for (Tag nbtBase : tag.m_128437_("CardTags", 8)) {
            this.tags.add(nbtBase.m_7916_());
        }
    }

    public void write(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
        }
        this.write(tag);
        itemStack.m_41751_(tag);
    }

    public void write(CompoundTag tag) {
        tag.m_128359_("CardCode", this.code);
        tag.m_128405_("CardGrade", this.grade);
        ListTag tags = new ListTag();
        for (String s : this.tags) {
            tags.add((Object)StringTag.m_129297_((String)s));
        }
        tag.m_128365_("CardTags", (Tag)tags);
    }

    public void write(FriendlyByteBuf buf) {
        ByteBufUtil.writeUtf8((ByteBuf)buf, (CharSequence)this.code);
        buf.writeInt(this.grade);
        buf.writeInt(this.tags.size());
        for (String tag : this.tags) {
            ByteBufUtil.writeUtf8((ByteBuf)buf, (CharSequence)tag);
        }
    }
}

