/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.accessors;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.ThemeDeck;
import com.pixelmonmod.tcg.api.typeadapters.DeckCardTypeAdapter;
import com.pixelmonmod.tcg.api.typeadapters.ThemeDeckTypeAdapter;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class ThemeDecks {
    private static final Map<Integer, ThemeDeck> ID_TO_THEME_DECK = new Int2ObjectOpenHashMap();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ThemeDeck.class, (Object)new ThemeDeckTypeAdapter()).registerTypeAdapter(ImmutableCard.class, (Object)new DeckCardTypeAdapter()).create();

    public static void register(Gson gson, ResourceLocation rl, JsonElement json) {
        ThemeDecks.register((ThemeDeck)gson.fromJson(json, ThemeDeck.class));
    }

    public static void register(ThemeDeck themeDeck) {
        RegistryValue.of(ThemeDeck.class, themeDeck.getName(), themeDeck);
        ID_TO_THEME_DECK.put(themeDeck.getID(), themeDeck);
    }

    public static ThemeDeck get(String name) {
        return RegistryValue.of(ThemeDeck.class, name).getValueUnsafe();
    }

    public static ThemeDeck get(int id) {
        return ID_TO_THEME_DECK.get(id);
    }

    public static List<ThemeDeck> getAll() {
        return Lists.newArrayList(ID_TO_THEME_DECK.values());
    }

    public static ThemeDeck getRandom() {
        return RandomHelper.getRandomElementFromCollection(ThemeDecks.getAll());
    }
}

