/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.accessors;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.pixelmonmod.api.registry.RegistryManager;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters.ResourceLocationTypeAdapter;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.tcg.api.accessors.CardAttacks;
import com.pixelmonmod.tcg.api.accessors.CardPowers;
import com.pixelmonmod.tcg.api.card.CardRarity;
import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.ability.CardPower;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.api.typeadapters.BaseAttackEffectTypeAdapter;
import com.pixelmonmod.tcg.api.typeadapters.BasePowerEffectTypeAdapter;
import com.pixelmonmod.tcg.api.typeadapters.BaseTrainerEffectTypeAdapter;
import com.pixelmonmod.tcg.api.typeadapters.CardAttackTypeAdapter;
import com.pixelmonmod.tcg.api.typeadapters.CardPowerTypeAdapter;
import com.pixelmonmod.tcg.api.typeadapters.ImmutableCardTypeAdapter;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.power.BasePowerEffect;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class Cards {
    private static final Map<Energy, ImmutableCard> ENERGY_CARDS = Maps.newHashMap();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ImmutableCard.class, (Object)new ImmutableCardTypeAdapter()).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocationTypeAdapter()).registerTypeAdapter(CardAttack.class, (Object)new CardAttackTypeAdapter()).registerTypeAdapter(CardPower.class, (Object)new CardPowerTypeAdapter()).registerTypeAdapter(BaseAttackEffect.class, (Object)new BaseAttackEffectTypeAdapter()).registerTypeAdapter(BasePowerEffect.class, (Object)new BasePowerEffectTypeAdapter()).registerTypeAdapter(BaseTrainerEffect.class, (Object)new BaseTrainerEffectTypeAdapter()).serializeNulls().create();

    public static void register(Gson gson, ResourceLocation rl, JsonElement json) {
        Cards.register((ImmutableCard)gson.fromJson(json, ImmutableCard.class));
    }

    public static void register(ImmutableCard card) {
        RegistryManager.register(card.getCode(), card);
        for (CardAttack attack : card.getAttacks()) {
            CardAttacks.register(attack);
        }
        CardPowers.register(card.getAbility());
        if (card.getCardType() == CardType.ENERGY && !card.isSpecial()) {
            ENERGY_CARDS.put(card.getMainEnergy(), card);
        }
    }

    public static List<ImmutableCard> getAll() {
        return Lists.newArrayList(RegistryManager.getAllValues(ImmutableCard.class));
    }

    public static ImmutableCard getRandomCard(Energy energy) {
        ArrayList choices = Lists.newArrayList();
        for (ImmutableCard card : Cards.getAll()) {
            if (card.getCardType() != CardType.ENERGY || card.getMainEnergy() != energy && card.getSecondaryEnergy() != energy) continue;
            choices.add(card);
        }
        if (choices.isEmpty()) {
            return null;
        }
        return (ImmutableCard)RandomHelper.getRandomElementFromCollection(choices);
    }

    public static ImmutableCard getRandomBasicEnergyCard() {
        return RandomHelper.getRandomElementFromCollection(Cards.getEnergyCards());
    }

    public static ImmutableCard getRareOrBetterCard(int setID, float weight, boolean isHolo) {
        List<ImmutableCard> eligible = Cards.getCardsInRarities(setID, Sets.newHashSet((Object[])new CardRarity[]{CardRarity.RARE, CardRarity.HOLORARE, CardRarity.ULTRARARE, CardRarity.SECRETRARE}));
        if (eligible.isEmpty()) {
            return null;
        }
        for (int attempts = 0; attempts < 100; ++attempts) {
            ImmutableCard c = RandomHelper.getRandomElementFromCollection(eligible);
            float randFloat = RandomHelper.getRandom().nextFloat();
            if (weight / 60.0f > randFloat && c.getRarity() == CardRarity.SECRETRARE) {
                return c;
            }
            if (weight / 30.0f > randFloat && c.getRarity() == CardRarity.ULTRARARE) {
                return c;
            }
            if (!(weight / 3.0f > randFloat) || c.getRarity() != CardRarity.HOLORARE) continue;
            return c;
        }
        return null;
    }

    public static List<ImmutableCard> getCardsInRarities(int setID, Set<CardRarity> rarities) {
        ArrayList<ImmutableCard> eligible = new ArrayList<ImmutableCard>();
        for (ImmutableCard card : Cards.getAll()) {
            if (!rarities.contains((Object)card.getRarity()) && !rarities.isEmpty() || setID != 0 && card.getSetID() != setID) continue;
            eligible.add(card);
        }
        return eligible;
    }

    public static ImmutableCard getRandomCardOfRarity(int setID, CardRarity cardRarity, boolean isHolo) {
        return RandomHelper.getRandomElementFromCollection(Cards.getCardsInRarities(setID, Sets.newHashSet((Object[])new CardRarity[]{cardRarity})));
    }

    public static ImmutableCard getRandomCard() {
        return RandomHelper.getRandomElementFromCollection(Cards.getAll());
    }

    public static List<ImmutableCard> getEnergyCards() {
        return Lists.newArrayList(ENERGY_CARDS.values());
    }

    public static ImmutableCard getEnergyCard(Energy energy) {
        return ENERGY_CARDS.get((Object)energy);
    }

    public static ImmutableCard fromPokemonID(int pokemonID) {
        if (pokemonID == -1) {
            return null;
        }
        for (ImmutableCard value : Cards.getAll()) {
            if (value.getPokemonID() != pokemonID) continue;
            return value;
        }
        return null;
    }

    public static ImmutableCard fromCode(String code) {
        return RegistryValue.of(ImmutableCard.class, code.toLowerCase()).getValueUnsafe();
    }

    public static ImmutableCard fromNBT(CompoundTag tag) {
        return Cards.fromCode(tag.m_128461_(ImmutableCard.CARD_CODE_NBT_KEY));
    }
}

