/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.accessors;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.tcg.api.card.set.CardSet;
import com.pixelmonmod.tcg.api.typeadapters.BasePowerEffectTypeAdapter;
import com.pixelmonmod.tcg.api.typeadapters.CardSetTypeAdapter;
import com.pixelmonmod.tcg.duel.power.BasePowerEffect;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class CardSets {
    private static final Map<Integer, CardSet> ID_TO_CARDSET = new Int2ObjectOpenHashMap();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(CardSet.class, (Object)new CardSetTypeAdapter()).registerTypeAdapter(BasePowerEffect.class, (Object)new BasePowerEffectTypeAdapter()).create();

    public static void register(Gson gson, ResourceLocation rl, JsonElement json) {
        CardSets.register((CardSet)gson.fromJson(json, CardSet.class));
    }

    public static void register(CardSet cardSet) {
        RegistryValue.of(CardSet.class, cardSet.getName(), cardSet);
        ID_TO_CARDSET.put(cardSet.getID(), cardSet);
    }

    public static CardSet get(String name) {
        return RegistryValue.of(CardSet.class, name).getValueUnsafe();
    }

    public static CardSet get(int id) {
        return ID_TO_CARDSET.get(id);
    }

    public static List<CardSet> getAll() {
        return Lists.newArrayList(ID_TO_CARDSET.values());
    }

    public static CardSet getRandom() {
        CardSet randomElementFromCollection = RandomHelper.getRandomElementFromCollection(CardSets.getAll());
        while (!randomElementFromCollection.hasPack()) {
            randomElementFromCollection = RandomHelper.getRandomElementFromCollection(CardSets.getAll());
        }
        return randomElementFromCollection;
    }
}

