/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.structure.ultraspace;

import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.init.registry.StructurePieceTypeRegistry;
import com.pixelmonmod.pixelmon.world.generation.loot.LootTableRegistration;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class CraterGeyserPiece
extends StructurePiece {
    private final int height;
    private final int depth;

    public CraterGeyserPiece(int genDepth, BoundingBox boundingBox, int height, int depth) {
        super((StructurePieceType)StructurePieceTypeRegistry.CRATER_GEYSER.get(), genDepth, boundingBox);
        this.height = height;
        this.depth = depth;
    }

    public CraterGeyserPiece(CompoundTag tag) {
        super((StructurePieceType)StructurePieceTypeRegistry.CRATER_GEYSER.get(), tag);
        this.height = tag.m_128451_("height");
        this.depth = tag.m_128451_("depth");
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        tag.m_128405_("height", this.height);
        tag.m_128405_("depth", this.depth);
    }

    public void m_213694_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos) {
        int originY = pos.m_123342_();
        int originZ = pos.m_123343_();
        int originX = pos.m_123341_();
        BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
        int maxHeight = this.height / 2;
        int maxRadius = this.depth / 2;
        int numPoints = 900;
        int minRadius = RandomHelper.getRandomNumberBetween(10, 15);
        boolean chestPlaced = false;
        for (int h = 0; h < maxHeight; ++h) {
            double radius = (double)(maxRadius * (maxHeight - h)) / (double)maxHeight;
            if (radius < (double)minRadius) continue;
            for (int i = 0; i < numPoints; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)numPoints;
                mutablePos.m_122169_((double)originX + radius * Math.cos(angle), (double)(originY + h), (double)originZ + radius * Math.sin(angle));
                level.m_7731_((BlockPos)mutablePos, h < 6 ? Blocks.f_50543_.m_49966_() : Blocks.f_50494_.m_49966_(), 2);
            }
            int r = 0;
            while ((double)r < radius) {
                for (int i = 0; i < numPoints; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)numPoints;
                    mutablePos.m_122169_((double)originX + (double)r * Math.cos(angle), (double)(originY + h), (double)originZ + (double)r * Math.sin(angle));
                    if (!level.m_8055_((BlockPos)mutablePos).m_60713_(Blocks.f_50016_)) continue;
                    level.m_6933_((BlockPos)mutablePos, h == 0 ? Blocks.f_50450_.m_49966_() : Blocks.f_49990_.m_49966_(), 0, 0);
                    if (h != 1 || !RandomHelper.getRandomChance(0.001f) || chestPlaced) continue;
                    chestPlaced = true;
                    level.m_7731_((BlockPos)mutablePos, Blocks.f_50087_.m_49966_(), 2);
                    RandomizableContainerBlockEntity.m_222766_((BlockGetter)level, (RandomSource)random, (BlockPos)mutablePos, (ResourceLocation)LootTableRegistration.ULTRA_CRATER_GEYSER);
                }
                ++r;
            }
        }
    }
}

