/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pixelmonmod.pixelmon.world.structure.PixelmonPoolElementTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class LargerJigsawStructure
extends Structure {
    public static final int MAX_TOTAL_STRUCTURE_RANGE = 128;
    public static final Codec<LargerJigsawStructure> CODEC = ExtraCodecs.m_285994_((MapCodec)RecordCodecBuilder.mapCodec(p_227640_ -> p_227640_.group((App)LargerJigsawStructure.m_226567_((RecordCodecBuilder.Instance)p_227640_), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(p_227656_ -> p_227656_.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(p_227654_ -> p_227654_.startJigsawName), (App)Codec.intRange((int)0, (int)64).fieldOf("size").forGetter(p_227652_ -> p_227652_.maxDepth), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(p_227649_ -> p_227649_.startHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(p_227646_ -> p_227646_.useExpansionHack), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(p_227644_ -> p_227644_.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)512).fieldOf("max_distance_from_center").forGetter(p_227642_ -> p_227642_.maxDistanceFromCenter)).apply((Applicative)p_227640_, LargerJigsawStructure::new)), LargerJigsawStructure::verifyRange).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int maxDepth;
    private final HeightProvider startHeight;
    private final boolean useExpansionHack;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    private static DataResult<LargerJigsawStructure> verifyRange(LargerJigsawStructure p_286886_) {
        int i = switch (p_286886_.m_226620_()) {
            case TerrainAdjustment.NONE -> 0;
            case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> 12;
            default -> throw new IncompatibleClassChangeError();
        };
        return p_286886_.maxDistanceFromCenter + i > 512 ? DataResult.error(() -> "Structure size including terrain adaptation must not exceed 256") : DataResult.success((Object)((Object)p_286886_));
    }

    public LargerJigsawStructure(Structure.StructureSettings p_227627_, Holder<StructureTemplatePool> p_227628_, Optional<ResourceLocation> p_227629_, int p_227630_, HeightProvider p_227631_, boolean p_227632_, Optional<Heightmap.Types> p_227633_, int p_227634_) {
        super(p_227627_);
        this.startPool = p_227628_;
        this.startJigsawName = p_227629_;
        this.maxDepth = p_227630_;
        this.startHeight = p_227631_;
        this.useExpansionHack = p_227632_;
        this.projectStartToHeightmap = p_227633_;
        this.maxDistanceFromCenter = p_227634_;
    }

    public LargerJigsawStructure(Structure.StructureSettings p_227620_, Holder<StructureTemplatePool> p_227621_, int p_227622_, HeightProvider p_227623_, boolean p_227624_, Heightmap.Types p_227625_) {
        this(p_227620_, p_227621_, Optional.empty(), p_227622_, p_227623_, p_227624_, Optional.of(p_227625_), 80);
    }

    public LargerJigsawStructure(Structure.StructureSettings p_227614_, Holder<StructureTemplatePool> p_227615_, int p_227616_, HeightProvider p_227617_, boolean p_227618_) {
        this(p_227614_, p_227615_, Optional.empty(), p_227616_, p_227617_, p_227618_, Optional.empty(), 80);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext p_227636_) {
        ChunkPos chunkpos = p_227636_.f_226628_();
        int i = this.startHeight.m_213859_((RandomSource)p_227636_.f_226626_(), new WorldGenerationContext(p_227636_.f_226622_(), p_227636_.f_226629_()));
        BlockPos blockpos = new BlockPos(chunkpos.m_45604_(), i, chunkpos.m_45605_());
        return JigsawPlacement.m_227238_((Structure.GenerationContext)p_227636_, this.startPool, this.startJigsawName, (int)this.maxDepth, (BlockPos)blockpos, (boolean)this.useExpansionHack, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)PixelmonPoolElementTypes.LARGER_JIGSAW.get();
    }
}

