/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pixelmonmod.pixelmon.world.structure.PixelmonPoolElementTypes;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.JigsawReplacementProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class AdvancedMovingPoolElement
extends StructurePoolElement {
    private static final Codec<Either<ResourceLocation, StructureTemplate>> TEMPLATE_CODEC = Codec.of(AdvancedMovingPoolElement::encodeTemplate, (Decoder)ResourceLocation.f_135803_.map(Either::left));
    public static final Codec<AdvancedMovingPoolElement> CODEC = RecordCodecBuilder.create(p_210429_ -> p_210429_.group(AdvancedMovingPoolElement.templateCodec(), AdvancedMovingPoolElement.processorsCodec(), (App)AdvancedMovingPoolElement.m_210538_(), AdvancedMovingPoolElement.groundLevelDeltaCodec(), AdvancedMovingPoolElement.yHackCodec(), AdvancedMovingPoolElement.keepLiquids(), AdvancedMovingPoolElement.xHackCodec()).apply((Applicative)p_210429_, AdvancedMovingPoolElement::new));
    protected final Either<ResourceLocation, StructureTemplate> template;
    protected final Holder<StructureProcessorList> processors;
    private int groundLevelDelta;
    private int yHack;
    private int xHack;
    private boolean keepLiquids;

    private static <T> DataResult<T> encodeTemplate(Either<ResourceLocation, StructureTemplate> p_210425_, DynamicOps<T> p_210426_, T p_210427_) {
        Optional optional = p_210425_.left();
        return !optional.isPresent() ? DataResult.error(() -> "Can not serialize a runtime pool element") : ResourceLocation.f_135803_.encode((Object)((ResourceLocation)optional.get()), p_210426_, p_210427_);
    }

    protected static <E extends AdvancedMovingPoolElement> RecordCodecBuilder<E, Holder<StructureProcessorList>> processorsCodec() {
        return StructureProcessorType.f_74468_.fieldOf("processors").forGetter(p_210464_ -> p_210464_.processors);
    }

    protected static <E extends AdvancedMovingPoolElement> RecordCodecBuilder<E, Either<ResourceLocation, StructureTemplate>> templateCodec() {
        return TEMPLATE_CODEC.fieldOf("location").forGetter(p_210431_ -> p_210431_.template);
    }

    protected static <E extends AdvancedMovingPoolElement> RecordCodecBuilder<E, Integer> groundLevelDeltaCodec() {
        return Codec.INT.fieldOf("ground_level_delta").forGetter(o -> 1);
    }

    protected static <E extends AdvancedMovingPoolElement> RecordCodecBuilder<E, Integer> yHackCodec() {
        return Codec.INT.fieldOf("y_hack").forGetter(o -> 1);
    }

    protected static <E extends AdvancedMovingPoolElement> RecordCodecBuilder<E, Integer> xHackCodec() {
        return Codec.INT.fieldOf("x_hack").forGetter(o -> 1);
    }

    protected static <E extends AdvancedMovingPoolElement> RecordCodecBuilder<E, Boolean> keepLiquids() {
        return Codec.BOOL.fieldOf("keep_liquids").forGetter(o -> true);
    }

    protected AdvancedMovingPoolElement(Either<ResourceLocation, StructureTemplate> p_210415_, Holder<StructureProcessorList> p_210416_, StructureTemplatePool.Projection p_210417_, Integer groundLevelDelta, Integer yHack, Boolean keepLiquids, Integer xHack) {
        super(p_210417_);
        this.template = p_210415_;
        this.processors = p_210416_;
        this.groundLevelDelta = groundLevelDelta;
        this.yHack = yHack;
        this.xHack = xHack;
        this.keepLiquids = keepLiquids;
    }

    public int m_210540_() {
        return this.groundLevelDelta;
    }

    public Vec3i m_213577_(StructureTemplateManager p_227313_, Rotation p_227314_) {
        StructureTemplate structuretemplate = this.getTemplate(p_227313_);
        return structuretemplate.m_163808_(p_227314_);
    }

    private StructureTemplate getTemplate(StructureTemplateManager p_227300_) {
        return (StructureTemplate)this.template.map(arg_0 -> ((StructureTemplateManager)p_227300_).m_230359_(arg_0), Function.identity());
    }

    public List<StructureTemplate.StructureBlockInfo> getDataMarkers(StructureTemplateManager p_227325_, BlockPos p_227326_, Rotation p_227327_, boolean p_227328_) {
        StructureTemplate structuretemplate = this.getTemplate(p_227325_);
        ObjectArrayList list = structuretemplate.m_230335_(p_227326_, new StructurePlaceSettings().m_74379_(p_227327_), Blocks.f_50677_, p_227328_);
        ArrayList list1 = Lists.newArrayList();
        for (StructureTemplate.StructureBlockInfo structuretemplate$structureblockinfo : list) {
            StructureMode structuremode;
            CompoundTag compoundtag = structuretemplate$structureblockinfo.f_74677_();
            if (compoundtag == null || (structuremode = StructureMode.valueOf((String)compoundtag.m_128461_("mode"))) != StructureMode.DATA) continue;
            list1.add(structuretemplate$structureblockinfo);
        }
        return list1;
    }

    public List<StructureTemplate.StructureBlockInfo> m_213638_(StructureTemplateManager p_227320_, BlockPos p_227321_, Rotation p_227322_, RandomSource p_227323_) {
        StructureTemplate structuretemplate = this.getTemplate(p_227320_);
        ObjectArrayList objectarraylist = structuretemplate.m_230335_(p_227321_, new StructurePlaceSettings().m_74379_(p_227322_), Blocks.f_50678_, true);
        Util.m_214673_((ObjectArrayList)objectarraylist, (RandomSource)p_227323_);
        return objectarraylist;
    }

    public BoundingBox m_214015_(StructureTemplateManager p_227316_, BlockPos p_227317_, Rotation p_227318_) {
        StructureTemplate structuretemplate = this.getTemplate(p_227316_);
        BoundingBox boundingBox = structuretemplate.m_74633_(new StructurePlaceSettings().m_74379_(p_227318_), p_227317_);
        boundingBox.f_162360_ += this.yHack;
        boundingBox.f_162356_ -= this.xHack;
        boundingBox.f_162359_ += this.xHack;
        return boundingBox;
    }

    public boolean m_213695_(StructureTemplateManager p_227302_, WorldGenLevel p_227303_, StructureManager p_227304_, ChunkGenerator p_227305_, BlockPos p_227306_, BlockPos p_227307_, Rotation p_227308_, BoundingBox p_227309_, RandomSource p_227310_, boolean p_227311_) {
        StructurePlaceSettings structureplacesettings;
        StructureTemplate structuretemplate = this.getTemplate(p_227302_);
        if (!structuretemplate.m_230328_((ServerLevelAccessor)p_227303_, p_227306_, p_227307_, structureplacesettings = this.getSettings(p_227308_, p_227309_, p_227311_), p_227310_, 18)) {
            return false;
        }
        for (StructureTemplate.StructureBlockInfo structuretemplate$structureblockinfo : StructureTemplate.m_74517_((ServerLevelAccessor)p_227303_, (BlockPos)p_227306_, (BlockPos)p_227307_, (StructurePlaceSettings)structureplacesettings, this.getDataMarkers(p_227302_, p_227306_, p_227308_, false))) {
            this.m_227329_((LevelAccessor)p_227303_, structuretemplate$structureblockinfo, p_227306_, p_227308_, p_227310_, p_227309_);
        }
        return true;
    }

    protected StructurePlaceSettings getSettings(Rotation p_210421_, BoundingBox p_210422_, boolean p_210423_) {
        StructurePlaceSettings structureplacesettings = new StructurePlaceSettings();
        structureplacesettings.m_74381_(p_210422_);
        structureplacesettings.m_74379_(p_210421_);
        structureplacesettings.m_74402_(true);
        structureplacesettings.m_74392_(false);
        structureplacesettings.m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
        structureplacesettings.m_74405_(true);
        structureplacesettings.m_163782_(this.keepLiquids);
        if (!p_210423_) {
            structureplacesettings.m_74383_((StructureProcessor)JigsawReplacementProcessor.f_74122_);
        }
        ((StructureProcessorList)this.processors.m_203334_()).m_74425_().forEach(arg_0 -> ((StructurePlaceSettings)structureplacesettings).m_74383_(arg_0));
        this.m_210539_().m_210609_().forEach(arg_0 -> ((StructurePlaceSettings)structureplacesettings).m_74383_(arg_0));
        return structureplacesettings;
    }

    public StructurePoolElementType<?> m_207234_() {
        return (StructurePoolElementType)PixelmonPoolElementTypes.ADVANCED_MOVING.get();
    }

    public String toString() {
        return "Single[" + this.template + "]";
    }
}

