/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.listener;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.enums.BattleEndTaskType;
import com.pixelmonmod.pixelmon.api.events.PixelmonFaintEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BattleEndEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BattleStartedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBiomes;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.SpawnerCoordinator;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.WeightedSet;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.world.BlockCollection;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.ai.AggressiveAI;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.battles.status.Paralysis;
import com.pixelmonmod.pixelmon.battles.status.Poison;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import com.pixelmonmod.pixelmon.spawning.PlayerTrackingSpawner;
import com.pixelmonmod.pixelmon.world.dimension.ultraspace.UltraSpace;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class UltraSpaceListener {
    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player) || ((Player)event.getEntity()).m_7500_()) {
            return;
        }
        if (((Player)entity).m_7500_() || entity.m_5833_()) {
            return;
        }
        if (Objects.equals(entity.f_19853_.m_46472_(), UltraSpace.WORLD)) {
            boolean modifyGravity = false;
            if (!entity.m_20068_() && !entity.m_20159_()) {
                modifyGravity = true;
            }
            if (modifyGravity) {
                Vec3 movement = entity.m_20184_();
                if (!entity.m_6047_() && !entity.m_6069_()) {
                    entity.m_20256_(new Vec3(movement.m_7096_(), movement.m_7098_() + 0.07, movement.m_7094_()));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.f_19853_.m_46472_() == UltraSpace.WORLD) {
            event.setDistance(event.getDistance() / 5.0f);
            event.setDamageMultiplier(0.5f);
        }
    }

    @SubscribeEvent
    public static void onClonePlayer(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            Player old = event.getOriginal();
            Player copy = event.getEntity();
            CompoundTag persistentData = copy.getPersistentData();
            if (persistentData.m_128441_("PortalX")) {
                copy.getPersistentData().m_128365_("PortalX", old.getPersistentData().m_128423_("PortalX"));
            }
            if (persistentData.m_128441_("PortalY")) {
                copy.getPersistentData().m_128365_("PortalY", old.getPersistentData().m_128423_("PortalY"));
            }
            if (persistentData.m_128441_("PortalZ")) {
                copy.getPersistentData().m_128365_("PortalZ", old.getPersistentData().m_128423_("PortalZ"));
            }
            if (persistentData.m_128441_("PortalD")) {
                copy.getPersistentData().m_128365_("PortalD", old.getPersistentData().m_128423_("PortalD"));
            }
        }
    }

    @SubscribeEvent
    public static void onPokeFaint(PixelmonFaintEvent.Post event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (!UltraSpace.is(event.getPlayer().m_9236_())) {
            return;
        }
        PlayerPartyStorage party = StorageProxy.getPartyNow(event.getPlayer());
        BattleController battle = BattleRegistry.getBattle((Player)event.getPlayer());
        if (party.countAblePokemon() == 0) {
            if (battle != null) {
                party.addTaskForBattleEnd(BattleEndTaskType.ALWAYS_QUEUE, battleController -> UltraSpaceListener.teleportBackToOverworld(event.getPlayer()));
            } else {
                UltraSpaceListener.teleportBackToOverworld(event.getPlayer());
            }
        }
    }

    private static void teleportBackToOverworld(ServerPlayer player) {
        BlockPos respawnPosition = player.m_8961_();
        ServerLevel world = ServerLifecycleHooks.getCurrentServer().m_129880_(player.m_8963_());
        if (respawnPosition == null) {
            respawnPosition = world.m_220360_();
        }
        player.m_8999_(world, (double)respawnPosition.m_123341_(), (double)respawnPosition.m_123342_(), (double)respawnPosition.m_123343_(), player.f_19857_, player.f_19858_);
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null || !UltraSpace.is(event.getPlayer().f_19853_)) {
            return;
        }
        Player player = event.getPlayer();
        Level world = event.getPlayer().m_9236_();
        Holder biome = player.f_19853_.m_204166_(player.m_20183_());
        if (biome.m_203565_(PixelmonBiomes.ULTRA_PLANT) && event.getState().m_60713_(Blocks.f_50386_) && RandomHelper.getRandomChance(0.5)) {
            LightningBolt entity = new LightningBolt(EntityType.f_20465_, world);
            entity.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            world.m_7967_((Entity)entity);
            for (Pokemon pokemon : StorageProxy.getPartyNow((ServerPlayer)player).getAll()) {
                if (pokemon == null) continue;
                pokemon.setStatus(new Paralysis());
            }
            return;
        }
        if (biome.m_203565_(PixelmonBiomes.ULTRA_CRATER) && (event.getState().m_60713_(Blocks.f_50075_) || event.getState().m_60713_(PixelmonBlocks.aluminium_block) || event.getState().m_60713_(Blocks.f_50453_)) && RandomHelper.getRandomChance(0.5)) {
            event.getPlayer().m_7292_(new MobEffectInstance(MobEffects.f_19614_, 300, 3, false, true, true));
            event.getPlayer().m_7292_(new MobEffectInstance(MobEffects.f_19599_, 1200, 3, false, true, true));
            event.getPlayer().m_7292_(new MobEffectInstance(MobEffects.f_19610_, 200, 1, false, true, true));
            for (Pokemon pokemon : StorageProxy.getPartyNow((ServerPlayer)player).getAll()) {
                if (pokemon == null) continue;
                pokemon.setStatus(new Poison());
            }
        }
    }

    @SubscribeEvent
    public static void onBattleStart(BattleStartedEvent.Pre event) {
        PlayerParticipant player = UltraSpaceListener.findPlayer(event);
        if (player == null || !UltraSpace.is(player.player.f_19853_) || event.getTeamOne().length > 1 || event.getTeamTwo().length > 1) {
            return;
        }
        WildPixelmonParticipant wildPokemon = UltraSpaceListener.findWildPokemon(event);
        if (wildPokemon == null) {
            return;
        }
        if (PixelmonConfigProxy.getSpawning().isAlwaysAggressiveDimensions(player.player.f_19853_)) {
            wildPokemon.setBattleAI(new AggressiveAI(wildPokemon));
        }
        if (!PixelmonConfigProxy.getSpawning().isHordeBattleDimensions(player.player.f_19853_)) {
            return;
        }
        if (event.getBattleController().participants.size() > 2 || !RandomHelper.getRandomChance(PixelmonConfigProxy.getSpawning().getUltraSpaceHordeSpawnRate())) {
            return;
        }
        PixelmonEntity entity = (PixelmonEntity)wildPokemon.getEntity();
        ArrayList newWildPokemon = Lists.newArrayList();
        newWildPokemon.add(new WildPixelmonParticipant(entity));
        AbstractSpawner spawner = PixelmonSpawning.coordinator.getSpawner(player.player.m_7755_().getString());
        if (!(spawner instanceof PlayerTrackingSpawner)) {
            return;
        }
        boolean cancellation = event.isCanceled();
        event.setCanceled(true);
        PlayerTrackingSpawner pSpawner = (PlayerTrackingSpawner)spawner;
        ((CompletableFuture)spawner.getTrackedBlockCollection((Entity)player.player, 0.0f, 0.0f, pSpawner.horizontalSliceRadius, pSpawner.verticalSliceRadius, 0, 0).thenApplyAsync(blockCollection -> {
            ArrayList<SpawnLocation> spawnLocations = pSpawner.spawnLocationCalculator.calculateSpawnableLocations((BlockCollection)blockCollection);
            WeightedSet<Pair> possibleSpawns = WeightedSet.newWeightedSet(new Object[0]);
            for (SpawnLocation spawnLocation : spawnLocations) {
                ArrayList<SpawnInfo> spawns = spawner.getSuitableSpawns(spawnLocation);
                if (spawns.isEmpty()) continue;
                for (SpawnInfo spawn : spawns) {
                    possibleSpawns.add(spawn.rarity, Pair.of((Object)spawn, (Object)spawnLocation));
                }
            }
            if (possibleSpawns.isEffectivelyEmpty()) {
                event.setCanceled(cancellation);
                return null;
            }
            return possibleSpawns;
        }, (Executor)SpawnerCoordinator.PROCESSOR)).thenAcceptAsync(possibleSpawns -> {
            if (possibleSpawns == null) {
                return;
            }
            for (int i = 0; i < 4; ++i) {
                Pair spawnAction = (Pair)possibleSpawns.get();
                SpawnAction<? extends Entity> action = ((SpawnInfo)spawnAction.getFirst()).construct(spawner, (SpawnLocation)spawnAction.getSecond());
                if (!(action instanceof SpawnActionPokemon)) continue;
                PixelmonEntity spawnedEntity = (PixelmonEntity)((Object)((Object)((SpawnActionPokemon)action).getOrCreateEntity()));
                spawner.tweaks.forEach(tweak -> tweak.doTweak(spawner, action));
                spawnedEntity.m_6034_((double)((SpawnLocation)spawnAction.getSecond()).location.pos.m_123341_() + 0.5, ((SpawnLocation)spawnAction.getSecond()).location.pos.m_123342_(), (double)((SpawnLocation)spawnAction.getSecond()).location.pos.m_123343_() + 0.5);
                ((SpawnLocation)spawnAction.getSecond()).location.world.m_7967_((Entity)spawnedEntity);
                spawnedEntity.m_20049_("REMOVE_AFTER_BATTLE");
                spawner.spawnedTracker.addEntity((Entity)spawnedEntity);
                WildPixelmonParticipant nextParticipant = new WildPixelmonParticipant(spawnedEntity);
                nextParticipant.setBattleAI(new AggressiveAI(nextParticipant));
                newWildPokemon.add(nextParticipant);
            }
            BattleController controller = BattleRegistry.startBattle(newWildPokemon.toArray(new BattleParticipant[0]), new BattleParticipant[]{player}, new BattleRules(BattleType.HORDE));
            if (controller == null) {
                return;
            }
            for (BattleParticipant battleParticipant : newWildPokemon) {
                battleParticipant.bc = controller;
                for (PixelmonWrapper pixelmonWrapper : battleParticipant.allPokemon) {
                    pixelmonWrapper.bc = controller;
                    pixelmonWrapper.entity.battleController = controller;
                }
            }
            controller.sendToAll(wildPokemon.getName() + " summoned some nearby allies to assist them", new Object[0]);
        }, (Executor)ServerLifecycleHooks.getCurrentServer());
    }

    @SubscribeEvent
    public static void onBattleEnd(BattleEndEvent event) {
        for (BattleParticipant participant : event.getBattleController().participants) {
            WildPixelmonParticipant wildParticipant;
            if (!(participant instanceof WildPixelmonParticipant) || (wildParticipant = (WildPixelmonParticipant)participant).getEntity() == null || !wildParticipant.getEntity().m_19880_().contains("REMOVE_AFTER_BATTLE")) continue;
            wildParticipant.getEntity().m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @SubscribeEvent
    public static void onPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            UltraSpaceListener.updateBlock(player, event.getBlockSnapshot());
        }
    }

    @SubscribeEvent
    public static void onPlaceMultiBlock(BlockEvent.EntityMultiPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            for (BlockSnapshot snapshot : event.getReplacedBlockSnapshots()) {
                UltraSpaceListener.updateBlock(player, snapshot);
            }
        }
    }

    private static void updateBlock(ServerPlayer player, BlockSnapshot snapshot) {
        if (player.m_21205_().m_150930_(Items.f_42499_) && player.m_9236_().m_204166_(player.m_20183_()).m_203565_(PixelmonBiomes.ULTRA_DEEP_SEA) && (snapshot.getReplacedBlock().m_60713_(Blocks.f_50016_) || snapshot.getReplacedBlock().m_60713_(Blocks.f_49990_)) && (snapshot.getCurrentBlock().m_60713_(Blocks.f_50037_) || snapshot.getCurrentBlock().m_60713_(Blocks.f_50038_))) {
            player.m_9236_().m_7731_(snapshot.getPos(), PixelmonBlocks.ultra_deep_seagrass.m_49966_(), 3);
        }
    }

    private static PlayerParticipant findPlayer(BattleStartedEvent event) {
        for (BattleParticipant battleParticipant : event.getTeamOne()) {
            if (!(battleParticipant instanceof PlayerParticipant)) continue;
            return (PlayerParticipant)battleParticipant;
        }
        for (BattleParticipant battleParticipant : event.getTeamTwo()) {
            if (!(battleParticipant instanceof PlayerParticipant)) continue;
            return (PlayerParticipant)battleParticipant;
        }
        return null;
    }

    private static WildPixelmonParticipant findWildPokemon(BattleStartedEvent event) {
        for (BattleParticipant battleParticipant : event.getTeamOne()) {
            if (!(battleParticipant instanceof WildPixelmonParticipant)) continue;
            return (WildPixelmonParticipant)battleParticipant;
        }
        for (BattleParticipant battleParticipant : event.getTeamTwo()) {
            if (!(battleParticipant instanceof WildPixelmonParticipant)) continue;
            return (WildPixelmonParticipant)battleParticipant;
        }
        return null;
    }
}

