/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.listener;

import com.pixelmonmod.pixelmon.api.events.CaptureEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.EntityHelper;
import com.pixelmonmod.pixelmon.world.dimension.drowned.DrownedWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class DrownedWorldListener {
    public static final String DROWNED_LUGIA_KEY = "HalloweenLugia";

    @SubscribeEvent
    public static void onCapture(CaptureEvent.StartCapture event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (DrownedWorld.is((Level)event.getPlayer().m_284548_()) && event.getPokemon().getPalette().is("drowned") && !EntityHelper.getPersistentData((Player)event.getPlayer()).m_128471_(DROWNED_LUGIA_KEY)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        ServerPlayer player;
        LivingEntity entity = event.getEntity();
        if (entity instanceof ServerPlayer && DrownedWorld.is((player = (ServerPlayer)entity).m_9236_())) {
            if (entity.m_20186_() <= 10.0) {
                DrownedWorldListener.teleportOut(player);
            } else if (entity.m_20186_() >= 246.0) {
                DrownedWorldListener.teleportOut(player);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        ServerPlayer player;
        LivingEntity entity = event.getEntity();
        if (entity instanceof ServerPlayer && DrownedWorld.is((player = (ServerPlayer)entity).m_9236_()) && event.getSource().m_19385_().equalsIgnoreCase(entity.m_269291_().m_269063_().m_19385_()) && entity.m_21223_() <= 2.0f) {
            event.setCanceled(true);
            DrownedWorldListener.teleportOut(player);
        }
    }

    private static void teleportOut(ServerPlayer player) {
        player.m_20301_(player.m_6062_());
        player.m_5634_(player.m_21233_());
        BlockPos respawnPosition = player.m_8961_();
        ServerLevel world = ServerLifecycleHooks.getCurrentServer().m_129880_(player.m_8963_());
        if (respawnPosition == null) {
            respawnPosition = world.m_220360_();
        }
        player.m_8999_(world, (double)respawnPosition.m_123341_(), (double)respawnPosition.m_123342_(), (double)respawnPosition.m_123343_(), player.f_19857_, player.f_19858_);
    }
}

