/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.listener;

import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.world.dimension.drowned.DrownedWorld;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DrownedWorldClientListener {
    private static final ResourceLocation EXCLAMATION = ResourceLocationHelper.of("pixelmon:textures/gui/exclamation.png");
    private int ticker = 0;

    @SubscribeEvent
    public void onRenderAirBar(RenderGuiOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        if (event.getOverlay() == VanillaGuiOverlay.AIR_LEVEL.type()) {
            event.getGuiGraphics().m_280168_().m_85836_();
            if (mc.f_91073_ != null && DrownedWorld.WORLD == mc.f_91073_.m_46472_() && mc.f_91074_ != null && mc.f_91074_.m_5842_() && !mc.f_91074_.m_6040_()) {
                boolean drawHPWarning;
                ++this.ticker;
                double air = (double)mc.f_91074_.m_20146_() / (double)mc.f_91074_.m_6062_();
                double hp = mc.f_91074_.m_21223_() / mc.f_91074_.m_21233_();
                boolean flicker = this.ticker % 100 > 50;
                boolean drawAirWarning = air > 0.5 || flicker;
                boolean bl = drawHPWarning = air <= 0.0 && (hp > 0.5 || flicker);
                if (drawAirWarning) {
                    ScreenHelper.drawImage(EXCLAMATION, event.getGuiGraphics(), (float)event.getWindow().m_85445_() / 2.0f + 91.0f, (float)(event.getWindow().m_85446_() - ((ForgeGui)Minecraft.m_91087_().f_91065_).rightHeight), 9.0f, 9.0f, 0.0f);
                }
                if (drawHPWarning) {
                    ScreenHelper.drawImage(EXCLAMATION, event.getGuiGraphics(), (float)event.getWindow().m_85445_() / 2.0f - 100.0f, (float)(event.getWindow().m_85446_() - ((ForgeGui)Minecraft.m_91087_().f_91065_).rightHeight + 10), 9.0f, 9.0f, 0.0f);
                }
            } else {
                this.ticker = 0;
            }
        }
    }

    @SubscribeEvent
    public void onRenderAirBarPost(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() == VanillaGuiOverlay.AIR_LEVEL.type()) {
            event.getGuiGraphics().m_280168_().m_85849_();
        }
    }

    @SubscribeEvent
    public void onRenderFog(ViewportEvent.RenderFog event) {
        if (DrownedWorld.is((Level)Minecraft.m_91087_().f_91073_)) {
            event.setCanceled(true);
            Minecraft.m_91087_().f_91074_.f_19853_.m_204166_(Minecraft.m_91087_().f_91074_.m_20183_()).m_203543_().ifPresent(biome -> {
                event.setCanceled(true);
                if (biome.m_135782_().toString().contains("drowned_crimson")) {
                    event.setNearPlaneDistance(0.07725f);
                } else if (biome.m_135782_().toString().contains("drowned_warm")) {
                    event.setNearPlaneDistance(0.057f);
                } else if (biome.m_135782_().toString().contains("drowned_dark")) {
                    event.setNearPlaneDistance(0.059f);
                } else {
                    event.setCanceled(false);
                }
            });
        }
    }
}

