/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation.features.ultraspace.plant;

import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class PlantXurkitreeFeature
extends Feature<NoneFeatureConfiguration> {
    public PlantXurkitreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        return this.place(context.m_159774_(), context.m_159775_(), context.m_225041_(), context.m_159777_(), (NoneFeatureConfiguration)context.m_159778_());
    }

    public boolean place(WorldGenLevel level, ChunkGenerator generator, RandomSource random, BlockPos pos, NoneFeatureConfiguration config) {
        int i;
        BlockState blockState;
        if (!RandomHelper.getRandomChance(0.05f)) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
        while (mutablePos.m_123342_() > 20 && ((blockState = level.m_8055_((BlockPos)mutablePos)).m_60713_(Blocks.f_50016_) || blockState.m_60713_(Blocks.f_49990_))) {
            mutablePos.m_142448_(mutablePos.m_123342_() - 1);
        }
        int radius = RandomHelper.getRandomNumberBetween(20, 40);
        int points = RandomHelper.getRandomNumberBetween(5, 7);
        int biggestY = -1;
        for (int i2 = 0; i2 < points; ++i2) {
            int startingX = (int)Math.round((double)pos.m_123341_() + (double)radius * Math.cos(Math.PI * 2 * (double)i2 / (double)points));
            int startingZ = (int)Math.round((double)pos.m_123343_() + (double)radius * Math.sin(Math.PI * 2 * (double)i2 / (double)points));
            int currentX = startingX;
            int currentZ = startingZ;
            int lastY = -1;
            while (currentX != pos.m_123341_() || currentZ != pos.m_123343_()) {
                int distance = (int)Math.sqrt(Math.pow(currentX - pos.m_123341_(), 2.0) + Math.pow(currentZ - pos.m_123343_(), 2.0));
                int y = (int)((double)radius - Math.sqrt((double)(2 * radius) * (double)distance));
                if (lastY != -1) {
                    for (int deltaY = lastY; deltaY < y; ++deltaY) {
                        BlockState blockState2 = Blocks.f_50730_.m_49966_();
                        if (deltaY % 5 == 0) {
                            blockState2 = Blocks.f_50386_.m_49966_();
                        }
                        this.m_5974_((LevelWriter)level, (BlockPos)mutablePos.m_122178_(currentX, pos.m_123342_() + deltaY, currentZ), blockState2);
                    }
                }
                lastY = y;
                if (y > biggestY) {
                    biggestY = y;
                }
                BlockState blockState3 = Blocks.f_50730_.m_49966_();
                if (y % 5 == 0) {
                    blockState3 = Blocks.f_50386_.m_49966_();
                }
                this.m_5974_((LevelWriter)level, (BlockPos)mutablePos.m_122178_(currentX, pos.m_123342_() + y, currentZ), blockState3);
                if (currentX < pos.m_123341_()) {
                    ++currentX;
                } else if (currentX > pos.m_123341_()) {
                    --currentX;
                }
                if (currentZ < pos.m_123343_()) {
                    ++currentZ;
                    continue;
                }
                if (currentZ <= pos.m_123343_()) continue;
                --currentZ;
            }
        }
        double[] xCoords = new double[10];
        double[] yCoords = new double[10];
        double starRadius = 4.0;
        double centerX = 0.0;
        double centerY = 0.0;
        int smallStarRadius = 2;
        for (double x = (double)(-smallStarRadius); x <= (double)smallStarRadius; x += 1.0) {
            for (double y = (double)(-smallStarRadius); y <= (double)smallStarRadius; y += 1.0) {
                for (double z = (double)(-smallStarRadius); z <= (double)smallStarRadius; z += 1.0) {
                    double distance = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0));
                    if (!(distance <= (double)smallStarRadius)) continue;
                    this.m_5974_((LevelWriter)level, (BlockPos)mutablePos.m_122169_((double)pos.m_123341_() + x, (double)pos.m_123342_() + ((double)biggestY + 0.5 * (double)smallStarRadius) + y, (double)pos.m_123343_() + z), Blocks.f_50386_.m_49966_());
                }
            }
        }
        this.m_5974_((LevelWriter)level, (BlockPos)mutablePos.m_122169_((double)pos.m_123341_(), (double)pos.m_123342_() + ((double)biggestY + 0.5 * (double)smallStarRadius), (double)pos.m_123343_()), random.m_188499_() ? Blocks.f_50722_.m_49966_() : Blocks.f_50090_.m_49966_());
        for (int i3 = 0; i3 < 10; ++i3) {
            double theta = (double)i3 * Math.PI / 5.0;
            xCoords[i3] = centerX + starRadius * Math.sin(theta);
            yCoords[i3] = centerY + starRadius * Math.cos(theta);
        }
        double[] zCoords = new double[10];
        for (i = 0; i < 10; ++i) {
            zCoords[i] = ((double)random.m_188501_() - 0.5) * (double)i * 1.5;
        }
        for (i = 0; i < 10; ++i) {
            this.m_5974_((LevelWriter)level, (BlockPos)mutablePos.m_122169_((double)pos.m_123341_() + xCoords[i], (double)pos.m_123342_() + ((double)biggestY + 0.5 * (double)smallStarRadius) + yCoords[i], (double)pos.m_123343_() + zCoords[i]), Blocks.f_50386_.m_49966_());
        }
        return true;
    }
}

