/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation.features.ultraspace.plant;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.TumblestoneBlock;
import com.pixelmonmod.pixelmon.init.registry.BlockRegistration;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraftforge.registries.RegistryObject;

public class PlantMonolithFeature
extends Feature<NoneFeatureConfiguration> {
    private static final ResourceLocation LOOT_TABLE = ResourceLocationHelper.of("pixelmon", "chests/ultraspace/plant_monolith");

    public PlantMonolithFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        return this.place(context.m_159774_(), context.m_159775_(), context.m_225041_(), context.m_159777_(), (NoneFeatureConfiguration)context.m_159778_());
    }

    public boolean place(WorldGenLevel level, ChunkGenerator generator, RandomSource random, BlockPos pos, NoneFeatureConfiguration config) {
        BlockState blockState;
        if (!RandomHelper.getRandomChance(0.025f)) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
        while (mutablePos.m_123342_() > 20 && ((blockState = level.m_8055_((BlockPos)mutablePos)).m_60713_(Blocks.f_50016_) || blockState.m_60713_(Blocks.f_49990_))) {
            mutablePos.m_142448_(mutablePos.m_123342_() - 1);
        }
        int originY = mutablePos.m_123342_();
        int radius = RandomHelper.getRandomNumberBetween(5, 15);
        int height = this.generateSphereWithRadius(level, mutablePos, pos, radius, 65, 90);
        int tumblestone = RandomHelper.getRandomNumberBetween(5, (int)(0.75 * (double)radius));
        for (int i = 0; i < tumblestone; ++i) {
            int randomX = RandomHelper.getRandomNumberBetween(0, 2 * radius) - radius;
            int randomZ = RandomHelper.getRandomNumberBetween(0, 2 * radius) - radius;
            while (randomX * randomX + randomZ * randomZ - (radius - 1) * (radius - 1) >= 0) {
                randomX = RandomHelper.getRandomNumberBetween(0, 2 * radius) - radius;
                randomZ = RandomHelper.getRandomNumberBetween(0, 2 * radius) - radius;
            }
            this.m_5974_((LevelWriter)level, (BlockPos)mutablePos.m_122178_(pos.m_123341_() + randomX, originY + height, pos.m_123343_() + randomZ), (BlockState)this.getRandomTumblestone().m_49966_().m_61124_((Property)TumblestoneBlock.AGE, (Comparable)Integer.valueOf(5)));
        }
        if (RandomHelper.getRandomChance(0.25f)) {
            int randomX = RandomHelper.getRandomNumberBetween(0, 2 * radius) - radius;
            int randomZ = RandomHelper.getRandomNumberBetween(0, 2 * radius) - radius;
            while (randomX * randomX + randomZ * randomZ - (radius - 1) * (radius - 1) >= 0) {
                randomX = RandomHelper.getRandomNumberBetween(0, 2 * radius) - radius;
                randomZ = RandomHelper.getRandomNumberBetween(0, 2 * radius) - radius;
            }
            this.m_5974_((LevelWriter)level, (BlockPos)mutablePos.m_122178_(pos.m_123341_() + randomX, originY + height, pos.m_123343_() + randomZ), Blocks.f_50087_.m_49966_());
            RandomizableContainerBlockEntity.m_222766_((BlockGetter)level, (RandomSource)random, (BlockPos)mutablePos, (ResourceLocation)LOOT_TABLE);
        }
        return true;
    }

    private int generateSphereWithRadius(WorldGenLevel level, BlockPos.MutableBlockPos mutablePos, BlockPos pos, int radius, int minHeight, int maxHeight) {
        int originalY = mutablePos.m_123342_();
        int height = RandomHelper.getRandomNumberBetween(minHeight, maxHeight);
        for (int y = 0; y < height; ++y) {
            mutablePos.m_142448_(originalY + y);
            int calculatedRadius = radius + Math.max(0, height / 10 - y / radius);
            for (int x = -calculatedRadius; x < calculatedRadius; ++x) {
                for (int z = -calculatedRadius; z < calculatedRadius; ++z) {
                    mutablePos.m_142451_(pos.m_123341_() + x);
                    mutablePos.m_142443_(pos.m_123343_() + z);
                    if (x * x + z * z - (calculatedRadius - 1) * (calculatedRadius - 1) >= 0) continue;
                    this.m_5974_((LevelWriter)level, (BlockPos)mutablePos, Blocks.f_50080_.m_49966_());
                }
            }
        }
        return height;
    }

    private Block getRandomTumblestone() {
        return (Block)((RegistryObject)RandomHelper.getRandomElementFromCollection(Lists.newArrayList((Object[])new RegistryObject[]{BlockRegistration.BLACK_TUMBLESTONE, BlockRegistration.BLUE_TUMBLESTONE, BlockRegistration.RED_TUMBLESTONE}))).get();
    }
}

