/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation.features.ultraspace.crater;

import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CraterMonolithFeature
extends Feature<NoneFeatureConfiguration> {
    public CraterMonolithFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        return this.place(context.m_159774_(), context.m_159775_(), context.m_225041_(), context.m_159777_(), (NoneFeatureConfiguration)context.m_159778_());
    }

    public boolean place(WorldGenLevel level, ChunkGenerator generator, RandomSource random, BlockPos pos, NoneFeatureConfiguration config) {
        BlockState blockState;
        if (!RandomHelper.getRandomChance(0.05f)) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
        while (mutablePos.m_123342_() > 20 && ((blockState = level.m_8055_((BlockPos)mutablePos)).m_60713_(Blocks.f_50016_) || blockState.m_60713_(Blocks.f_49990_))) {
            mutablePos.m_142448_(mutablePos.m_123342_() - 1);
        }
        this.generateSphereWithRadius(level, mutablePos, pos, 8, 20, 30);
        this.generateSphereWithRadius(level, mutablePos, pos, 7, 15, 20);
        this.generateSphereWithRadius(level, mutablePos, pos, 6, 10, 15);
        this.generateSphereWithRadius(level, mutablePos, pos, 5, 8, 9);
        this.generateSphereWithRadius(level, mutablePos, pos, 4, 6, 7);
        this.generateSphereWithRadius(level, mutablePos, pos, 3, 4, 6);
        this.generateSphereWithRadius(level, mutablePos, pos, 2, 2, 4);
        return true;
    }

    private void generateSphereWithRadius(WorldGenLevel level, BlockPos.MutableBlockPos mutablePos, BlockPos pos, int radius, int minHeight, int maxHeight) {
        int originalY = mutablePos.m_123342_();
        int height = RandomHelper.getRandomNumberBetween(minHeight, maxHeight);
        for (int y = mutablePos.m_123342_(); y < originalY + height; ++y) {
            mutablePos.m_142448_(y);
            for (int x = -radius; x < radius; ++x) {
                for (int z = -radius; z < radius; ++z) {
                    mutablePos.m_142451_(pos.m_123341_() + x);
                    mutablePos.m_142443_(pos.m_123343_() + z);
                    if (x * x + z * z - (radius - 1) * (radius - 1) >= 0) continue;
                    if (RandomHelper.getRandomChance(0.75f)) {
                        this.m_5974_((LevelWriter)level, (BlockPos)mutablePos, Blocks.f_50504_.m_49966_());
                        continue;
                    }
                    this.m_5974_((LevelWriter)level, (BlockPos)mutablePos, Blocks.f_50573_.m_49966_());
                }
            }
        }
    }
}

