/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation.features.ultraspace.crater;

import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CraterMetalPipeFeature
extends Feature<NoneFeatureConfiguration> {
    public CraterMetalPipeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        return this.place(context.m_159774_(), context.m_159775_(), context.m_225041_(), context.m_159777_(), (NoneFeatureConfiguration)context.m_159778_());
    }

    public boolean place(WorldGenLevel level, ChunkGenerator generator, RandomSource random, BlockPos pos, NoneFeatureConfiguration config) {
        BlockState blockState;
        if (!RandomHelper.getRandomChance(0.05f)) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
        while (mutablePos.m_123342_() > 20 && ((blockState = level.m_8055_((BlockPos)mutablePos)).m_60713_(Blocks.f_50016_) || blockState.m_60713_(Blocks.f_49990_))) {
            mutablePos.m_142448_(mutablePos.m_123342_() - 1);
        }
        int originY = mutablePos.m_123342_() + random.m_188503_(8);
        int originZ = mutablePos.m_123343_();
        int originX = mutablePos.m_123341_();
        boolean xDirection = random.m_188499_();
        int coil = RandomHelper.getRandomNumberBetween(1, 4);
        BlockState randomBlock = this.getRandomBlock().m_49966_();
        for (int length = -10; length <= 0; ++length) {
            for (double i = 0.0; i <= Math.PI * 2; i += 0.05235987755982988) {
                double radius = 3.5 * Math.sin(i);
                double y = 3.5 * Math.cos(i) + (double)(length / coil);
                if (xDirection) {
                    mutablePos.m_142451_(originX + length);
                    mutablePos.m_142443_((int)((double)originZ + radius));
                } else {
                    mutablePos.m_142443_(originZ + length);
                    mutablePos.m_142451_((int)((double)originX + radius));
                }
                mutablePos.m_142448_((int)((double)originY + y));
                this.m_5974_((LevelWriter)level, (BlockPos)mutablePos, randomBlock);
                if (xDirection) {
                    mutablePos.m_142451_(originX - length);
                } else {
                    mutablePos.m_142443_(originZ - length);
                }
                this.m_5974_((LevelWriter)level, (BlockPos)mutablePos, randomBlock);
            }
        }
        return true;
    }

    private Block getRandomBlock() {
        if (RandomHelper.getRandomChance(0.45f)) {
            return Blocks.f_50075_;
        }
        if (RandomHelper.getRandomChance(0.45f)) {
            return PixelmonBlocks.aluminium_block;
        }
        if (RandomHelper.getRandomChance(0.05f)) {
            return PixelmonBlocks.silver_block;
        }
        if (RandomHelper.getRandomChance(0.05f)) {
            return PixelmonBlocks.platinum_block;
        }
        return Blocks.f_50453_;
    }
}

