/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation.features.ultraspace.crater;

import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CraterGyserFeature
extends Feature<NoneFeatureConfiguration> {
    public CraterGyserFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        return this.place(context.m_159774_(), context.m_159775_(), context.m_225041_(), context.m_159777_(), (NoneFeatureConfiguration)context.m_159778_());
    }

    public boolean place(WorldGenLevel level, ChunkGenerator generator, RandomSource random, BlockPos pos, NoneFeatureConfiguration config) {
        BlockState blockState;
        if (!RandomHelper.getRandomChance(0.015f)) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
        while (mutablePos.m_123342_() > 20 && ((blockState = level.m_8055_((BlockPos)mutablePos)).m_60713_(Blocks.f_50016_) || blockState.m_60713_(Blocks.f_49990_))) {
            mutablePos.m_142448_(mutablePos.m_123342_() - 1);
        }
        int originY = mutablePos.m_123342_();
        int originZ = mutablePos.m_123343_();
        int originX = mutablePos.m_123341_();
        int maxHeight = RandomHelper.getRandomNumberBetween(10, 40);
        int maxRadius = RandomHelper.getRandomNumberBetween(10, 30);
        int numPoints = 900;
        int minRadius = RandomHelper.getRandomNumberBetween(10, 15);
        for (int h = 0; h < maxHeight; ++h) {
            double radius = (double)(maxRadius * (maxHeight - h)) / (double)maxHeight;
            if (radius < (double)minRadius) continue;
            for (int i = 0; i < numPoints; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)numPoints;
                mutablePos.m_122169_((double)originX + radius * Math.cos(angle), (double)(originY + h), (double)originZ + radius * Math.sin(angle));
                this.m_5974_((LevelWriter)level, (BlockPos)mutablePos, Blocks.f_50504_.m_49966_());
            }
            int r = 0;
            while ((double)r < radius) {
                for (int i = 0; i < numPoints; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)numPoints;
                    mutablePos.m_122169_((double)originX + (double)r * Math.cos(angle), (double)(originY + h), (double)originZ + (double)r * Math.sin(angle));
                    if (!level.m_8055_((BlockPos)mutablePos).m_60713_(Blocks.f_50016_)) continue;
                    this.m_5974_((LevelWriter)level, (BlockPos)mutablePos, h == 0 ? Blocks.f_50450_.m_49966_() : Blocks.f_49990_.m_49966_());
                }
                ++r;
            }
        }
        return true;
    }
}

