/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation.features.tree.berry.foliage;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraftforge.registries.RegistryObject;

public abstract class AbstractComplexTreeFoliagePlacer
extends FoliagePlacer {
    private static final IntProvider RADIUS = ConstantInt.m_146483_((int)2);
    private static final IntProvider OFFSET = ConstantInt.m_146483_((int)0);
    private RegistryObject<FoliagePlacerType<?>> foliagePlacerType;
    private final int foliageHeight;
    private final List<Pair<BlockPos, BlockState>> foliagePositions = Lists.newArrayList();
    private final List<Integer> fullRows = Lists.newArrayList();

    public AbstractComplexTreeFoliagePlacer(RegistryObject<FoliagePlacerType<?>> foliagePlacerType, int foliageHeight, List<Integer> fullRows, Pair<BlockPos, BlockState> ... foliagePositions) {
        super(RADIUS, OFFSET);
        this.foliagePlacerType = foliagePlacerType;
        this.foliageHeight = foliageHeight;
        this.foliagePositions.addAll(Arrays.asList(foliagePositions));
        this.fullRows.addAll(fullRows);
    }

    protected FoliagePlacerType<?> m_5897_() {
        return FoliagePlacerType.f_68594_;
    }

    protected void m_213633_(LevelSimulatedReader worldGenReader, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, int unknown, FoliagePlacer.FoliageAttachment foliage, int foliageHeight, int radius, int treeTopHeight) {
        Boolean doubleTrunk = foliage.m_68590_();
        BlockPos foliagePos = foliage.m_161451_();
        for (Integer n : this.fullRows) {
            this.m_225628_(worldGenReader, setter, random, config, foliagePos, 2, n, doubleTrunk);
        }
        for (Pair pair : this.foliagePositions) {
            this.setBlock(worldGenReader, setter, random, config, foliagePos.m_121955_((Vec3i)pair.getFirst()).m_122032_(), (BlockState)pair.getSecond());
        }
    }

    private void setBlock(LevelSimulatedReader worldGenReader, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, BlockPos.MutableBlockPos pos, BlockState state) {
        if (TreeFeature.m_67272_((LevelSimulatedReader)worldGenReader, (BlockPos)pos)) {
            setter.m_271838_((BlockPos)pos, state == null ? config.f_161213_.m_213972_(random, (BlockPos)pos) : state);
        }
    }

    public int m_214116_(RandomSource p_230374_1_, int p_230374_2_, TreeConfiguration p_230374_3_) {
        return this.foliageHeight;
    }

    protected boolean m_214203_(RandomSource random, int x, int y, int z, int radius, boolean doubleTrunk) {
        return x * x + z * z > radius;
    }
}

